/*
 * Decompiled with CFR 0.152.
 */
package plug.core.execution;

import announce4j.Announcer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import plug.core.IConfiguration;
import plug.core.IStateSpaceManager;
import plug.core.RuntimeDescription;
import plug.core.execution.ExecutionDescription;
import plug.core.execution.IExecutionViewContext;
import plug.events.ExecutionEndedEvent;
import plug.events.PropertyEvent;
import plug.statespace.SimpleStateSpaceManager;
import plug.utils.graph.algorithms.DijkstraShortestPath;
import plug.verifiers.deadlock.FinalStateDetected;

public class Execution {
    protected final String name;
    protected final RuntimeDescription description;
    protected final ExecutionDescription module;
    protected IStateSpaceManager stateSpaceManager;
    protected IExecutionViewContext context = null;
    protected Status status = Status.idle;
    protected ResultStatus resultStatus = ResultStatus.none;
    protected long startTime = 0L;
    protected long endTime = 0L;
    protected final List<PropertyEvent<?, ?>> propertyEvents = new ArrayList();
    protected final List<Throwable> errors = new ArrayList<Throwable>();
    protected Thread thread;

    public Execution(String name, RuntimeDescription description, ExecutionDescription module) {
        this.name = name;
        this.description = description;
        this.module = module;
        this.reset();
    }

    public String getName() {
        return this.name;
    }

    public RuntimeDescription getDescription() {
        return this.description;
    }

    public ExecutionDescription getModule() {
        return this.module;
    }

    public Status status() {
        return this.status;
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    public VerificationStatus verificationStatus() {
        if (this.propertyEvents.isEmpty()) {
            return VerificationStatus.unknown;
        }
        for (PropertyEvent<?, ?> propertyEvent : this.propertyEvents) {
            if (propertyEvent.isVerified()) continue;
            return VerificationStatus.violated;
        }
        return VerificationStatus.verified;
    }

    public ResultStatus resultStatus() {
        return this.resultStatus;
    }

    public synchronized IExecutionViewContext getOrInitContext() {
        if (this.context == null) {
            try {
                this.context = new IExecutionViewContext.Simple(this.description, this.module, this.stateSpaceManager);
            }
            catch (Throwable e) {
                this.addError(e);
                return null;
            }
        }
        return this.context;
    }

    public IExecutionViewContext getContext() {
        return this.context;
    }

    public synchronized void start(BiConsumer<Execution, Boolean> onDone, BiConsumer<Execution, Object> onEvent) {
        if (this.status == Status.idle) {
            this.reset();
            this.thread = new Thread(() -> {
                block5: {
                    try {
                        IExecutionViewContext context = this.getOrInitContext();
                        if (context != null) {
                            Announcer announcer = context.getAnnouncer();
                            announcer.when(ExecutionEndedEvent.class, (a, event) -> {
                                this.endTime = System.currentTimeMillis();
                                this.status = Status.idle;
                                if (this.resultStatus == ResultStatus.none) {
                                    this.resultStatus = ResultStatus.complete;
                                }
                                if (onDone != null) {
                                    onDone.accept(this, false);
                                }
                            });
                            announcer.when(PropertyEvent.class, (a, event) -> {
                                this.propertyEvents.add((PropertyEvent<?, ?>)event);
                                if (onEvent != null) {
                                    onEvent.accept(this, event);
                                }
                            });
                            announcer.when(FinalStateDetected.class, (a, event) -> {
                                IStateSpaceManager<IConfiguration, Object> stateSpaceManager = context.getController().getStateSpaceManager();
                                Set<IConfiguration> initialConfigurations = stateSpaceManager.initialConfigurations();
                                if (initialConfigurations.size() > 1) {
                                    System.err.println("[Unsupported yet] Multiple initial configuration in deadlock counter-example creation");
                                }
                                Object finalState = event.getFinalState();
                                List counterExample = initialConfigurations.isEmpty() ? Collections.singletonList(finalState) : new DijkstraShortestPath().getShortestPath(stateSpaceManager.getGraphView(), (Object)initialConfigurations.iterator().next(), finalState);
                                PropertyEvent<IConfiguration, Object> deadlock = new PropertyEvent<IConfiguration, Object>(context.getController(), false, "deadlock", counterExample);
                                this.propertyEvents.add(deadlock);
                                if (onEvent != null) {
                                    onEvent.accept(this, event);
                                }
                            });
                            this.startTime = System.currentTimeMillis();
                            this.status = Status.running;
                            context.getController().execute();
                        } else if (onDone != null) {
                            onDone.accept(this, false);
                        }
                    }
                    catch (Throwable e) {
                        this.addError(e);
                        if (onDone == null) break block5;
                        onDone.accept(this, false);
                    }
                }
            });
            this.status = Status.building;
            this.thread.start();
        }
    }

    public synchronized void pause() {
        if (this.status == Status.running) {
            this.getContext().getController().getMonitor().pause();
            this.status = Status.paused;
        }
    }

    public synchronized void resume() {
        if (this.status == Status.paused) {
            this.getContext().getController().getMonitor().resume();
            this.status = Status.running;
        }
    }

    public synchronized void cancel() {
        if (this.status == Status.paused || this.status == Status.running) {
            this.resultStatus = ResultStatus.cancelled;
            this.getContext().getController().getMonitor().hasToFinish();
        }
    }

    public void reset() {
        this.status = Status.idle;
        this.resultStatus = ResultStatus.none;
        this.startTime = 0L;
        this.endTime = 0L;
        this.stateSpaceManager = new SimpleStateSpaceManager(true);
        this.propertyEvents.clear();
        this.errors.clear();
        if (this.getContext() != null && this.getContext().getRuntime() != null) {
            this.getContext().getRuntime().close();
        }
        this.context = null;
    }

    public List<IConfiguration> counterExample() {
        return this.propertyEvents.isEmpty() || this.propertyEvents.get(0).isVerified() ? null : this.propertyEvents.get(0).getCounterExample();
    }

    public long elapsedTime() {
        return this.startTime == 0L ? 0L : (this.endTime == 0L ? System.currentTimeMillis() - this.startTime : this.endTime - this.startTime);
    }

    public String resultDescription() {
        int size;
        if (this.context == null) {
            return "No result yet";
        }
        StringBuilder result = new StringBuilder();
        if (this.resultStatus == ResultStatus.cancelled) {
            result.append("Incomplete ");
        }
        if ((size = this.context.getController().getStateSpaceManager().size()) > 0) {
            result.append(size);
            result.append(" configurations ");
            result.append("in ");
            result.append(this.elapsedTime());
            result.append(" ms");
        } else if (this.status == Status.building) {
            result.append("Building");
        } else {
            result.append("No configurations");
        }
        return result.toString();
    }

    protected void addError(Throwable e) {
        if (!this.errors.contains(e)) {
            this.errors.add(e);
        }
        this.status = Status.error;
    }

    public String toString() {
        return "Execution " + this.name + ": " + (Object)((Object)this.status) + "/" + (Object)((Object)this.verificationStatus());
    }

    public static enum ResultStatus {
        none,
        complete,
        cancelled;

    }

    public static enum VerificationStatus {
        verified,
        violated,
        unknown;

    }

    public static enum Status {
        idle,
        paused,
        building,
        running,
        error;

    }
}

