/*
 * Decompiled with CFR 0.152.
 */
package plug.core;

import java.nio.file.Path;
import java.util.Map;
import java.util.function.Supplier;
import plug.core.IConfiguration;
import plug.core.ILanguagePlugin;
import plug.core.ITransitionRelation;
import plug.core.registry.LanguageModuleRegistry;

public class RuntimeDescription {
    protected final Path modelPath;
    protected final ILanguagePlugin module;
    protected final Map<String, Object> options;
    protected Supplier<ITransitionRelation> supplier;

    public RuntimeDescription(Path modelPath) {
        this(modelPath, null);
    }

    public RuntimeDescription(Path modelPath, Map<String, Object> options) {
        this.modelPath = modelPath;
        this.module = LanguageModuleRegistry.getInstance().getModuleByExtension(modelPath);
        this.options = options;
        this.supplier = null;
    }

    public RuntimeDescription(ILanguagePlugin module, Supplier<ITransitionRelation> supplier) {
        this.modelPath = null;
        this.options = null;
        this.supplier = supplier;
        this.module = module;
    }

    public ITransitionRelation<IConfiguration, Object> getRuntime() throws Exception {
        if (this.supplier != null) {
            return this.supplier.get();
        }
        return this.module.getLoader().getRuntime(this.modelPath.toUri(), this.options);
    }

    public ILanguagePlugin getModule() {
        return this.module;
    }
}

