/*
 * Decompiled with CFR 0.152.
 */
package plug.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import plug.core.ILanguageLoader;
import plug.core.IRuntimeView;
import plug.core.ITransitionRelation;
import plug.core.execution.ExecutionDescription;
import plug.explorer.BFSExplorer;
import plug.explorer.DFSExplorer;
import plug.verifiers.deadlock.DeadlockVerifier;

public interface ILanguagePlugin<T extends ITransitionRelation> {
    public String getName();

    public String[] getExtensions();

    public ILanguageLoader<T> getLoader();

    public IRuntimeView getRuntimeView(T var1);

    default public Collection<ExecutionDescription> executions() {
        return ILanguagePlugin.defaultExecutions();
    }

    public static List<ExecutionDescription> defaultExecutions() {
        return Arrays.asList(new ExecutionDescription("BFS Explorer", BFSExplorer::new), new ExecutionDescription("Deadlocks", DeadlockVerifier::bfs), new ExecutionDescription("DFS Explorer", DFSExplorer::new));
    }
}

