/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.printer.fiacre;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.toolbox.tools.printer.fiacre.HelperBus;
import obp.fiacre.model.BoolLiteral;
import obp.fiacre.model.CaseStmt;
import obp.fiacre.model.ComponentDecl;
import obp.fiacre.model.Declaration;
import obp.fiacre.model.Exp;
import obp.fiacre.model.NodeDecl;
import obp.fiacre.model.NullStmt;
import obp.fiacre.model.Pattern;
import obp.fiacre.model.Program;
import obp.fiacre.model.Rule;
import obp.fiacre.model.Statement;

public class AEFD2Fiacre {
    private HelperBus helper = new HelperBus(this);

    private void moveEnvFirst(AEFDModel model) {
        AEFDAutomate env = null;
        for (AEFDAutomate automate : model.getAllAutomates()) {
            if (!automate.getName().equals("Environment")) continue;
            env = automate;
            break;
        }
        if (model.getAllAutomates().remove(env)) {
            model.getAllAutomates().addFirst(env);
        }
    }

    public Program generateProgram(AEFDModel model) {
        this.moveEnvFirst(model);
        Program program = new Program();
        this.helper.events.generate(model, "Event", "EventFIFO");
        this.helper.booleanVariablesArray.generate(model, "BooleanVariablesArray", "boolVar");
        this.helper.processEnabledArray.generate(model, "ProcessEnabledArray", "isEnabled");
        this.helper.processes.generate(model);
        this.helper.scheduler.generate(model);
        program.addDeclaration((Declaration)this.helper.events.getUnionDeclaration());
        program.addDeclaration((Declaration)this.helper.events.getFifoTypeDeclaration());
        for (Declaration declaration : this.helper.booleanVariablesArray.getAllConstantDeclarations()) {
            program.addDeclaration(declaration);
        }
        program.addDeclaration((Declaration)this.helper.booleanVariablesArray.getArrayDeclaration());
        for (Declaration declaration : this.helper.processEnabledArray.getAllConstantDeclarations()) {
            program.addDeclaration(declaration);
        }
        program.addDeclaration((Declaration)this.helper.processEnabledArray.getArrayDeclaration());
        for (AEFDAutomate aEFDAutomate : model.getAllAutomates()) {
            program.addDeclaration((Declaration)this.helper.processes.getProcessDecl(aEFDAutomate));
        }
        program.addDeclaration((Declaration)this.helper.scheduler.getProcessDecl());
        ComponentDecl topLevelComponent = this.helper.component.generate(model);
        program.addDeclaration((Declaration)topLevelComponent);
        program.setRoot((NodeDecl)topLevelComponent);
        return program;
    }

    protected CaseStmt on(Exp exp) {
        CaseStmt caseStmt = new CaseStmt();
        caseStmt.setExp(exp);
        Rule rule = new Rule();
        BoolLiteral b = new BoolLiteral();
        b.setValue(true);
        rule.setLhs((Pattern)b);
        rule.setAction((Statement)new NullStmt());
        caseStmt.addRule(rule);
        return caseStmt;
    }
}

