/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.handler;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.AEFDModelObject;
import fr.ensta.aefd.toolbox.tools.printer.ExtendedAEFDTXTPrinter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ModelHandles {
    public static final String PRETTY_PRINT = "prettyPrintExtAEFD";
    private final AEFDModel model;
    private final List<String> logs = new LinkedList<String>();
    private final Map<Integer, Item> modelItems = new HashMap<Integer, Item>();
    private final ExtendedAEFDTXTPrinter printer = new ExtendedAEFDTXTPrinter();
    private final Map<AEFDModelObject, List<Integer>> logMap = new HashMap<AEFDModelObject, List<Integer>>();
    private final Map<String, Item> lastItemMap = new HashMap<String, Item>();
    private final Map<String, String> extraFiles = new HashMap<String, String>();

    public ModelHandles(AEFDModel model) {
        this.model = model;
    }

    public List<String> getLogs() {
        return this.logs;
    }

    public List<String> getLogsFor(AEFDModelObject o) {
        List<Integer> logIndexes = this.logMap.get(o);
        if (logIndexes == null) {
            return new LinkedList<String>();
        }
        LinkedList<String> oLogs = new LinkedList<String>();
        for (Integer logIndex : logIndexes) {
            oLogs.add(this.logs.get(logIndex));
        }
        return oLogs;
    }

    private void addLink(AEFDModelObject o) {
        List<Integer> logIndexes = this.logMap.get(o);
        if (logIndexes == null) {
            logIndexes = new LinkedList<Integer>();
            this.logMap.put(o, logIndexes);
        }
        logIndexes.add(this.logs.size() - 1);
    }

    private String getFileName(Item item, int index) {
        return item.type + "_" + index + "." + item.extension;
    }

    public void logItem(String type, String content, String extension) {
        int index = this.logs.size();
        Item item = new Item();
        item.type = type;
        item.content = content;
        item.extension = extension;
        this.lastItemMap.put(type, item);
        this.modelItems.put(index, item);
        this.log(this.getFileName(item, index));
    }

    public Map<Integer, Item> getModeItems() {
        return this.modelItems;
    }

    public void logPrettyPrint() {
        this.logItem(PRETTY_PRINT, this.printer.getString(this.model), "txt");
    }

    public void log(String log) {
        this.logs.add(log);
    }

    public void printLogs() {
        for (int logIndex = 0; logIndex < this.logs.size(); ++logIndex) {
            if (this.modelItems.containsKey(logIndex)) {
                System.out.print("[" + logIndex + "] ");
            }
            System.out.println(this.logs.get(logIndex));
        }
    }

    public void exportAsRepository(String repositoryName) throws IOException {
        new File("out/" + repositoryName).mkdir();
        String path = "out/" + repositoryName + "/";
        HashMap<Integer, String> itemFileMap = new HashMap<Integer, String>();
        for (Integer index : this.modelItems.keySet()) {
            Item item = this.modelItems.get(index);
            String fileName = this.getFileName(item, index);
            itemFileMap.put(index, fileName);
            PrintWriter pw = new PrintWriter(path + fileName);
            pw.print(item.content);
            pw.close();
        }
        String fileName = "index.html";
        PrintWriter pw = new PrintWriter(path + fileName);
        pw.println("<html><body>");
        for (int logIndex = 0; logIndex < this.logs.size(); ++logIndex) {
            if (this.modelItems.containsKey(logIndex)) {
                pw.print("<a href=\"" + (String)itemFileMap.get(logIndex) + "\"> " + this.logs.get(logIndex) + " </a></br>");
                continue;
            }
            pw.print(this.logs.get(logIndex) + "</br>");
        }
        pw.println("</body></html>");
        pw.close();
        System.out.println("Generated " + path);
    }

    public String getLast(String itemType) {
        return this.lastItemMap.get((Object)itemType).content;
    }

    public void printModel() {
        System.out.println(this.getLast(PRETTY_PRINT));
    }

    public void addAutomate(AEFDAutomate automate, String comment) {
        this.logs.add("Added automate " + automate.getName() + ": " + comment);
        this.addLink(automate);
        this.model.getAllAutomates().addLast(automate);
    }

    public void removeAutomate(AEFDAutomate automate, String comment) {
        this.logs.add("Removed automate " + automate.getName() + ": " + comment);
        this.addLink(automate);
        this.model.getAllAutomates().remove(automate);
    }

    public void replaceAutomate(AEFDAutomate original, LinkedList<AEFDAutomate> replacement, String comment) {
        this.addLink(original);
        replacement.forEach(a -> this.addLink((AEFDModelObject)a));
        StringBuffer log = new StringBuffer().append("Replaced automate ").append(original.getName()).append(" with");
        replacement.forEach(a -> log.append(" ").append(a.getName()));
        log.append(" : ").append(comment);
        this.logs.add(log.toString());
        int originalIndex = this.model.getAllAutomates().indexOf(original);
        this.model.getAllAutomates().remove(original);
        this.model.getAllAutomates().addAll(originalIndex, replacement);
    }

    private class Item {
        public String type;
        public String extension;
        public String content;

        private Item() {
        }
    }
}

