/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.analysis.basic;

import fr.ensta.aefd.model.AEFDAction;
import fr.ensta.aefd.model.AEFDActionSequence;
import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.AEFDModelVisitor;
import fr.ensta.aefd.model.AEFDTransition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SentEventsAnalysis
extends AEFDModelVisitor.Stub {
    public final Set<AEFDFunctionalEntity> sentEvents = new HashSet<AEFDFunctionalEntity>();
    private final Map<AEFDFunctionalEntity, Set<AEFDAutomate>> sourceMap = new HashMap<AEFDFunctionalEntity, Set<AEFDAutomate>>();
    private final Map<AEFDAutomate, Set<AEFDFunctionalEntity>> outputMap = new HashMap<AEFDAutomate, Set<AEFDFunctionalEntity>>();
    private AEFDAutomate currentAutomate;

    private void initialize(AEFDModel model) {
        this.sentEvents.clear();
        this.sourceMap.clear();
        this.outputMap.clear();
        for (AEFDAutomate automate : model.getAllAutomates()) {
            this.outputMap.put(automate, new HashSet());
        }
        for (AEFDFunctionalEntity functionalEntity : model.getAllFunctionalEntity()) {
            this.sourceMap.put(functionalEntity, new HashSet());
        }
    }

    public void analyze(AEFDModel model) {
        this.initialize(model);
        model.accept(this);
    }

    public Set<AEFDFunctionalEntity> getSentEvents() {
        return this.sentEvents;
    }

    public Map<AEFDFunctionalEntity, Set<AEFDAutomate>> getSourceMap() {
        return this.sourceMap;
    }

    public Map<AEFDAutomate, Set<AEFDFunctionalEntity>> getOutputMap() {
        return this.outputMap;
    }

    public Set<AEFDAutomate> getSources(AEFDFunctionalEntity event) {
        return this.sourceMap.get(event);
    }

    public Set<AEFDFunctionalEntity> getOutputs(AEFDAutomate automate) {
        return this.outputMap.get(automate);
    }

    @Override
    public void visitModel(AEFDModel model) {
        for (AEFDAutomate automate : model.getAllAutomates()) {
            automate.accept(this);
        }
    }

    @Override
    public void visitAutomate(AEFDAutomate automate) {
        this.currentAutomate = automate;
        for (AEFDTransition transition : automate.getTransitionSet()) {
            transition.accept(this);
        }
    }

    @Override
    public void visitTransition(AEFDTransition transition) {
        transition.getAction().accept(this);
    }

    @Override
    public void visitActionSequence(AEFDActionSequence actionSeq) {
        for (AEFDAction action : actionSeq.getActionList()) {
            action.accept(this);
        }
    }

    @Override
    public void visitSendEvent(AEFDAction.SendEvent sendEvent) {
        sendEvent.getFunctionalEntity().accept(this);
    }

    @Override
    public void visitFunctionalEntity(AEFDFunctionalEntity functionalEntity) {
        this.sentEvents.add(functionalEntity);
        this.sourceMap.get(functionalEntity).add(this.currentAutomate);
        this.outputMap.get(this.currentAutomate).add(functionalEntity);
    }
}

