/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.model.meta;

import java.util.HashMap;
import java.util.Map;

public class SuffixPairs {
    private final Map<String, String> suffixPairs = new HashMap<String, String>();

    public void add(String trueValue, String falseValue) {
        if (!(this.suffixPairs.containsKey(trueValue) || this.suffixPairs.containsValue(trueValue) || this.suffixPairs.containsKey(falseValue) || this.suffixPairs.containsValue(falseValue))) {
            this.suffixPairs.put(trueValue, falseValue);
        } else {
            String currentFalseValue = this.suffixPairs.get(trueValue);
            if (currentFalseValue == null || !currentFalseValue.equals(falseValue)) {
                throw new IllegalStateException("Suffix pair conflict detected when adding <" + trueValue + ", " + falseValue + ">");
            }
        }
    }

    public String[] getSuffixPair(String oneSuffix) {
        for (Map.Entry<String, String> suffixEntry : this.suffixPairs.entrySet()) {
            if (!suffixEntry.getKey().equals(oneSuffix) && !suffixEntry.getValue().equals(oneSuffix)) continue;
            String[] result = new String[]{suffixEntry.getKey(), suffixEntry.getValue()};
            return result;
        }
        throw new IllegalArgumentException("Unknown suffix: " + oneSuffix);
    }

    public String extractSuffix(String suffixedIdentifier) {
        String result = "";
        for (Map.Entry<String, String> suffixEntry : this.suffixPairs.entrySet()) {
            String[] suffixPair = new String[]{suffixEntry.getKey(), suffixEntry.getValue()};
            for (int i = 0; i < 2; ++i) {
                if (suffixPair[i].length() <= result.length() || !suffixedIdentifier.toLowerCase().endsWith(suffixPair[i].toLowerCase())) continue;
                result = suffixPair[i];
            }
        }
        if (result.equals("")) {
            System.err.println(suffixedIdentifier);
            result = "Inactif";
        }
        return result;
    }
}

