/*
 * Decompiled with CFR 0.152.
 */
package plug.utils.ui.graph;

import javafx.application.Platform;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import plug.utils.ui.graph.GraphView;
import plug.utils.ui.graph.GraphViewModel;
import plug.utils.ui.graph.VertexView;

public class EdgeView<V, E>
extends Group {
    protected final GraphView<V, E> parent;
    protected final GraphViewModel.Edge<V, E> data;
    protected final VertexView<V, E> source;
    protected final VertexView<V, E> target;
    protected final Line line;

    public EdgeView(GraphView<V, E> parent, GraphViewModel.Edge<V, E> data) {
        this.parent = parent;
        this.data = data;
        this.source = (VertexView)((Object)parent.vertexViews.get(data.source));
        this.target = (VertexView)((Object)parent.vertexViews.get(data.target));
        this.line = new Line();
        this.line.setStrokeWidth(5.0);
        this.line.setStroke((Paint)Color.GRAY);
        this.line.startXProperty().bind((ObservableValue)this.source.layoutXProperty().add((ObservableNumberValue)this.source.widthProperty()));
        this.line.startYProperty().bind((ObservableValue)this.source.layoutYProperty().add((ObservableNumberValue)this.source.heightProperty().divide(2.0)));
        this.line.endXProperty().bind((ObservableValue)this.target.layoutXProperty());
        this.line.endYProperty().bind((ObservableValue)this.target.layoutYProperty().add((ObservableNumberValue)this.target.heightProperty().divide(2.0)));
        this.getChildren().add((Object)this.line);
        if (data.label != null) {
            Circle circle = new Circle(8.0);
            circle.setFill((Paint)Color.GRAY);
            circle.centerXProperty().bind((ObservableValue)this.target.layoutXProperty());
            circle.centerYProperty().bind((ObservableValue)this.target.layoutYProperty().add((ObservableNumberValue)this.target.heightProperty().divide(2.0)));
            this.getChildren().add((Object)circle);
            String text = parent.getModel().edgeDescription(data.label);
            Tooltip.install((Node)this.line, (Tooltip)new Tooltip(text));
            Tooltip.install((Node)circle, (Tooltip)new Tooltip(text));
        }
        Platform.runLater(() -> {
            this.source.toFront();
            this.target.toFront();
            this.line.toBack();
        });
    }

    public GraphViewModel.Edge<V, E> getData() {
        return this.data;
    }

    public VertexView<V, E> getSource() {
        return this.source;
    }

    public VertexView<V, E> getTarget() {
        return this.target;
    }
}

