/*
 * Decompiled with CFR 0.152.
 */
package plug.language.TLA.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import plug.core.IConcurrentTransitionRelation;
import plug.core.IFiredTransition;
import plug.core.ITransitionRelation;
import plug.language.TLA.runtime.TLAConfiguration;
import plug.statespace.transitions.FiredTransition;
import plug.utils.Pair;
import tla2sany.semantic.ExprNode;
import tlc2.output.MP;
import tlc2.tool.Action;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.Tool;

public class TLATransitionRelation
implements ITransitionRelation<TLAConfiguration, Pair<Action, StateVec>>,
IConcurrentTransitionRelation<TLATransitionRelation, TLAConfiguration, Pair<Action, StateVec>> {
    public Tool tool;
    public Action[] invariants;
    public Action[] impliedActions;
    public Action[] impliedInits;
    public Action[] actions;

    public boolean checkAssumptions() {
        ExprNode[] assumps = this.tool.getAssumptions();
        boolean[] isAxiom = this.tool.getAssumptionIsAxiom();
        for (int i = 0; i < assumps.length; ++i) {
            try {
                if (isAxiom[i] || this.tool.isValid(assumps[i])) continue;
                MP.printError((int)2104, (String)assumps[i].toString());
                return false;
            }
            catch (Exception e) {
                MP.printError((int)2105, (String[])new String[]{assumps[i].toString(), e.getMessage()});
                return false;
            }
        }
        return true;
    }

    public Set<TLAConfiguration> initialConfigurations() {
        if (!this.checkAssumptions()) {
            return Collections.emptySet();
        }
        StateVec theInitStates = this.tool.getInitStates();
        HashSet<TLAConfiguration> result = new HashSet<TLAConfiguration>();
        for (int i = 0; i < theInitStates.size(); ++i) {
            TLCState currentState = theInitStates.elementAt(i);
            if (!this.tool.isGoodState(currentState)) {
                MP.printError((int)2102, (String)currentState.toString());
                return Collections.emptySet();
            }
            boolean inModel = this.tool.isInModel(currentState);
            if (!inModel) continue;
            TLAConfiguration config = new TLAConfiguration();
            config.state = currentState;
            result.add(config);
        }
        return result;
    }

    public List<Pair<Action, StateVec>> fireableTransitionsFrom(TLAConfiguration configuration) {
        TLAConfiguration current = configuration;
        ArrayList<Pair<Action, StateVec>> fireables = new ArrayList<Pair<Action, StateVec>>();
        for (int i = 0; i < this.actions.length; ++i) {
            Action currentAction = this.actions[i];
            StateVec nextStates = this.tool.getNextStates(currentAction, current.state);
            if (nextStates.empty()) continue;
            fireables.add((Pair<Action, StateVec>)new Pair((Object)currentAction, (Object)nextStates));
        }
        return fireables;
    }

    public IFiredTransition<TLAConfiguration, ?> fireOneTransition(TLAConfiguration source, Pair<Action, StateVec> fireable) {
        HashSet<TLAConfiguration> reachedTargets = new HashSet<TLAConfiguration>(((StateVec)fireable.b).size());
        for (int stateID = 0; stateID < ((StateVec)fireable.b).size(); ++stateID) {
            boolean inModel;
            TLCState nextState = ((StateVec)fireable.b).elementAt(stateID);
            if (!this.tool.isGoodState(nextState)) {
                MP.printError((int)2102, (String)nextState.toString());
                return null;
            }
            boolean bl = inModel = this.tool.isInModel(nextState) && this.tool.isInActions(source.state, nextState);
            if (!inModel) continue;
            TLAConfiguration config = new TLAConfiguration();
            config.state = nextState;
            reachedTargets.add(config);
        }
        return new FiredTransition((Object)source, reachedTargets, fireable.a);
    }

    public TLATransitionRelation createCopy() {
        TLATransitionRelation runtime = new TLATransitionRelation();
        runtime.tool = this.tool;
        runtime.impliedInits = this.tool.getImpliedInits();
        runtime.invariants = this.tool.getInvariants();
        runtime.impliedActions = this.tool.getImpliedActions();
        runtime.actions = this.tool.getActions();
        return runtime;
    }
}

