/*
 * Decompiled with CFR 0.152.
 */
package plug.language.TLA;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import plug.core.IRuntimeView;
import plug.core.view.ConfigurationItem;
import plug.language.TLA.runtime.TLAConfiguration;
import plug.language.TLA.runtime.TLATransitionRelation;
import plug.utils.Pair;
import tlc2.tool.Action;
import tlc2.tool.StateVec;

public class TLARuntimeView
implements IRuntimeView<TLAConfiguration, Pair<Action, StateVec>> {
    TLATransitionRelation runtime;

    public TLARuntimeView(TLATransitionRelation runtime) {
        this.runtime = runtime;
    }

    public TLATransitionRelation getRuntime() {
        return this.runtime;
    }

    public List<ConfigurationItem> getConfigurationItems(TLAConfiguration value) {
        return Collections.singletonList(new ConfigurationItem("state", value.getState().toString(), null, null));
    }

    public String getFireableTransitionDescription(Pair<Action, StateVec> transition) {
        return null;
    }

    ConfigurationItem getTreeForBehavior(Object bhc) {
        ConfigurationItem fieldTree;
        ArrayList<ConfigurationItem> children = new ArrayList<ConfigurationItem>();
        for (Field field : bhc.getClass().getDeclaredFields()) {
            fieldTree = this.getTreeForField(bhc, field);
            if (fieldTree == null) continue;
            children.add(fieldTree);
        }
        for (Field field : bhc.getClass().getSuperclass().getDeclaredFields()) {
            if (!field.getName().startsWith("_sid") || (fieldTree = this.getTreeForField(bhc, field)) == null) continue;
            children.add(fieldTree);
        }
        ConfigurationItem parentTree = new ConfigurationItem("process", bhc.getClass().getSimpleName(), null, children);
        parentTree.setExpanded(true);
        return parentTree;
    }

    ConfigurationItem getTreeForField(Object object, Field field) {
        try {
            String value;
            field.setAccessible(true);
            Object fVal = field.get(object);
            if (field.getName().startsWith("this")) {
                return null;
            }
            if (field.getType().isArray()) {
                StringBuilder b = new StringBuilder();
                int iMax = Array.getLength(fVal) - 1;
                if (iMax == -1) {
                    value = "[]";
                } else {
                    b.append('[');
                    int i = 0;
                    while (true) {
                        b.append(Array.get(fVal, i));
                        if (i == Array.getLength(fVal) - 1) break;
                        b.append(", ");
                        ++i;
                    }
                    b.append(']');
                    value = b.toString();
                }
            } else {
                value = field.getType().isArray() ? Arrays.deepToString((Object[])fVal) : fVal.toString();
            }
            ConfigurationItem varField = new ConfigurationItem("variable", field.getName() + " = " + value, null, null);
            return varField;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }
}

