/*
 * Decompiled with CFR 0.152.
 */
package plug.language.explicit.runtime;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import plug.core.IConcurrentTransitionRelation;
import plug.core.IFiredTransition;
import plug.language.explicit.model.ExplicitProgram;
import plug.language.explicit.runtime.ExplicitConfiguration;
import plug.statespace.transitions.FiredTransition;

public class ExplicitTransitionRelation
implements IConcurrentTransitionRelation<ExplicitTransitionRelation, ExplicitConfiguration, Integer> {
    public final String name;
    public final ExplicitProgram program;

    public ExplicitTransitionRelation(String name, ExplicitProgram program) {
        this.name = name;
        this.program = program;
    }

    public ExplicitTransitionRelation createCopy() {
        return new ExplicitTransitionRelation(this.name, this.program);
    }

    public Set<ExplicitConfiguration> initialConfigurations() {
        ExplicitConfiguration config = new ExplicitConfiguration();
        config.id = this.program.initial;
        config.values = this.program.states[this.program.initial];
        return Collections.singleton(config);
    }

    public Collection<Integer> fireableTransitionsFrom(ExplicitConfiguration source) {
        int[] fanout = this.program.getFireableTransitions(source.id);
        return Arrays.stream(fanout).boxed().collect(Collectors.toList());
    }

    public IFiredTransition<ExplicitConfiguration, ?> fireOneTransition(ExplicitConfiguration source, Integer transition) {
        ExplicitConfiguration target = new ExplicitConfiguration();
        target.id = transition;
        target.values = this.program.states[transition];
        return new FiredTransition((Object)source, (Object)target, (Object)transition);
    }
}

