/*
 * Decompiled with CFR 0.152.
 */
package plug.language.fiacre.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import obp.explorer.runtime.Behavior;
import obp.explorer.runtime.BehaviorConfiguration;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.DBM;
import obp.explorer.runtime.ExplorationContext;
import obp.explorer.runtime.ProcessBehavior;
import obp.explorer.runtime.core.BroadcastChannel;
import obp.explorer.runtime.core.Channel;
import obp.explorer.runtime.core.Transition;
import obp.explorer.runtime.fiacre.WaitChannel;
import plug.core.IAtomicPropositionsEvaluator;
import plug.core.IConcurrentTransitionRelation;
import plug.core.IFiredTransition;
import plug.language.fiacre.diagnosis.FiacreAtomicPropositionsEvaluator;
import plug.language.fiacre.runtime.FiacreConfiguration;
import plug.language.fiacre.runtime.FiacreExplorationContext;
import plug.language.fiacre.runtime.FiacreSynchronizedTransition;
import plug.modules.synchronization.ISynchronizationManager;
import plug.modules.synchronization.ISynchronizedTransition;
import plug.modules.synchronization.ISynchronizingRuntime;
import plug.modules.synchronization.byChannels.FastChannelSynchronizationManager;
import plug.modules.synchronization.byChannels.IChannelSynchronizationManager;
import plug.statespace.transitions.FiredTransition;

public class FiacreTransitionRelation
implements IConcurrentTransitionRelation<FiacreTransitionRelation, FiacreConfiguration, Transition>,
ISynchronizingRuntime<FiacreConfiguration, Transition> {
    private FiacreExplorationContext explorationContext;
    private IChannelSynchronizationManager<FiacreConfiguration, Transition> syncManager = new FastChannelSynchronizationManager((ISynchronizingRuntime)this);
    private int behaviorCount;
    private boolean[] modifiedBehaviors;
    FiacreAtomicPropositionsEvaluator fiacreAtomicPropositionsEvaluator;
    FiacreConfiguration newConfigurationHACK;
    private boolean[] actives;
    private boolean[] previouslyActives;
    private byte[] clockActivations;

    public IAtomicPropositionsEvaluator getAtomicPropositionEvaluator() {
        return this.fiacreAtomicPropositionsEvaluator;
    }

    public FiacreExplorationContext getExplorationContext() {
        return this.explorationContext;
    }

    public boolean hasBlockingTransitions() {
        return true;
    }

    public ISynchronizationManager getSynchronizationManager() {
        return this.syncManager;
    }

    public ISynchronizedTransition<Transition> newSynchronizedTransitionObject() {
        return new FiacreSynchronizedTransition(-1);
    }

    public void setExplorationContext(FiacreExplorationContext context) {
        this.explorationContext = context;
        this.behaviorCount = this.explorationContext.getBehaviorCount();
        this.modifiedBehaviors = new boolean[this.behaviorCount];
        this.actives = new boolean[this.explorationContext.getChannelCount()];
        this.previouslyActives = new boolean[this.explorationContext.getChannelCount()];
        this.clockActivations = new byte[this.explorationContext.symbols.getNumberOfClocks()];
        for (Channel channel : context.channels) {
            if (channel instanceof WaitChannel) {
                this.syncManager.registerChannel((int)channel.id, 1, 0);
                continue;
            }
            this.syncManager.registerChannel((int)channel.id, ((BroadcastChannel)channel).requiredOutputCount, ((BroadcastChannel)channel).requiredInputCount);
        }
        for (Channel channel : context.behaviors) {
            if (!(channel instanceof ProcessBehavior)) continue;
            ProcessBehavior pbeh = (ProcessBehavior)channel;
            int[] outputs = new int[]{};
            if (pbeh.outputChannels != null) {
                outputs = new int[pbeh.outputChannels.length];
                for (int i = 0; i < outputs.length; ++i) {
                    outputs[i] = pbeh.outputChannels[i].id;
                }
            }
            ArrayList waitChannels = new ArrayList();
            pbeh.collectChannels(waitChannels);
            if (!waitChannels.isEmpty()) {
                int startIdx = outputs.length;
                outputs = Arrays.copyOf(outputs, outputs.length + waitChannels.size());
                for (Channel chan : waitChannels) {
                    outputs[startIdx++] = chan.id;
                }
            }
            int[] inputs = new int[]{};
            if (pbeh.inputChannels != null) {
                inputs = new int[pbeh.inputChannels.length];
                for (int i = 0; i < inputs.length; ++i) {
                    inputs[i] = pbeh.inputChannels[i].id;
                }
            }
            this.syncManager.addVocabulary((int)channel.id, outputs, inputs);
        }
        this.syncManager.setSynchronizationArraySupplier2(a -> new Transition[a.intValue()][]);
        this.syncManager.setSynchronizationArraySupplier1(a -> new Transition[a.intValue()]);
        this.fiacreAtomicPropositionsEvaluator = new FiacreAtomicPropositionsEvaluator(context);
    }

    public FiacreTransitionRelation createCopy() {
        FiacreTransitionRelation runtime = new FiacreTransitionRelation();
        runtime.syncManager.setExploreSynchronization(this.syncManager.getExploreSynchronization());
        runtime.explorationContext = this.explorationContext.copy();
        runtime.behaviorCount = this.behaviorCount;
        runtime.modifiedBehaviors = new boolean[this.behaviorCount];
        runtime.actives = (boolean[])this.actives.clone();
        runtime.previouslyActives = (boolean[])this.previouslyActives.clone();
        runtime.clockActivations = (byte[])this.clockActivations.clone();
        runtime.setExplorationContext(this.explorationContext);
        runtime.fiacreAtomicPropositionsEvaluator = this.fiacreAtomicPropositionsEvaluator;
        return runtime;
    }

    public Set<FiacreConfiguration> initialConfigurations() {
        short numberOfClocks = this.explorationContext.symbols.getNumberOfClocks();
        short[] initialDBM = null;
        if (numberOfClocks > 0) {
            initialDBM = DBM.createAllDisable((int)numberOfClocks);
        }
        BehaviorConfiguration[] configurationArray = new BehaviorConfiguration[this.behaviorCount];
        Configuration configuration = new Configuration(configurationArray, initialDBM);
        for (Behavior process : this.explorationContext.behaviors) {
            configurationArray[process.id] = process.createInitialConfiguration(configuration);
        }
        FiacreConfiguration config = new FiacreConfiguration(configuration.behaviorConfigurations, configuration.dbm);
        if (initialDBM != null) {
            this.applyDelayAndInvariant(null, config);
        }
        return Collections.singleton(config);
    }

    void computeChannelScheduleFrom(FiacreConfiguration current, List<Transition> ioFireableTransitions) {
        for (int i = 0; i < this.behaviorCount; i = (int)((short)(i + 1))) {
            ProcessBehavior behavior = (ProcessBehavior)this.explorationContext.behaviors[i];
            for (Transition transition : behavior.getTransitions((Configuration)current)) {
                if (!transition.guard((Configuration)current, (ExplorationContext)this.explorationContext)) continue;
                short channelId = transition.getSynchronisationChannelId();
                if (channelId == -1) {
                    if (ioFireableTransitions == null) continue;
                    ioFireableTransitions.add(transition);
                    continue;
                }
                if (transition.getSynchronisationType() == 1) {
                    this.syncManager.scheduleInput((int)channelId, (int)transition.behaviorId, (Object)transition);
                    continue;
                }
                if (transition.getSynchronisationType() != 2) continue;
                this.syncManager.scheduleOutput((int)channelId, (int)transition.behaviorId, (Object)transition);
            }
        }
    }

    public List<Transition> fireableTransitionsFrom(FiacreConfiguration current) {
        ArrayList<Transition> fireableTransitions = new ArrayList<Transition>();
        this.computeChannelScheduleFrom(current, fireableTransitions);
        Collection syncResults = this.syncManager.fireableTransitionsFrom((Object)current);
        for (ISynchronizedTransition transition : syncResults) {
            fireableTransitions.add((Transition)transition);
        }
        return fireableTransitions;
    }

    public boolean synchronizedTransitionIsActive(FiacreConfiguration current, int channelID, Transition[] outputs, Transition[] inputs) {
        Channel channel = this.explorationContext.getChannel((short)channelID);
        return this.checkTimeBounds(current, channel, outputs, inputs);
    }

    public IFiredTransition<FiacreConfiguration, ?> fireOneTransition(FiacreConfiguration source, Transition transition) {
        this.onEntryAtomicTransition(source, transition);
        IFiredTransition fired = transition instanceof ISynchronizedTransition ? this.syncManager.fireOneTransition((Object)source, (ISynchronizedTransition)transition) : this.executeOneTransition(source, transition);
        if (fired == null) {
            return null;
        }
        this.onExitAtomicTransition(fired);
        return fired;
    }

    void onEntryAtomicTransition(FiacreConfiguration sourceConfiguration, Transition transition) {
        FiacreConfiguration newConfiguration;
        this.newConfigurationHACK = newConfiguration = sourceConfiguration.createCopy();
        if (newConfiguration.dbm != null) {
            int channelID = transition.getSynchronisationChannelId();
            if (transition instanceof ISynchronizedTransition) {
                channelID = ((ISynchronizedTransition)transition).getSynchronizationVector()[0];
            }
            if (channelID != -1) {
                Channel chan = this.explorationContext.getChannel((short)channelID);
                DBM.andGuard((short[])newConfiguration.dbm, (int)0, (int)chan.clockId, (short)chan.minBoundInternal);
            }
        }
    }

    public IFiredTransition<FiacreConfiguration, ?> executeOneTransition(FiacreConfiguration configuration, Transition transition) {
        boolean isBlocked;
        FiacreConfiguration newConfiguration;
        if (this.newConfigurationHACK != null) {
            newConfiguration = this.newConfigurationHACK;
            this.newConfigurationHACK = null;
        } else {
            newConfiguration = configuration.createCopy();
        }
        if (newConfiguration.dbm != null) {
            transition.when((Configuration)newConfiguration, (ExplorationContext)this.explorationContext);
            if (DBM.isEmpty((short[])newConfiguration.dbm)) {
                return null;
            }
        }
        Arrays.fill(this.modifiedBehaviors, false);
        this.modifiedBehaviors[transition.behaviorId] = true;
        transition.updateModifiedBehaviors((Configuration)newConfiguration, (ExplorationContext)this.explorationContext, this.modifiedBehaviors);
        for (short i = 0; i < this.modifiedBehaviors.length; i = (short)(i + 1)) {
            if (!this.modifiedBehaviors[i]) continue;
            newConfiguration.replaceBehaviorConfigurationByCopy(i);
        }
        ArrayList atomicActionList = new ArrayList(2);
        boolean bl = isBlocked = !transition.action((ExplorationContext)this.explorationContext, atomicActionList, (Configuration)newConfiguration);
        if (isBlocked) {
            return null;
        }
        return new FiredTransition((Object)configuration, (Object)newConfiguration, atomicActionList);
    }

    protected boolean checkTimeBounds(Configuration source, Channel channel, Transition[] outputs, Transition[] inputs) {
        if (source.dbm != null && channel != null && channel.clockId != -1) {
            Configuration checkedSource = new Configuration(source);
            DBM.andGuard((short[])checkedSource.dbm, (int)0, (int)channel.clockId, (short)channel.minBoundInternal);
            if (DBM.isEmpty((short[])checkedSource.dbm)) {
                return false;
            }
            for (Transition output : outputs) {
                output.when(checkedSource, (ExplorationContext)this.explorationContext);
            }
            if (DBM.isEmpty((short[])checkedSource.dbm)) {
                return false;
            }
            for (Transition input : inputs) {
                input.when(checkedSource, (ExplorationContext)this.explorationContext);
            }
            if (DBM.isEmpty((short[])checkedSource.dbm)) {
                return false;
            }
        }
        return true;
    }

    public void onExitAtomicTransition(IFiredTransition<FiacreConfiguration, ?> transition) {
        FiacreConfiguration source = (FiacreConfiguration)((Object)transition.getSource());
        if (source.dbm == null) {
            return;
        }
        for (FiacreConfiguration target : transition.getTargets()) {
            this.applyDelayAndInvariant(source, target);
        }
    }

    public void applyDelayAndInvariant(FiacreConfiguration source, FiacreConfiguration target) {
        short clockId;
        int i;
        short[] dbm = target.dbm;
        if (source != null) {
            this.computeActives(source, this.previouslyActives);
        } else {
            Arrays.fill(this.previouslyActives, false);
        }
        this.computeActives(target, this.actives);
        Channel[] channels = this.explorationContext.channels;
        Arrays.fill(this.clockActivations, (byte)2);
        for (i = 0; i < this.actives.length; i = (int)((short)(i + 1))) {
            clockId = channels[i].clockId;
            this.clockActivations[clockId - 1] = 0;
        }
        for (i = 0; i < this.actives.length; i = (int)((short)(i + 1))) {
            clockId = channels[i].clockId;
            if (!this.actives[i]) continue;
            this.clockActivations[clockId - 1] = this.previouslyActives[i] ? 2 : 1;
        }
        block6: for (int clockID = 0; clockID < this.clockActivations.length; clockID = (int)((short)(clockID + 1))) {
            switch (this.clockActivations[clockID]) {
                case 0: {
                    DBM.disable((short[])dbm, (int)(clockID + 1));
                    continue block6;
                }
                case 1: {
                    DBM.set((short[])dbm, (int)(clockID + 1), (int)0);
                }
            }
        }
        DBM.delay((short[])dbm);
        for (i = 0; i < this.explorationContext.getBehaviorCount(); ++i) {
            this.explorationContext.getBehavior((short)i).invariant((Configuration)target, (ExplorationContext)this.explorationContext);
        }
        for (i = 0; i < this.actives.length; i = (int)((short)(i + 1))) {
            if (channels[i].clockId == -1 || !this.actives[i]) continue;
            DBM.andGuard((short[])dbm, (int)channels[i].clockId, (int)0, (short)channels[i].maxBoundInternal);
        }
    }

    private void computeActives(FiacreConfiguration configuration, boolean[] actives) {
        Arrays.fill(actives, false);
        this.computeChannelScheduleFrom(configuration, null);
        Channel[] channels = this.explorationContext.channels;
        for (int i = 0; i < channels.length; i = (int)((short)(i + 1))) {
            actives[i] = this.syncManager.isComplete((int)channels[i].id);
        }
        this.syncManager.clearSchedule();
    }
}

