/*
 * Decompiled with CFR 0.152.
 */
package plug.language.fiacre;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import obp.explorer.runtime.Behavior;
import obp.explorer.runtime.BehaviorConfiguration;
import obp.explorer.runtime.DBM;
import obp.explorer.runtime.core.Transition;
import obp.explorer.runtime.obs.AtomicAction;
import plug.core.IRuntimeView;
import plug.core.view.ConfigurationItem;
import plug.language.fiacre.runtime.FiacreConfiguration;
import plug.language.fiacre.runtime.FiacreExplorationContext;
import plug.language.fiacre.runtime.FiacreSynchronizedTransition;
import plug.language.fiacre.runtime.FiacreTransitionRelation;

public class FiacreRuntimeView
implements IRuntimeView<FiacreConfiguration, Transition> {
    private final FiacreTransitionRelation runtime;

    public FiacreRuntimeView(FiacreTransitionRelation runtime) {
        this.runtime = runtime;
    }

    public FiacreTransitionRelation getRuntime() {
        return this.runtime;
    }

    public List<ConfigurationItem> getConfigurationItems(FiacreConfiguration value) {
        ArrayList<ConfigurationItem> processes = new ArrayList<ConfigurationItem>();
        processes.add(new ConfigurationItem("clock", DBM.toConstrainString((short[])value.dbm), null, null));
        FiacreExplorationContext context = this.runtime.getExplorationContext();
        for (short index = 0; index < context.getBehaviorCount(); index = (short)(index + 1)) {
            Behavior behavior = context.getBehavior(index);
            BehaviorConfiguration processConfiguration = value.behaviorConfigurations[index];
            ArrayList<ConfigurationItem> variables = new ArrayList<ConfigurationItem>();
            for (Field field : processConfiguration.getClass().getDeclaredFields()) {
                try {
                    Object fieldValue = field.get(processConfiguration);
                    String name = field.getName();
                    if (name.equals("state")) {
                        variables.add(new ConfigurationItem("state", "@" + behavior.getStateName(((Short)fieldValue).shortValue()), null, null));
                        continue;
                    }
                    if (field.getType().isPrimitive() || field.getType().isArray()) {
                        variables.add(new ConfigurationItem("variable", name + " = " + this.fieldToString(field, fieldValue), null, null));
                        continue;
                    }
                    ArrayList<ConfigurationItem> items = new ArrayList<ConfigurationItem>();
                    for (Field f : field.getType().getDeclaredFields()) {
                        Object valu = f.get(fieldValue);
                        items.add(new ConfigurationItem("variable", f.getName() + " = " + this.fieldToString(f, valu), null, null));
                    }
                    variables.add(new ConfigurationItem("variable", name, null, items));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            processes.add(new ConfigurationItem("process", behavior.name, null, variables));
        }
        return processes;
    }

    protected String fieldToString(Field field, Object value) {
        if (field.getType().isArray()) {
            int iMax = Array.getLength(value) - 1;
            if (iMax == -1) {
                return "[]";
            }
            StringBuilder builder = new StringBuilder();
            builder.append('[');
            int i = 0;
            while (true) {
                builder.append(Array.get(value, i));
                if (i == Array.getLength(value) - 1) break;
                builder.append(", ");
                ++i;
            }
            builder.append(']');
            return builder.toString();
        }
        if (field.getType().isArray()) {
            return Arrays.deepToString((Object[])value);
        }
        return value.toString();
    }

    public String getFireableTransitionDescription(Transition transition) {
        if (transition instanceof FiacreSynchronizedTransition) {
            FiacreSynchronizedTransition fiacreSynchronizedTransition = (FiacreSynchronizedTransition)transition;
            return this.runtime.getExplorationContext().getChannel((short)((short)fiacreSynchronizedTransition.getSynchronizationVector()[0])).name;
        }
        Behavior behavior = this.runtime.getExplorationContext().getBehavior(transition.behaviorId);
        StringBuilder result = new StringBuilder();
        result.append(behavior.name);
        result.append(": ");
        result.append(transition.getClass().getName());
        return result.toString();
    }

    public String getActionDescription(Object action) {
        StringBuilder result = new StringBuilder();
        if (action instanceof Collection) {
            for (Object child : (Collection)action) {
                if (child instanceof AtomicAction) {
                    result.append(((AtomicAction)child).toFancyString(this.runtime.getExplorationContext().symbols));
                    continue;
                }
                result.append(child.toString());
            }
            result.append("; ");
        } else if (action instanceof AtomicAction) {
            result.append(((AtomicAction)action).toFancyString(this.runtime.getExplorationContext().symbols));
        } else {
            result.append(Objects.toString(action));
        }
        return result.toString();
    }
}

