/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.system;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xid.basics.error.ErrorHandler;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.system.Rule;

public class Make {
    private final List<Rule> rules = new ArrayList<Rule>();
    private final Map<String, String> variables = new HashMap<String, String>();
    private File workingFolder;
    private ErrorHandler errorHandler = ErrorHandler.simple;

    public boolean cd(String path) {
        if (path == null) {
            return false;
        }
        File tempWd = new File(this.workingFolder, path);
        if (!(tempWd.exists() && tempWd.canRead() && tempWd.isDirectory())) {
            return false;
        }
        this.workingFolder = tempWd;
        return true;
    }

    public File getWorkingDir() {
        return this.workingFolder;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler == null ? ErrorHandler.simple : errorHandler;
    }

    public String getVariable(String name) {
        return this.variables.get(name);
    }

    public void setVariable(String name, String value) {
        this.variables.put(name, value);
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    private boolean targetExists(String target) {
        return this.getFile(target).exists();
    }

    public File getFile(String target) {
        return new File(this.getWorkingDir(), target);
    }

    public boolean build(String target, PrintWriter out, PrintWriter err, ActionMonitor progress) {
        if (progress == null) {
            progress = ActionMonitor.empty;
        }
        progress.begin(100);
        boolean result = this.internalBuild(target, out, err, progress);
        progress.done();
        return result;
    }

    private boolean internalBuild(String target, PrintWriter out, PrintWriter err, ActionMonitor progress) {
        if (target == null || target.length() == 0) {
            this.getErrorHandler().handleError(2, "Target is null or empty.");
            return false;
        }
        for (Rule rule : this.rules) {
            Pattern targetPattern = Pattern.compile(rule.getTarget(this));
            Matcher targetMatcher = targetPattern.matcher(target);
            if (!targetMatcher.matches()) continue;
            String[] dependencies = rule.getDependencies(this);
            String[] effectiveDependencies = new String[dependencies.length];
            for (int i = 0; i < dependencies.length; ++i) {
                String effective = dependencies[i];
                for (int j = 1; j < targetMatcher.groupCount() + 1; ++j) {
                    effective = effective.replaceAll("\\\\" + j, targetMatcher.group(j));
                }
                effectiveDependencies[i] = effective;
            }
            boolean needBuild = false;
            File targetFile = this.getFile(target);
            if (!targetFile.exists()) {
                needBuild = true;
            }
            for (String oneDependency : effectiveDependencies) {
                File depFile;
                if (this.build(oneDependency, out, err, progress)) {
                    needBuild = true;
                }
                if (needBuild || (depFile = this.getFile(oneDependency)).exists() && depFile.lastModified() <= targetFile.lastModified()) continue;
                needBuild = true;
            }
            if (needBuild) {
                rule.execute(target, effectiveDependencies, this, out, err, progress);
                return true;
            }
            return false;
        }
        if (this.targetExists(target)) {
            return false;
        }
        this.getErrorHandler().handleError(2, "No rule found for target: " + target);
        return false;
    }
}

