/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.runtime;

import fr.ensta.aefd.runtime.AEFDRuntimeInfos;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import plug.core.defaults.DefaultConfiguration;

public class AEFDRuntimeSystemState
extends DefaultConfiguration<AEFDRuntimeSystemState> {
    public static final int NO_CURRENT_EVENT = -1;
    private final int[] automatesStates;
    private final boolean[] variables;
    private final LinkedList<Integer> highPriorityQueue = new LinkedList();
    private final LinkedList<Integer> lowPriorityQueue = new LinkedList();
    private Integer currentEvent;
    private Set<Integer> executedAutomates = new HashSet<Integer>();
    private boolean isWarningState;
    private boolean isCutState;
    private boolean isRejectState;
    private static final String STRING_YES = "y";
    private static final String STRING_NO = "n";

    private AEFDRuntimeSystemState(int numberOfAutomates, int numberOfVariables) {
        this.automatesStates = new int[numberOfAutomates];
        this.variables = new boolean[numberOfVariables];
    }

    public AEFDRuntimeSystemState(AEFDRuntimeInfos runtimeInfos) {
        this(runtimeInfos.getNumberOfAutomates(), runtimeInfos.getNumberOfVariables());
        this.currentEvent = -1;
    }

    public AEFDRuntimeSystemState(AEFDRuntimeSystemState parent) {
        this(parent.getAutomatesStates().length, parent.getVariables().length);
        int eventIndex;
        System.arraycopy(parent.getAutomatesStates(), 0, this.getAutomatesStates(), 0, parent.getAutomatesStates().length);
        System.arraycopy(parent.getVariables(), 0, this.getVariables(), 0, parent.getVariables().length);
        Iterator iterator = parent.getHighPriorityQueue().iterator();
        while (iterator.hasNext()) {
            eventIndex = (Integer)iterator.next();
            this.getHighPriorityQueue().addLast(eventIndex);
        }
        iterator = parent.getLowPriorityQueue().iterator();
        while (iterator.hasNext()) {
            eventIndex = (Integer)iterator.next();
            this.getLowPriorityQueue().addLast(eventIndex);
        }
        this.getExecutedAutomates().addAll(parent.getExecutedAutomates());
        this.setCurrentEvent(parent.getCurrentEvent());
        this.setWarning(parent.isWarningState);
        this.setCut(parent.isCutState);
        this.setReject(parent.isRejectState);
    }

    public int[] getAutomatesStates() {
        return this.automatesStates;
    }

    public boolean[] getVariables() {
        return this.variables;
    }

    public LinkedList<Integer> getHighPriorityQueue() {
        return this.highPriorityQueue;
    }

    public LinkedList<Integer> getLowPriorityQueue() {
        return this.lowPriorityQueue;
    }

    public int getCurrentEvent() {
        return this.currentEvent;
    }

    public void setCurrentEvent(int eventIndex) {
        this.currentEvent = eventIndex;
    }

    public void clearCurrentEvent() {
        this.currentEvent = -1;
    }

    public boolean hasCurrentEvent() {
        return this.currentEvent != -1;
    }

    public Set<Integer> getExecutedAutomates() {
        return this.executedAutomates;
    }

    public boolean isStableState() {
        return !this.hasCurrentEvent() && this.highPriorityQueue.isEmpty() && this.lowPriorityQueue.isEmpty();
    }

    public boolean isWarningState() {
        return this.isWarningState;
    }

    public void setWarning(boolean warning) {
        this.isWarningState = warning;
    }

    public boolean isCutState() {
        return this.isCutState;
    }

    public void setCut(boolean cut) {
        this.isCutState = cut;
    }

    public boolean isRejectState() {
        return this.isRejectState;
    }

    public void setReject(boolean reject) {
        this.isRejectState = reject;
    }

    public boolean hasQueuedEvents() {
        return !this.getHighPriorityQueue().isEmpty() || !this.getLowPriorityQueue().isEmpty();
    }

    private static String shortStringFromQueue(LinkedList<Integer> queue) {
        StringBuilder builder = new StringBuilder("<");
        Iterator iterator = queue.iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        builder.append(">");
        return builder.toString();
    }

    private static String ynFromBool(boolean b) {
        return b ? STRING_YES : STRING_NO;
    }

    public String toString() {
        return "AEFDSystemState{states=" + Arrays.toString(this.getAutomatesStates()) + ", vars=" + Arrays.toString(this.getVariables()) + (this.hasCurrentEvent() ? ", events=(" + this.getCurrentEvent() + ", " + AEFDRuntimeSystemState.shortStringFromQueue(this.getHighPriorityQueue()) + ", " + AEFDRuntimeSystemState.shortStringFromQueue(this.getLowPriorityQueue()) + "), execSet=" + Arrays.toString(this.getExecutedAutomates().toArray()) : "") + ", warning? " + AEFDRuntimeSystemState.ynFromBool(this.isWarningState()) + ", cut? " + AEFDRuntimeSystemState.ynFromBool(this.isCutState()) + ", reject? " + AEFDRuntimeSystemState.ynFromBool(this.isRejectState()) + '}';
    }

    public boolean equals(Object other) {
        if (!(other instanceof AEFDRuntimeSystemState)) {
            return false;
        }
        AEFDRuntimeSystemState otherState = (AEFDRuntimeSystemState)((Object)other);
        if (this.getCurrentEvent() != otherState.getCurrentEvent()) {
            return false;
        }
        if (this.isWarningState() != otherState.isWarningState()) {
            return false;
        }
        if (this.isCutState() != otherState.isCutState()) {
            return false;
        }
        if (this.isRejectState() != otherState.isRejectState()) {
            return false;
        }
        if (!Arrays.equals(this.getAutomatesStates(), otherState.getAutomatesStates())) {
            return false;
        }
        if (!Arrays.equals(this.getVariables(), otherState.getVariables())) {
            return false;
        }
        if (!this.getHighPriorityQueue().equals(otherState.getHighPriorityQueue())) {
            return false;
        }
        if (!this.getLowPriorityQueue().equals(otherState.getLowPriorityQueue())) {
            return false;
        }
        return this.getExecutedAutomates().equals(otherState.getExecutedAutomates());
    }

    public AEFDRuntimeSystemState createCopy() {
        return new AEFDRuntimeSystemState(this);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.getAutomatesStates());
        result = 31 * result + Arrays.hashCode(this.getVariables());
        result = 31 * result + this.getHighPriorityQueue().hashCode();
        result = 31 * result + this.getLowPriorityQueue().hashCode();
        result = 31 * result + this.getCurrentEvent();
        result = 31 * result + this.getExecutedAutomates().hashCode();
        result = 31 * result + (this.isWarningState() ? 1 : 0);
        result = 31 * result + (this.isCutState() ? 1 : 0);
        result = 31 * result + (this.isRejectState() ? 1 : 0);
        return result;
    }
}

