/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.dot.diagram;

import obp.dot.Edge;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.xid.basics.geometry.Geometry;
import org.xid.basics.geometry.Polyline;
import org.xid.basics.ui.diagram.DiagramContext;
import org.xid.basics.ui.diagram.Element;
import org.xid.basics.ui.diagram.gc.GC;
import org.xid.basics.ui.diagram.gc.GcUtils;

public class EdgeElement
extends Element.Stub {
    private Edge model;

    public EdgeElement(Edge edge) {
        this.model = edge;
    }

    public Edge getModel() {
        return this.model;
    }

    public float[] getPoint() {
        return this.model.getPosition();
    }

    public void computeBounds(float[] result, DiagramContext context) {
        Geometry.computeBoundingRectangle((float[])this.model.getPosition(), (float[])result);
        if (this.model.getLabel() != null && this.model.getLabel().length() > 0) {
            float[] textExtent = new float[4];
            float[] centerPoint = this.getLabelPosition();
            GcUtils.getTextAlignedRectangle((GC)context.getServiceGc(), (String)this.model.getLabel(), (float)centerPoint[0], (float)centerPoint[1], (int)-1, (float[])textExtent);
            Geometry.rectangleMergeWithRectangle((float[])result, (float[])textExtent);
        }
        Geometry.expandRectangle((float[])result, (float)5.0f, (float)5.0f);
    }

    public void display(GC gc, DiagramContext context) {
        this.displayLine(gc, context);
        this.displayLabel(gc, context);
        this.displayHeadLabel(gc, context);
        this.displayTailLabel(gc, context);
    }

    private void displayLine(GC gc, DiagramContext context) {
        float[] line = Geometry.copyPoints((float[])this.model.getPosition());
        Path path = new Path((Device)Display.getCurrent());
        path.moveTo(line[0], line[1]);
        for (int i = 0; i < (line.length - 2) / 6; ++i) {
            int base = i * 6 + 2;
            path.cubicTo(line[base], line[base + 1], line[base + 2], line[base + 3], line[base + 4], line[base + 5]);
        }
        gc.drawPath(path);
        if (this.model.getEnd() != null) {
            float[] from = Polyline.getPoint((float[])line, (int)(Polyline.numPoints((float[])line) - 1));
            this.displayArrow(gc, context, from, this.model.getEnd());
        }
        path.dispose();
    }

    private void displayArrow(GC gc, DiagramContext context, float[] from, float[] to) {
        float arraySize = 0.5f;
        float x = (to[0] - from[0]) * arraySize;
        float y = (to[1] - from[1]) * arraySize;
        float[] polyline = new float[]{from[0] - y, from[1] + x, to[0], to[1], from[0] + y, from[1] - x, from[0] - y, from[1] + x};
        Color oldBackground = gc.getBackground();
        gc.setBackground(gc.getForeground());
        GcUtils.drawPolyline((GC)gc, (float[])polyline, (boolean)true);
        gc.setBackground(oldBackground);
    }

    private void displayLabel(GC gc, DiagramContext context) {
        if (this.model.getLabel() != null && this.model.getLabel().length() > 0) {
            float[] centerPoint = this.getLabelPosition();
            GcUtils.drawTextAligned((GC)gc, (String)this.model.getLabel(), (float)centerPoint[0], (float)centerPoint[1], (int)-1);
        }
    }

    private void displayHeadLabel(GC gc, DiagramContext context) {
        if (this.model.getHeadLabel() != null && this.model.getHeadLabel().length() > 0) {
            float[] centerPoint = this.getHeadLabelPosition();
            GcUtils.drawTextAligned((GC)gc, (String)this.model.getHeadLabel(), (float)centerPoint[0], (float)centerPoint[1], (int)-1);
        }
    }

    private void displayTailLabel(GC gc, DiagramContext context) {
        if (this.model.getTailLabel() != null && this.model.getTailLabel().length() > 0) {
            float[] centerPoint = this.getTailLabelPosition();
            GcUtils.drawTextAligned((GC)gc, (String)this.model.getTailLabel(), (float)centerPoint[0], (float)centerPoint[1], (int)-1);
        }
    }

    private float[] getLabelPosition() {
        if (this.model.getLabelPosition() != null) {
            return Geometry.copyPoints((float[])this.model.getLabelPosition());
        }
        float[] boundingBox = new float[4];
        Geometry.computeBoundingRectangle((float[])this.model.getPosition(), (float[])boundingBox);
        return Geometry.getRectanglePoint((float[])boundingBox, (int)-1);
    }

    private float[] getHeadLabelPosition() {
        if (this.model.getHeadLabelPosition() != null) {
            return Geometry.copyPoints((float[])this.model.getHeadLabelPosition());
        }
        float[] boundingBox = new float[4];
        Geometry.computeBoundingRectangle((float[])this.model.getPosition(), (float[])boundingBox);
        return Geometry.getRectanglePoint((float[])boundingBox, (int)4);
    }

    private float[] getTailLabelPosition() {
        if (this.model.getTailLabelPosition() != null) {
            return Geometry.copyPoints((float[])this.model.getTailLabelPosition());
        }
        float[] boundingBox = new float[4];
        Geometry.computeBoundingRectangle((float[])this.model.getPosition(), (float[])boundingBox);
        return Geometry.getRectanglePoint((float[])boundingBox, (int)0);
    }
}

