/*
 * Decompiled with CFR 0.152.
 */
package obp.tina;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import obp.aut.Aut;
import obp.aut.Edge;
import obp.aut.LTSDotPrinter;
import obp.aut.parser.AutParser;
import obp.cc.ConcreteContext;
import obp.cc2fiacre.ConcreteContextToFiacre;
import obp.dot.Graph;
import obp.dot.util.DotUtil;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.ComponentDecl;
import obp.fiacre.model.Composition;
import obp.fiacre.model.Declaration;
import obp.fiacre.model.Instance;
import obp.fiacre.model.InterfacedComp;
import obp.fiacre.model.LocalVariable;
import obp.fiacre.model.NodeDecl;
import obp.fiacre.model.Par;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Program;
import obp.fiacre.model.RefArg;
import obp.fiacre.util.FiacrePrinter;
import obp.fiacre.util.FiacreUtil;
import obp.fiacre.util.FracBranch;
import obp.partition.AutoSplitPartitioner;
import obp.result.ExplorationResultInfo;
import obp.tina.OBPtConfiguration;
import obp.tina.SeltResultAnalyzer;
import obp.tina.TinaResultAnalyzer;
import obp.tool.ToolController;
import obp.util.ConcreteContextUtil;
import org.xid.basics.Basics;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.generation.MergerUtil;
import org.xid.basics.progress.ActionMonitor;

public class TinaController
extends ToolController {
    private final String separator = System.getProperty("file.separator");
    private final OBPtConfiguration configuration;
    private String baseName;
    private boolean analyseSource;
    private Program program;
    private Map<String, FracBranch> transitions;

    public TinaController(OBPtConfiguration configuration, PrintWriter out, PrintWriter err) {
        super(out, err);
        this.configuration = configuration;
    }

    public boolean isAnalyseSource() {
        return this.analyseSource;
    }

    public void setAnalyseSource(boolean analyseSource) {
        this.analyseSource = analyseSource;
        if (!analyseSource) {
            this.program = null;
            this.transitions = null;
        }
    }

    public File getFileInTts(String suffix) {
        return new File(this.getWorkingDirectory(), this.getFilenameInTts(suffix));
    }

    private String getFilenameInTts(String suffix) {
        return this.baseName + ".tts" + this.separator + this.baseName + suffix;
    }

    public void exploreFiacre(File fiacreFile, ActionMonitor monitor) {
        this.scheduleClearResult();
        this.exploreAlone(fiacreFile, monitor);
    }

    private void exploreAlone(File fiacreFile, ActionMonitor monitor) {
        this.schedule(fiacreFile.getParentFile());
        this.baseName = TinaController.getBaseName(fiacreFile);
        this.frac();
        this.compile();
        this.tina(null);
        this.globalMonitor(monitor);
    }

    public void exploreFiacre(File fiacreFile, ConcreteContext context, ActionMonitor monitor) {
        this.scheduleClearResult();
        this.exploreWithContext(fiacreFile, context, monitor);
    }

    private void exploreWithContext(File fiacreFile, ConcreteContext context, ActionMonitor monitor) {
        String name = TinaController.getBaseName(fiacreFile) + "And" + context.getName() + ".fcr";
        if (this.configuration.isErasePreviousResult()) {
            name = TinaController.getBaseName(fiacreFile) + "AndContext.fcr";
        }
        File simulatedFile = new File(fiacreFile.getParentFile(), name);
        this.scheduleComposition(fiacreFile, context, simulatedFile);
        this.schedule(simulatedFile.getParentFile());
        this.baseName = TinaController.getBaseName(simulatedFile);
        this.frac();
        this.compile();
        this.tina(context);
        this.globalMonitor(monitor);
    }

    public void exploreFiacreAutoSplit(File fiacreFile, ConcreteContext context, int initialSplit, int splitStep, ActionMonitor monitor) {
        this.scheduleClearResult();
        AutoSplitPartitioner partitioner = new AutoSplitPartitioner(context, initialSplit, splitStep);
        this.exploreAutoSplit(fiacreFile, partitioner, monitor);
    }

    private void exploreAutoSplit(File fiacreFile, AutoSplitPartitioner partitioner, ActionMonitor monitor) {
        if (partitioner.hasNext()) {
            ConcreteContext context = partitioner.next();
            String name = TinaController.getBaseName(fiacreFile) + "And" + context.getName() + ".fcr";
            if (this.configuration.isErasePreviousResult()) {
                name = TinaController.getBaseName(fiacreFile) + "AndContext.fcr";
            }
            File simulatedFile = new File(fiacreFile.getParentFile(), name);
            this.scheduleComposition(fiacreFile, context, simulatedFile);
            this.schedule(simulatedFile.getParentFile());
            this.baseName = TinaController.getBaseName(simulatedFile);
            this.frac();
            this.compile();
            this.tina(context);
            this.scheduleNextStep(fiacreFile, context, partitioner, monitor);
            this.globalMonitor(monitor);
        }
    }

    private void composeContext(Program program, ProcessDecl context) {
        Par par;
        NodeDecl root = program.getRoot();
        int contextIndex = -1;
        for (int i = 0; i < program.getDeclarationCount(); ++i) {
            Declaration decl = program.getDeclaration(i);
            if (!decl.getName().equals(root.getName())) continue;
            contextIndex = i;
        }
        program.addDeclaration(contextIndex, context);
        if (!(root instanceof ComponentDecl)) {
            String message = "Root node isn't a component, can't compose with context.";
            this.getErrorHandler().handleError(2, message + "\n");
            throw new RuntimeException(message);
        }
        ComponentDecl component = (ComponentDecl)root;
        Instance contextInstance = new Instance();
        contextInstance.setType(context);
        block1: for (ArgumentVariable argument : context.getArgList()) {
            String name = argument.getName();
            for (LocalVariable rootVariable : root.getVarList()) {
                if (!rootVariable.getName().equals(name)) continue;
                RefArg arg = new RefArg();
                arg.setRef(rootVariable);
                contextInstance.addArg(arg);
                continue block1;
            }
        }
        InterfacedComp interfacedComp = new InterfacedComp();
        interfacedComp.setComposition(contextInstance);
        Composition composition = component.getBody();
        if (composition instanceof Par) {
            par = (Par)composition;
            par.addArg(interfacedComp);
        } else if (composition instanceof Instance) {
            par = new Par();
            InterfacedComp compositionInterfacedComp = new InterfacedComp();
            compositionInterfacedComp.setComposition(composition);
            par.addArg(compositionInterfacedComp);
            par.addArg(interfacedComp);
            component.setBody(par);
        } else {
            String message = "Internal error, composition isn't a Par or an Instance.";
            this.getErrorHandler().handleError(2, message + "\n");
            throw new RuntimeException(message);
        }
    }

    private void scheduleComposition(final File sourceFile, final ConcreteContext context, final File targetFile) {
        this.schedule(new Runnable(){

            @Override
            public void run() {
                TinaController.this.println("---------------------------------------------------");
                TinaController.this.println("---> Exploring for context '" + context.getName() + "' (" + context.getStateCount() + " states and " + context.getTransitionCount() + " transitions).");
                try {
                    Program program = FiacreUtil.loadProgram(sourceFile);
                    ProcessDecl contextProcess = ConcreteContextToFiacre.toProcess(context, program);
                    contextProcess.setName("Context");
                    TinaController.this.composeContext(program, contextProcess);
                    MergerUtil.writeFile((File)targetFile, (String)FiacrePrinter.toString(program), (String)"UTF-8");
                }
                catch (Exception e) {
                    String message = DiagnosticUtil.createMessage((Throwable)e);
                    TinaController.this.getErrorHandler().handleError(2, message + "\n");
                    throw new RuntimeException(e);
                }
                if (TinaController.this.isAnalyseSource()) {
                    try {
                        TinaController.this.program = FiacreUtil.loadProgram(targetFile);
                        TinaController.this.transitions = FiacreUtil.identifyAllFracBranches(TinaController.this.program);
                    }
                    catch (Exception e) {
                        TinaController.this.getErrorHandler().handleError(1, "Couldn't parse Fiacre program.\n");
                        TinaController.this.program = null;
                        TinaController.this.transitions = null;
                    }
                }
            }
        });
    }

    private void scheduleNextStep(final File fiacreFile, final ConcreteContext context, final AutoSplitPartitioner partitioner, final ActionMonitor monitor) {
        this.schedule(new Runnable(){

            @Override
            public void run() {
                ExplorationResultInfo result = (ExplorationResultInfo)TinaController.this.peekResult(ExplorationResultInfo.class);
                if (result.isComplete()) {
                    TinaController.this.println("---> Exploration of context '" + context.getName() + "' succeeded.");
                } else if (ConcreteContextUtil.hasOnePath(context)) {
                    TinaController.this.println("---> Exploration of context '" + context.getName() + "' failed!\t\t***CANNOT SPLIT CONTEXT*** because the context has only one path.");
                } else {
                    TinaController.this.println("---> Exploration of context '" + context.getName() + "' failed, split it.");
                    partitioner.explorationFailed();
                }
                TinaController.this.exploreAutoSplit(fiacreFile, partitioner, monitor);
            }
        });
    }

    private void frac() {
        String[] command = new String[]{this.configuration.getFracDirectory() + this.separator + (Basics.isWindows() ? "frac.exe" : "frac"), this.baseName + ".fcr", this.baseName + ".tts"};
        this.schedule(command);
        this.schedulePopResult();
    }

    private void compile() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.configuration.getGcc());
        command.add("-m" + TinaController.tinaArchitecture());
        command.add("-O2");
        command.add("-shared");
        for (String flag : TinaController.cflags()) {
            command.add(flag);
        }
        command.add("-o");
        command.add(this.getFilenameInTts("." + TinaController.dynamicLibraryExtension()));
        command.add("-I");
        command.add(this.configuration.getFracDirectory() + this.separator + "lib");
        command.add("-I");
        command.add(this.configuration.getFracDirectory() + this.separator + "lib" + this.separator + "avl");
        command.add(this.getFilenameInTts(".c"));
        this.schedule(command.toArray(new String[command.size()]));
        this.schedulePopResult();
    }

    private void tina(ConcreteContext context) {
        String ktzFile = this.getFilenameInTts(".ktz");
        ExplorationResultInfo resultInfo = new ExplorationResultInfo(context, null, new File(ktzFile));
        this.schedule(new TinaResultAnalyzer(resultInfo));
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.configuration.getTinaDirectory() + this.separator + "bin" + this.separator + (Basics.isWindows() ? "tina.exe" : "tina"));
        command.add("-ktz");
        String options = this.configuration.getTinaOptions();
        if (options != null && options.length() > 0) {
            for (String option : options.split(" ")) {
                command.add(option);
            }
        }
        command.add(this.baseName + ".tts");
        command.add(ktzFile);
        this.schedule(command.toArray(new String[command.size()]));
    }

    public void check(File ltlFile, boolean useDescription, ActionMonitor monitor) {
        if (this.baseName == null) {
            return;
        }
        this.scheduleClearResult();
        this.selt(ltlFile, useDescription);
        this.schedule(monitor);
    }

    private void selt(File ltlFile, boolean useDescription) {
        this.schedule(new SeltResultAnalyzer(this, useDescription));
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.configuration.getTinaDirectory() + this.separator + "bin" + this.separator + (Basics.isWindows() ? "selt.exe" : "selt"));
        String options = this.configuration.getSeltOptions();
        if (options != null && options.length() > 0) {
            for (String option : options.split(" ")) {
                command.add(option);
            }
        }
        if (this.configuration.getPreludeFile() != null) {
            command.add("-prelude");
            command.add(this.configuration.getPreludeFile());
        }
        command.add(this.getFilenameInTts(".ktz"));
        command.add(ltlFile.getAbsolutePath());
        this.schedule(command.toArray(new String[command.size()]));
    }

    public void ktzio(String options, ActionMonitor monitor) {
        this.scheduleClearResult();
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.configuration.getTinaDirectory() + this.separator + "bin" + this.separator + (Basics.isWindows() ? "ktzio.exe" : "ktzio"));
        command.add("-KTZ");
        command.add(this.getFilenameInTts(".ktz"));
        if (options != null) {
            command.addAll(Arrays.asList(options.split(" ")));
        }
        this.schedule(command.toArray(new String[command.size()]));
        this.schedule(monitor);
    }

    public void extractExplorationGraph(final boolean useDescription, ActionMonitor monitor) {
        this.scheduleClearResult();
        final String autFilename = this.getFilenameInTts(".aut");
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.configuration.getTinaDirectory() + this.separator + "bin" + this.separator + (Basics.isWindows() ? "ktzio.exe" : "ktzio"));
        command.add("-KTZ");
        command.add(this.getFilenameInTts(".ktz"));
        command.add("-aut");
        command.add(autFilename);
        this.schedule(command.toArray(new String[command.size()]));
        this.schedule(new Runnable(){

            @Override
            public void run() {
                Aut aut = null;
                try {
                    File autFile = new File(TinaController.this.getWorkingDirectory(), autFilename);
                    AutParser parser = new AutParser(new BufferedInputStream(new FileInputStream(autFile)));
                    parser.parse();
                    aut = parser.getGraph();
                    FiacrePrinter printer = new FiacrePrinter();
                    printer.setSeparator("\\n");
                    for (Edge edge : aut.getEdgeList()) {
                        String label = edge.getLabel();
                        String[] ids = FiacreUtil.decomposeFracTransition(label);
                        if (ids == null) continue;
                        StringBuilder newLabel = new StringBuilder();
                        for (String id : ids) {
                            if (newLabel.length() > 0) {
                                newLabel.append("\n");
                            }
                            newLabel.append(id);
                            newLabel.append(": ");
                            FracBranch transitionBranch = TinaController.this.getTransitionBranch(id);
                            if (transitionBranch == null) continue;
                            if (useDescription) {
                                newLabel.append(transitionBranch.getDescription());
                                continue;
                            }
                            if (newLabel.length() > 0) {
                                newLabel.append("\\n");
                            }
                            newLabel.append(printer.print(transitionBranch.getAction()));
                        }
                        edge.setLabel(newLabel.toString());
                    }
                    TinaController.this.popResult(String.class);
                    Graph explorationGraph = DotUtil.layoutDot(LTSDotPrinter.toDot(aut));
                    TinaController.this.pushResult(explorationGraph);
                }
                catch (Exception e) {
                    TinaController.this.getErrorHandler().handleError(1, DiagnosticUtil.createMessage((Throwable)e));
                }
            }
        });
        this.schedule(monitor);
    }

    public FracBranch getTransitionBranch(String id) {
        if (this.transitions == null) {
            return null;
        }
        String[] fragments = FiacreUtil.decomposeFracDescription(id);
        if (fragments == null) {
            return null;
        }
        return this.transitions.get(fragments[0] + "_t" + fragments[3]);
    }

    public void dot(File sourceFile, String options, File destinationFile, ActionMonitor monitor) {
        this.scheduleClearResult();
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.configuration.getTinaDirectory() + this.separator + "bin" + this.separator + (Basics.isWindows() ? "dot.exe" : "dot"));
        if (options != null) {
            command.addAll(Arrays.asList(options.split(" ")));
        }
        command.add(sourceFile.getAbsolutePath());
        command.add("-o");
        command.add(destinationFile.getAbsolutePath());
        this.schedule(command.toArray(new String[command.size()]));
        this.schedule(monitor);
    }

    private static String[] cflags() {
        String os = System.getProperty("os.name");
        if (os.contains("Mac OS X")) {
            return new String[0];
        }
        if (os.contains("Windows")) {
            return new String[]{"-DMINGW"};
        }
        if (os.contains("Linux")) {
            return new String[]{"-fPIC", "-fpic"};
        }
        return new String[0];
    }

    public static String tinaArchitecture() {
        String os = System.getProperty("os.name");
        if (os.contains("Mac OS X")) {
            return "32";
        }
        return System.getProperty("sun.arch.data.model");
    }
}

