/*
 * Decompiled with CFR 0.152.
 */
package obp.interpreter.runtime;

import java.io.IOException;
import java.util.List;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.ExplorationContext;
import obp.explorer.runtime.core.Channel;
import obp.explorer.runtime.core.Transition;
import obp.explorer.runtime.obs.AtomicAction;
import obp.interpreter.IBehavior;
import obp.interpreter.ITransition;
import obp.interpreter.runtime.BehaviorConfigurationImpl;
import obp.interpreter.runtime.InterpreterContext;
import obp.lua.LuaUtil;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaClosure;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;

public class TransitionImpl
extends Transition {
    private final InterpreterContext context;
    private boolean useEvent;
    private final short channelId;
    private final short channelType;
    private final LuaClosure guard;
    private final LuaClosure action;

    public TransitionImpl(InterpreterContext context, IBehavior behavior, short behaviorId, ITransition transition) throws IOException {
        super(behaviorId);
        this.context = context;
        String on = transition.getOn();
        if (on != null) {
            this.channelType = 1;
            this.channelId = context.getSymbols().getChannelId(on);
        } else {
            this.channelType = 0;
            this.channelId = (short)-1;
        }
        Globals lua = context.getLua();
        StringBuilder parameterList = new StringBuilder();
        for (String parameterName : behavior.getValueList()) {
            if (parameterList.length() > 0) {
                parameterList.append(", ");
            }
            parameterList.append(parameterName);
        }
        String guardString = transition.getGuard();
        if (guardString != null) {
            StringBuilder guardBuilder = new StringBuilder();
            guardBuilder.append("return function (");
            guardBuilder.append((CharSequence)parameterList);
            guardBuilder.append(");");
            guardBuilder.append(guardString);
            guardBuilder.append(";end");
            this.guard = (LuaClosure)LuaUtil.parseString(guardBuilder.toString(), lua).call();
        } else {
            this.guard = null;
        }
        String actionString = transition.getAction();
        if (actionString != null) {
            StringBuilder actionBuilder = new StringBuilder();
            actionBuilder.append("return function (");
            actionBuilder.append((CharSequence)parameterList);
            actionBuilder.append(");");
            actionBuilder.append(actionString);
            actionBuilder.append(";return ");
            actionBuilder.append((CharSequence)parameterList);
            actionBuilder.append(";end");
            this.action = (LuaClosure)LuaUtil.parseString(actionBuilder.toString(), lua).call();
        } else {
            this.action = null;
        }
    }

    protected void prepare() {
        this.useEvent = this.actionModifyEvents();
    }

    private boolean actionModifyEvents() {
        if (this.action == null) {
            return false;
        }
        for (LuaValue value : this.action.p.k) {
            if (!this.context.doesLuaConstantUseEvents(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public short getSynchronisationType() {
        return this.channelType;
    }

    @Override
    public short getSynchronisationChannelId() {
        return this.channelId;
    }

    @Override
    public void updateModifiedBehaviors(Configuration configuration, ExplorationContext context, boolean[] modifiedBehaviors) {
        if (this.useEvent) {
            modifiedBehaviors[0] = true;
        }
    }

    @Override
    public boolean guard(Configuration configuration, ExplorationContext context) {
        if (this.guard == null) {
            return true;
        }
        this.context.exploring(this.behaviorId, null, configuration);
        BehaviorConfigurationImpl conf = (BehaviorConfigurationImpl)configuration.behaviorConfigurations[this.behaviorId];
        return this.guard.invoke(conf.values).checkboolean(1);
    }

    @Override
    public boolean action(ExplorationContext context, List<AtomicAction> actions2, Configuration configuration) {
        if (this.channelId >= 0) {
            Channel channel = context.getChannel(this.channelId);
            channel.input(this.behaviorId, actions2);
        }
        if (this.action == null) {
            return true;
        }
        this.context.exploring(this.behaviorId, actions2, configuration);
        BehaviorConfigurationImpl conf = (BehaviorConfigurationImpl)configuration.behaviorConfigurations[this.behaviorId];
        Varargs result = this.action.invoke(conf.values);
        for (int i = 0; i < conf.values.length; ++i) {
            conf.values[i] = result.arg(i + 1);
        }
        return true;
    }
}

