/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.simulation;

import java.util.ArrayList;
import java.util.List;
import obp.cc.ConcreteContext;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.ProcessBehavior;
import obp.explorer.runtime.ProgramLoader;
import obp.explorer.runtime.core.Transition;
import obp.explorer.runtime.simulation.ITransitionSelectionPolicy;
import obp.explorer.runtime.simulation.Simulator;

public class LocalNondeterministicSimulator
extends Simulator {
    public LocalNondeterministicSimulator(ProgramLoader programLoader) {
        this(programLoader, null);
    }

    public LocalNondeterministicSimulator(ProgramLoader programLoader, ConcreteContext context) {
        this(programLoader, context, (ITransitionSelectionPolicy)null);
    }

    public LocalNondeterministicSimulator(ProgramLoader programLoader, ConcreteContext context, ITransitionSelectionPolicy policy) {
        super(programLoader, context, policy);
    }

    @Override
    protected void simulate(Configuration configuration) {
        for (int i = 0; i < this.behaviorCount; i = (int)((short)(i + 1))) {
            ProcessBehavior behavior = (ProcessBehavior)this.behaviors[i];
            ArrayList<Transition> fireable = new ArrayList<Transition>();
            for (Transition transition : behavior.getTransitions(configuration)) {
                if (!transition.guard(configuration, this)) continue;
                fireable.add(transition);
            }
            List<Transition> toFire = this.mSelectionPolicy.selectFromFireable(fireable);
            if (toFire == null) continue;
            for (Transition transition : toFire) {
                short channelId = transition.getSynchronisationChannelId();
                if (channelId == -1) {
                    this.transitionExecutor.executeAlone(configuration, transition);
                    continue;
                }
                this.synchronizationExecuter.addTransition(channelId, transition);
            }
        }
        this.synchronizationExecuter.computeSynchronizedTransition(configuration, this.transitionExecutor);
    }
}

