/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.runtime;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDBooleanVariable;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.AEFDModelObject;
import fr.ensta.aefd.runtime.AEFDRuntimeInfos;
import fr.ensta.aefd.runtime.AEFDRuntimeSystemState;
import fr.ensta.aefd.toolbox.tools.printer.ExtendedAEFDTXTPrinter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AEFDRuntimePrinter {
    public static final String DEFAULT_TABULATION = "    ";
    private final AEFDModel model;
    private final AEFDRuntimeInfos infos;
    private final ExtendedAEFDTXTPrinter modelPrinter;

    public AEFDRuntimePrinter(AEFDModel model, AEFDRuntimeInfos infos) {
        this.model = model;
        this.infos = infos;
        this.modelPrinter = new ExtendedAEFDTXTPrinter();
    }

    public String getAEFDString(AEFDModelObject modelObject) {
        return this.modelPrinter.getString(modelObject);
    }

    private String format(int index, String modelObjectShortString) {
        return index + ": '" + modelObjectShortString + "'";
    }

    public String getEventInfoString(AEFDFunctionalEntity event) {
        return this.format(this.infos.getEventIndex(event), event.getIdentifier());
    }

    public String getEventInfoString(int eventIndex) {
        return this.format(eventIndex, this.infos.getEventFromIndex(eventIndex).getIdentifier());
    }

    public List<String> getEventsInfosStrings() {
        LinkedList<String> result = new LinkedList<String>();
        for (int eventIndex = 0; eventIndex < this.infos.getNumberOfEvents(); ++eventIndex) {
            result.add(this.getEventInfoString(eventIndex));
        }
        return result;
    }

    public String getVariableInfoString(AEFDBooleanVariable variable) {
        return this.format(this.infos.getVariableIndex(variable), variable.getName());
    }

    public String getVariableInfoString(int variableIndex) {
        return this.format(variableIndex, this.infos.getVariableFromIndex(variableIndex).getName());
    }

    public List<String> getVariablesInfosStrings() {
        LinkedList<String> result = new LinkedList<String>();
        for (int variableIndex = 0; variableIndex < this.infos.getNumberOfVariables(); ++variableIndex) {
            result.add(this.getVariableInfoString(variableIndex));
        }
        return result;
    }

    public String getAutomateInfoString(AEFDAutomate automate) {
        return this.format(this.infos.getAutomateIndex(automate), automate.getName());
    }

    public String getAutomateInfoString(int automateIndex) {
        return this.format(automateIndex, this.infos.getAutomateFromIndex(automateIndex).getName());
    }

    public List<String> getAutomatesInfosStrings() {
        LinkedList<String> result = new LinkedList<String>();
        for (int automateIndex = 0; automateIndex < this.infos.getNumberOfAutomates(); ++automateIndex) {
            result.add(this.getAutomateInfoString(automateIndex));
        }
        return result;
    }

    public String getAutomateStateInfoString(AEFDAutomate automate, String state) {
        return this.format(this.infos.getAutomateStateIndex(automate, state), state);
    }

    public String getAutomateStateInfoString(AEFDAutomate automate, int stateIndex) {
        return this.format(stateIndex, this.infos.getAutomateStateFromIndex(automate, stateIndex));
    }

    public String getAutomateStateInfoString(int automateIndex, String state) {
        AEFDAutomate automate = this.infos.getAutomateFromIndex(automateIndex);
        return this.getAutomateStateInfoString(automate, state);
    }

    public String getAutomateStateInfoString(int automateIndex, int stateIndex) {
        AEFDAutomate automate = this.infos.getAutomateFromIndex(automateIndex);
        return this.getAutomateStateInfoString(automate, stateIndex);
    }

    public List<String> getAutomateStatesInfosStrings(AEFDAutomate automate) {
        LinkedList<String> result = new LinkedList<String>();
        for (int stateIndex = 0; stateIndex < this.infos.getNumberOfStates(automate); ++stateIndex) {
            result.add(this.getAutomateStateInfoString(automate, stateIndex));
        }
        return result;
    }

    public List<String> getAutomateStatesInfosStrings(int automateIndex) {
        AEFDAutomate automate = this.infos.getAutomateFromIndex(automateIndex);
        return this.getAutomateStatesInfosStrings(automate);
    }

    public List<String> getInfosStrings(String tabulation, boolean includeStates) {
        LinkedList<String> result = new LinkedList<String>();
        result.add("AEFD Model Objects Indexes");
        result.add(tabulation + "Events");
        for (String eventString : this.getEventsInfosStrings()) {
            result.add(tabulation + tabulation + eventString);
        }
        result.add(tabulation + "Variables");
        for (String variableString : this.getVariablesInfosStrings()) {
            result.add(tabulation + tabulation + variableString);
        }
        result.add(tabulation + "Automates");
        for (String automateString : this.getAutomatesInfosStrings()) {
            result.add(tabulation + tabulation + automateString);
        }
        if (includeStates) {
            result.add(tabulation + "Automate States");
            for (int automateIndex = 0; automateIndex < this.infos.getNumberOfAutomates(); ++automateIndex) {
                result.add(tabulation + tabulation + this.getAutomateInfoString(automateIndex));
                for (String stateString : this.getAutomateStatesInfosStrings(automateIndex)) {
                    result.add(tabulation + tabulation + tabulation + stateString);
                }
            }
        }
        return result;
    }

    public List<String> getInfosStrings(boolean includeStates) {
        return this.getInfosStrings(DEFAULT_TABULATION, includeStates);
    }

    public List<String> getInfosStrings() {
        return this.getInfosStrings(DEFAULT_TABULATION, true);
    }

    public String getLongInfosString(String tabulation, boolean includeStates) {
        List<String> strings = this.getInfosStrings(tabulation, includeStates);
        StringBuilder result = new StringBuilder();
        for (String string : strings) {
            result.append(string).append("\n");
        }
        return result.toString();
    }

    public String getLongInfosString(boolean includeStates) {
        return this.getLongInfosString(DEFAULT_TABULATION, includeStates);
    }

    public String getLongInfosString() {
        return this.getLongInfosString(DEFAULT_TABULATION, true);
    }

    public String getSystemStateLongString(AEFDRuntimeSystemState systemState, String tabulation) {
        StringBuilder result = new StringBuilder("AEFDRuntimeSystemState {\n");
        for (int automateIndex = 0; automateIndex < this.infos.getNumberOfAutomates(); ++automateIndex) {
            AEFDAutomate automate = this.infos.getAutomateFromIndex(automateIndex);
            int automateStateIndex = systemState.getAutomatesStates()[automateIndex];
            String automateState = this.infos.getAutomateStateFromIndex(automate, automateStateIndex);
            result.append(tabulation).append(automate.getName()).append("@").append(automateState).append("\n");
        }
        for (int variableIndex = 0; variableIndex < this.infos.getNumberOfVariables(); ++variableIndex) {
            AEFDBooleanVariable variable = this.infos.getVariableFromIndex(variableIndex);
            boolean value = systemState.getVariables()[variableIndex];
            result.append(tabulation).append(variable.getName()).append(" is ").append(value).append("\n");
        }
        if (!systemState.hasCurrentEvent() && !systemState.hasQueuedEvents()) {
            result.append(tabulation).append("No current nor queued events (stable)\n");
        } else {
            String eventString = systemState.hasCurrentEvent() ? this.infos.getEventFromIndex(systemState.getCurrentEvent()).getIdentifier() : "none";
            result.append(tabulation).append("Current Event: ").append(eventString).append("\n");
            result.append(tabulation).append("<<\n");
            this.appendEvents(result, systemState.getHighPriorityQueue(), tabulation);
            result.append(tabulation).append("<<\n");
            this.appendEvents(result, systemState.getLowPriorityQueue(), tabulation);
            result.append(tabulation).append("<<\n");
        }
        if (systemState.isWarningState()) {
            result.append(tabulation).append("!WARNING! THROWN\n");
        }
        if (systemState.isCutState()) {
            result.append(tabulation).append("!CUT! THROWN");
        }
        if (systemState.isRejectState()) {
            result.append(tabulation).append("!REJECT! THROWN");
        }
        result.append("}\n");
        return result.toString();
    }

    private void appendEvents(StringBuilder result, LinkedList<Integer> queue, String tabulation) {
        Iterator iterator = queue.iterator();
        while (iterator.hasNext()) {
            int eventIndex = (Integer)iterator.next();
            AEFDFunctionalEntity event = this.infos.getEventFromIndex(eventIndex);
            result.append(tabulation).append(tabulation).append(event.getIdentifier()).append("\n");
        }
    }

    public String getSystemStateLongString(AEFDRuntimeSystemState systemState) {
        return this.getSystemStateLongString(systemState, DEFAULT_TABULATION);
    }
}

