/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.runtime;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDBooleanExpression;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.model.meta.ModelReferences;
import fr.ensta.aefd.runtime.AEFDAtomicPropositionEvaluator;
import fr.ensta.aefd.runtime.AEFDRuntimeActionExecutor;
import fr.ensta.aefd.runtime.AEFDRuntimeGuardEvaluator;
import fr.ensta.aefd.runtime.AEFDRuntimeInfos;
import fr.ensta.aefd.runtime.AEFDRuntimeInfosImpl;
import fr.ensta.aefd.runtime.AEFDRuntimeInitialStateProvider;
import fr.ensta.aefd.runtime.AEFDRuntimePrinter;
import fr.ensta.aefd.runtime.AEFDRuntimeSystemState;
import fr.ensta.aefd.toolbox.tools.analysis.basic.ReceivedEventsAnalysis;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import plug.core.IAtomicPropositionsEvaluator;
import plug.core.IFiredTransition;
import plug.core.ITransitionRelation;
import plug.statespace.transitions.FiredTransition;

public class AEFDRuntime
implements ITransitionRelation<AEFDRuntimeSystemState, AEFDTransition> {
    AEFDAtomicPropositionEvaluator evaluator;
    AEFDModel model;
    public AEFDRuntimeInfos infos;
    private AEFDRuntimeActionExecutor actionExecutor;
    private AEFDRuntimeGuardEvaluator guardEvaluator;
    private AEFDRuntimeInitialStateProvider initialStateProvider;
    ModelReferences references;
    private final ReceivedEventsAnalysis receivedEvents = new ReceivedEventsAnalysis();
    public AEFDRuntimePrinter printer;

    public void loadModel(AEFDModel model) {
        this.model = model;
        this.infos = new AEFDRuntimeInfosImpl(model);
        this.actionExecutor = new AEFDRuntimeActionExecutor(this.infos);
        this.guardEvaluator = new AEFDRuntimeGuardEvaluator(this.infos);
        this.printer = new AEFDRuntimePrinter(model, this.infos);
        this.receivedEvents.analyze(model);
        this.references = new ModelReferences(model);
        this.references.synchronizeUsed();
        this.initialStateProvider = new AEFDRuntimeInitialStateProvider(this.infos);
        this.evaluator = new AEFDAtomicPropositionEvaluator(this);
    }

    public void provideInitialVariableValues(String[] identifiers) {
        this.initialStateProvider.setVariableInitialValues(this.references, identifiers);
    }

    public void provideInitialVariableValues(Collection<String> identifiers) {
        this.provideInitialVariableValues(identifiers.toArray(new String[identifiers.size()]));
    }

    public Set<AEFDRuntimeSystemState> initialConfigurations() {
        return this.initialStateProvider.getInitialStates();
    }

    List<Set<AEFDAutomate>> getOrderedSensibleAutomata(Set<AEFDAutomate> automata) {
        LinkedList<Set<AEFDAutomate>> result = new LinkedList<Set<AEFDAutomate>>();
        LinkedList<AEFDAutomate> priorityQueue = new LinkedList<AEFDAutomate>(automata);
        Collections.sort(priorityQueue, this.model.getExecutionOrder());
        HashSet<AEFDAutomate> currentSet = new HashSet<AEFDAutomate>();
        AEFDAutomate lastAdded = null;
        for (AEFDAutomate automate : priorityQueue) {
            if (lastAdded != null && this.model.getExecutionOrder().compare(automate, lastAdded) != 0) {
                result.add(currentSet);
                currentSet = new HashSet();
            }
            currentSet.add(automate);
            lastAdded = automate;
        }
        if (!currentSet.isEmpty()) {
            result.add(currentSet);
        }
        return result;
    }

    public Set<AEFDTransition> getTransitionsToFire(AEFDRuntimeSystemState source, AEFDFunctionalEntity event) {
        HashSet<AEFDTransition> transitionsToFire = new HashSet<AEFDTransition>();
        Set sensibleAutomates = (Set)this.receivedEvents.getTargetMap().get(event);
        List<Set<AEFDAutomate>> executionOrder = this.getOrderedSensibleAutomata(sensibleAutomates);
        for (Set<AEFDAutomate> priorityGroup : executionOrder) {
            for (AEFDAutomate automate : priorityGroup) {
                int automateIndex = this.infos.getAutomateIndex(automate);
                if (source.getExecutedAutomates().contains(automateIndex)) continue;
                Set sensibleTransitions = this.receivedEvents.getSensibleTransitions(automate, event);
                int automateStateIndex = source.getAutomatesStates()[automateIndex];
                String automateState = this.infos.getAutomateStateFromIndex(automate, automateStateIndex);
                for (AEFDTransition transition : sensibleTransitions) {
                    if (!transition.getPlaceSource().equals(automateState) || !this.guardEvaluator.evaluateGuard(source, transition)) continue;
                    transitionsToFire.add(transition);
                }
            }
            if (transitionsToFire.isEmpty()) continue;
            return transitionsToFire;
        }
        return transitionsToFire;
    }

    public boolean hasTransitionsToFire(AEFDRuntimeSystemState source, AEFDFunctionalEntity event) {
        Set sensibleAutomates = (Set)this.receivedEvents.getTargetMap().get(event);
        for (AEFDAutomate automate : sensibleAutomates) {
            int automateIndex = this.infos.getAutomateIndex(automate);
            if (source.getExecutedAutomates().contains(automateIndex)) continue;
            Set sensibleTransitions = this.receivedEvents.getSensibleTransitions(automate, event);
            int automateStateIndex = source.getAutomatesStates()[automateIndex];
            String automateState = this.infos.getAutomateStateFromIndex(automate, automateStateIndex);
            for (AEFDTransition transition : sensibleTransitions) {
                if (!transition.getPlaceSource().equals(automateState) || !this.guardEvaluator.evaluateGuard(source, transition)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<AEFDTransition> getTriggerLessTransitionsToFire(AEFDRuntimeSystemState source) {
        HashSet<AEFDTransition> result = new HashSet<AEFDTransition>();
        for (int automateIndex = 0; automateIndex < this.infos.getNumberOfAutomates(); ++automateIndex) {
            AEFDAutomate automate = this.infos.getAutomateFromIndex(automateIndex);
            int automateStateIndex = source.getAutomatesStates()[automateIndex];
            String automateState = this.infos.getAutomateStateFromIndex(automate, automateStateIndex);
            for (AEFDTransition transition : automate.getTransitionSet()) {
                if (transition.getEvent().getBoolExp() != AEFDBooleanExpression.TRUE || !transition.getPlaceSource().equals(automateState) || !this.guardEvaluator.evaluateGuard(source, transition)) continue;
                result.add(transition);
            }
        }
        return result;
    }

    public Collection<AEFDTransition> fireableTransitionsFrom(AEFDRuntimeSystemState source) {
        if (source.hasCurrentEvent()) {
            int currentEventIndex = source.getCurrentEvent();
            return this.getTransitionsToFire(source, this.infos.getEventFromIndex(currentEventIndex));
        }
        return this.getTriggerLessTransitionsToFire(source);
    }

    public void finalizeTarget(AEFDRuntimeSystemState target) {
        if (target.hasCurrentEvent()) {
            int currentEventIndex = target.getCurrentEvent();
            AEFDFunctionalEntity currentEvent = this.infos.getEventFromIndex(currentEventIndex);
            if (!this.hasTransitionsToFire(target, currentEvent)) {
                target.getExecutedAutomates().clear();
                target.clearCurrentEvent();
            }
        } else {
            target.getExecutedAutomates().clear();
            target.setWarning(false);
        }
        while (!target.hasCurrentEvent() && target.hasQueuedEvents()) {
            int nextEventIndex = target.getHighPriorityQueue().isEmpty() ? target.getLowPriorityQueue().removeFirst().intValue() : target.getHighPriorityQueue().removeFirst().intValue();
            AEFDFunctionalEntity nextEvent = this.infos.getEventFromIndex(nextEventIndex);
            if (!this.hasTransitionsToFire(target, nextEvent)) continue;
            target.setCurrentEvent(nextEventIndex);
        }
    }

    public IFiredTransition<AEFDRuntimeSystemState, AEFDTransition> fireOneTransition(AEFDRuntimeSystemState source, AEFDTransition transition) {
        int targetAutomateStateIndex;
        AEFDRuntimeSystemState target = new AEFDRuntimeSystemState(source);
        AEFDAutomate automate = this.infos.getTransitionOwner(transition);
        int automateIndex = this.infos.getAutomateIndex(automate);
        this.actionExecutor.executeActions(target, transition);
        if (target.isCutState()) {
            return null;
        }
        target.getAutomatesStates()[automateIndex] = targetAutomateStateIndex = this.infos.getAutomateStateIndex(automate, transition.getPlaceTarget());
        target.getExecutedAutomates().add(automateIndex);
        this.finalizeTarget(target);
        return new FiredTransition((Object)source, (Object)target, (Object)transition);
    }

    public Collection<AEFDRuntimeSystemState> getSuccessors(AEFDRuntimeSystemState source) {
        Collection<AEFDTransition> transitionsToFire = this.fireableTransitionsFrom(source);
        if (transitionsToFire.size() == 0) {
            return Collections.emptySet();
        }
        if (transitionsToFire.size() == 1) {
            AEFDTransition transition = transitionsToFire.iterator().next();
            return this.fireOneTransition(source, transition).getTargets();
        }
        HashSet<AEFDRuntimeSystemState> successors = new HashSet<AEFDRuntimeSystemState>();
        for (AEFDTransition transition : transitionsToFire) {
            successors.addAll(this.fireOneTransition(source, transition).getTargets());
        }
        return successors;
    }

    public boolean hasBlockingTransitions() {
        return true;
    }

    public IAtomicPropositionsEvaluator getAtomicPropositionEvaluator() {
        return this.evaluator;
    }
}

