/*
 * Decompiled with CFR 0.152.
 */
package obp.util;

import java.util.List;
import obp.result.ExplorationResultInfo;

public class ResultInfoUtil {
    public static String toDotSplitGraph(List<? extends ExplorationResultInfo> results) {
        StringBuilder dot = new StringBuilder();
        dot.append("strict digraph split {\n");
        dot.append("\trankdir=LR;\n");
        if (results.size() > 0 && results.get(0).getContext() != null) {
            for (ExplorationResultInfo explorationResultInfo : results) {
                String name = explorationResultInfo.getContext().getName();
                dot.append("\t");
                dot.append(name);
                dot.append("[");
                dot.append("label=\"");
                dot.append(name);
                dot.append("\"");
                if (explorationResultInfo.isComplete()) {
                    dot.append(",shape=box");
                }
                dot.append("];");
                dot.append("\n");
                int underscoreIndex = name.lastIndexOf(95);
                if (underscoreIndex <= 0) continue;
                dot.append("\t");
                dot.append(name.substring(0, underscoreIndex));
                dot.append(" -> ");
                dot.append(name);
                dot.append(";");
                dot.append("\n");
            }
        }
        dot.append("}\n");
        return dot.toString();
    }
}

