/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.component;

import java.awt.Canvas;
import java.awt.EventQueue;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JScrollPane;
import obp.simulation.observer.DiagramObserver;
import obp.ui.sequence.Sequence;
import obp.ui.sequence.SequenceDiagram;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.xid.basics.ui.diagram.Diagram;
import org.xid.basics.ui.field.DiagramField;

public class DiagramePanel
extends JScrollPane
implements DiagramObserver {
    private static final long serialVersionUID = 2531688312971061121L;
    private Display display;
    private Shell shell;
    private Canvas canvas;
    private SequenceDiagram sequenceDiagram;
    private DiagramField<Sequence> diagramField;

    public DiagramePanel(Sequence sequence) {
        super(21, 31);
        this.sequenceDiagram = new SequenceDiagram(sequence);
        this.diagramField = new DiagramField((Diagram)this.sequenceDiagram);
        this.diagramField.addAction(this.diagramField.getController().createIncreaseZoomAction());
        this.diagramField.addAction(this.diagramField.getController().createDecreaseZoomAction());
        this.diagramField.addAction(this.diagramField.getController().createSaveImageAction());
        this.canvas = new Canvas();
        this.setAutoscrolls(true);
        this.getViewport().add(this.canvas);
        this.setVisible(true);
    }

    public void init() {
        this.display = Display.getDefault();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DiagramePanel.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DiagramePanel.this.shell = SWT_AWT.new_Shell((Display)DiagramePanel.this.display, (Canvas)DiagramePanel.this.canvas);
                        DiagramePanel.this.shell.setLayout((Layout)new FillLayout());
                        Composite diagramComposite = new Composite((Composite)DiagramePanel.this.shell, 0x1040000);
                        diagramComposite.setLayout((Layout)new FillLayout());
                        DiagramePanel.this.diagramField.createWidget(diagramComposite);
                        DiagramePanel.this.shell.open();
                    }
                });
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DiagramePanel.this.canvas.setSize(e.getComponent().getSize());
            }
        });
    }

    public void setSequence(Sequence sequence) {
        this.sequenceDiagram.setModel(sequence);
    }

    @Override
    public void update(Sequence sequence) {
        this.sequenceDiagram.setModel(sequence);
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                DiagramePanel.this.diagramField.refreshDiagram();
            }
        });
    }
}

