/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.checker.type;

import java.util.ArrayList;
import java.util.List;
import obp.fiacre.checker.type.CAny;
import obp.fiacre.checker.type.CType;

public class CUnion
extends CType {
    private final List<String> constrList = new ArrayList<String>();
    private final List<CType> typeList = new ArrayList<CType>();

    public void addConstr(String constr, CType type) {
        this.constrList.add(constr);
        this.typeList.add(type);
    }

    public CType getConstr(String name) {
        for (int i = 0; i < this.constrList.size(); ++i) {
            if (!name.equals(this.constrList.get(i))) continue;
            return this.typeList.get(i);
        }
        throw new IllegalArgumentException("Constr '" + name + "' doesn't exist in type '" + this + "'.");
    }

    @Override
    public boolean isAssignableFrom(CType type) {
        if (type == null) {
            return false;
        }
        if (this == type) {
            return true;
        }
        if ((type = type.resolve()) == CAny.anyType) {
            return true;
        }
        if (!(type instanceof CUnion)) {
            return false;
        }
        CUnion other = (CUnion)type;
        for (int i = 0; i < this.constrList.size(); ++i) {
            String name = this.constrList.get(i);
            int otherIndexOf = other.constrList.indexOf(name);
            if (otherIndexOf < 0) {
                return false;
            }
            CType constrType = this.typeList.get(i);
            CType otherConstrType = other.typeList.get(otherIndexOf);
            if ((constrType != null || otherConstrType == null) && (constrType == null || constrType.isAssignableFrom(otherConstrType))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CUnion) {
            CUnion other = (CUnion)obj;
            if (this.constrList.equals(other.constrList)) {
                return false;
            }
            return this.typeList.equals(other.typeList);
        }
        return false;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append("union{");
        for (int i = 0; i < this.constrList.size(); ++i) {
            if (i > 0) {
                string.append(",");
            }
            string.append(this.constrList.get(i));
            CType type = this.typeList.get(i);
            if (type == null) continue;
            string.append(" of ");
            string.append(type);
        }
        string.append("}");
        return string.toString();
    }
}

