/*
 * Decompiled with CFR 0.152.
 */
package obp.aut.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import obp.aut.Aut;
import obp.aut.Edge;

public final class AutComparator {
    private final Aut[] autArray;
    private final Stack<int[]> stateArrayToCompareStack;
    private final Set<int[]> alreadyComparedStateArraySet;
    private final List<Map<Integer, Set<String>>> missingEdges;

    public AutComparator(Aut ... autArray) {
        int autIndex;
        this.autArray = new Aut[autArray.length];
        for (autIndex = 0; autIndex < autArray.length; ++autIndex) {
            this.autArray[autIndex] = autArray[autIndex];
        }
        this.stateArrayToCompareStack = new Stack();
        this.alreadyComparedStateArraySet = new HashSet<int[]>();
        this.missingEdges = new ArrayList<Map<Integer, Set<String>>>(this.autArray.length);
        for (autIndex = 0; autIndex < this.autArray.length; ++autIndex) {
            this.missingEdges.add(new HashMap());
        }
        int[] initialStateArray = new int[autArray.length];
        for (int autIndex2 = 0; autIndex2 < this.autArray.length; ++autIndex2) {
            initialStateArray[autIndex2] = this.autArray[autIndex2].getStart();
        }
        this.stateArrayToCompareStack.push(initialStateArray);
    }

    public boolean compare() {
        while (!this.stateArrayToCompareStack.isEmpty()) {
            int[] sourceArray = this.stateArrayToCompareStack.pop();
            Set<String> labelSet = this.getLabelSet(sourceArray);
            for (String label : labelSet) {
                int[] targetArray = new int[this.autArray.length];
                for (int autIndex = 0; autIndex < this.autArray.length; ++autIndex) {
                    targetArray[autIndex] = this.getTarget(autIndex, sourceArray[autIndex], label);
                }
                this.handleResult(sourceArray, label, targetArray);
            }
            this.alreadyComparedStateArraySet.add(sourceArray);
        }
        return this.areBiSimulable();
    }

    private Set<String> getLabelSet(int[] stateArray) {
        HashSet<String> result = new HashSet<String>();
        for (int autIndex = 0; autIndex < this.autArray.length; ++autIndex) {
            Collection<Edge> edgeSet = this.autArray[autIndex].allFrom(stateArray[autIndex]);
            for (Edge edge : edgeSet) {
                result.add(edge.getLabel());
            }
        }
        return result;
    }

    private int getTarget(int autIndex, int state, String label) {
        Collection<Edge> edgeSet = this.autArray[autIndex].allFrom(state);
        for (Edge edge : edgeSet) {
            if (!edge.getLabel().equals(label)) continue;
            return edge.getTarget();
        }
        return -1;
    }

    private void handleResult(int[] sourceArray, String label, int[] targetArray) {
        boolean valid = true;
        for (int autIndex = 0; autIndex < this.autArray.length; ++autIndex) {
            if (targetArray[autIndex] >= 0) continue;
            valid = false;
            this.addMissingEdge(autIndex, sourceArray[autIndex], label);
        }
        if (valid && this.didntCompare(targetArray)) {
            this.stateArrayToCompareStack.push(targetArray);
        }
    }

    private void addMissingEdge(int autIndex, int state, String edge) {
        Map<Integer, Set<String>> missingEdgeSetMap = this.missingEdges.get(autIndex);
        Set<String> missingEdgeSet = null;
        missingEdgeSet = missingEdgeSetMap.containsKey(state) ? missingEdgeSetMap.get(state) : new HashSet<String>();
        missingEdgeSet.add(edge);
        missingEdgeSetMap.put(state, missingEdgeSet);
    }

    private boolean didntCompare(int[] targetArray) {
        for (int[] stateArray : this.alreadyComparedStateArraySet) {
            boolean equal = true;
            for (int autIndex = 0; autIndex < this.autArray.length; ++autIndex) {
                if (stateArray[autIndex] == targetArray[autIndex]) continue;
                equal = false;
            }
            if (!equal) continue;
            return false;
        }
        return true;
    }

    public boolean areBiSimulable() {
        for (Map<Integer, Set<String>> map : this.missingEdges) {
            if (map.keySet().size() <= 0) continue;
            return false;
        }
        return true;
    }

    public Map<Integer, Set<String>> getMissingEdgePerStateMap(int autIndex) {
        return this.missingEdges.get(autIndex);
    }

    public String getReport() {
        StringBuffer result = new StringBuffer("Missing edges:\n");
        for (int autIndex = 0; autIndex < this.autArray.length; ++autIndex) {
            Map<Integer, Set<String>> missingEdgePerStateMap = this.missingEdges.get(autIndex);
            for (int state : missingEdgePerStateMap.keySet()) {
                for (String label : missingEdgePerStateMap.get(state)) {
                    result.append("  Aut" + autIndex + " ");
                    result.append("(" + state + ", ");
                    result.append("\"" + label + "\", ?)\n");
                }
            }
        }
        return result.toString();
    }
}

