/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.handler;

import fr.ensta.aefd.model.AEFDAction;
import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.toolbox.tools.analysis.basic.ReceivedEventsAnalysis;
import fr.ensta.aefd.toolbox.tools.analysis.basic.SentEventsAnalysis;
import java.util.LinkedList;

public class SilentRemoveEvent {
    private AEFDModel model;
    private boolean analysed = false;
    private ReceivedEventsAnalysis receivedEvents = new ReceivedEventsAnalysis();
    private SentEventsAnalysis sentEvents = new SentEventsAnalysis();
    private AEFDFunctionalEntity toBeRemoved;
    private int removedActionCount;

    public void setModel(AEFDModel model) {
        this.model = model;
        this.analysed = false;
    }

    public void remove(AEFDFunctionalEntity event) {
        if (!this.analysed) {
            this.analyseUsage();
            this.analysed = true;
        }
        this.toBeRemoved = event;
        if (this.isSafe()) {
            this.removeActions();
        }
    }

    public int getRemovedActionCount() {
        return this.removedActionCount;
    }

    private void analyseUsage() {
        this.receivedEvents.analyze(this.model);
        this.sentEvents.analyze(this.model);
    }

    private boolean isSafe() {
        return !this.receivedEvents.getReceivedEvents().contains(this.toBeRemoved);
    }

    private void removeActions() {
        this.removedActionCount = 0;
        LinkedList<AEFDAction> actionsToRemove = new LinkedList<AEFDAction>();
        for (AEFDAutomate automate : this.model.getAllAutomates()) {
            for (AEFDTransition transition : automate.getTransitionSet()) {
                for (AEFDAction action : transition.getAction().getActionList()) {
                    AEFDAction.SendEvent sendEvent;
                    if (!(action instanceof AEFDAction.SendEvent) || !(sendEvent = (AEFDAction.SendEvent)action).getFunctionalEntity().equals(this.toBeRemoved)) continue;
                    actionsToRemove.add(action);
                }
                for (AEFDAction action : actionsToRemove) {
                    transition.getAction().removeAction(action);
                    ++this.removedActionCount;
                }
                actionsToRemove.clear();
            }
        }
    }
}

