/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.runtime;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HelperIndexer<T> {
    private Set<T> elementSet = new HashSet<T>();
    private T[] elementArray;
    private final Map<T, Integer> elementIndexes = new HashMap<T, Integer>();

    public void addElement(T element) {
        if (this.elementSet == null) {
            throw new IllegalStateException("The elements from this indexer were already indexed");
        }
        this.elementSet.add(element);
    }

    public int getNumberOfElements() {
        return this.elementSet != null ? this.elementSet.size() : this.elementArray.length;
    }

    public void setAndFillElementArray(T[] targetArray) {
        if (this.elementSet == null) {
            throw new IllegalStateException("The elements from this indexer were already indexed");
        }
        if (targetArray == null || targetArray.length != this.elementSet.size()) {
            throw new IllegalArgumentException("Provided array can't be null and must have a length equals to 'getNumberOfElements()'");
        }
        this.elementArray = targetArray;
        int index = 0;
        this.elementIndexes.clear();
        for (T element : this.elementSet) {
            this.elementArray[index] = element;
            this.elementIndexes.put(element, index);
            ++index;
        }
        this.elementSet = null;
    }

    public T[] getElementArray() {
        return this.elementArray;
    }

    public Map<T, Integer> getIndexMap() {
        return this.elementIndexes;
    }
}

