/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.printer.fiacre;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.toolbox.tools.printer.fiacre.HelperBus;
import fr.ensta.aefd.toolbox.tools.printer.fiacre.ProcessEnabledArray;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.BinExp;
import obp.fiacre.model.BinOp;
import obp.fiacre.model.CaseStmt;
import obp.fiacre.model.ConstrExp;
import obp.fiacre.model.Exp;
import obp.fiacre.model.Pattern;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Rule;
import obp.fiacre.model.Seq;
import obp.fiacre.model.State;
import obp.fiacre.model.Statement;
import obp.fiacre.model.Transition;
import obp.fiacre.model.Type;
import obp.fiacre.model.VarRef;
import obp.fiacre.model.Variable;

public class SchedulerGenerator
extends HelperBus.Abstract {
    private AEFDModel model;
    private ProcessEnabledArray processEnabledArray;
    private ProcessDecl scheduler;
    private State state;
    private Transition noEventTransition;
    private Transition highPriorityTransition;
    private Transition lowPriorityTransition;
    private ArgumentVariable currentEvent;
    private ArgumentVariable highPriorityQueue;
    private ArgumentVariable lowPriorityQueue;
    private ArgumentVariable enabledArray;
    private AEFDAutomate environment;

    public SchedulerGenerator(HelperBus helper) {
        super(helper);
    }

    private void fetchEnvironment() {
        for (AEFDAutomate automate : this.model.getAllAutomates()) {
            if (!automate.getName().equals("Environment")) continue;
            this.environment = automate;
        }
    }

    private void setSignature() {
        this.currentEvent = new ArgumentVariable();
        this.currentEvent.setName("currentEvent");
        this.currentEvent.setRead(true);
        this.currentEvent.setWrite(true);
        this.currentEvent.setRef(true);
        this.currentEvent.setType((Type)this.helper.events.getUnionTypeId());
        this.scheduler.addArg(this.currentEvent);
        this.highPriorityQueue = new ArgumentVariable();
        this.highPriorityQueue.setName("hFIFO");
        this.highPriorityQueue.setWrite(true);
        this.highPriorityQueue.setRead(true);
        this.highPriorityQueue.setRef(true);
        this.highPriorityQueue.setType((Type)this.helper.events.getFifoTypeId());
        this.scheduler.addArg(this.highPriorityQueue);
        this.lowPriorityQueue = new ArgumentVariable();
        this.lowPriorityQueue.setName("lFIFO");
        this.lowPriorityQueue.setWrite(true);
        this.lowPriorityQueue.setRead(true);
        this.lowPriorityQueue.setRef(true);
        this.lowPriorityQueue.setType((Type)this.helper.events.getFifoTypeId());
        this.scheduler.addArg(this.lowPriorityQueue);
        this.enabledArray = this.processEnabledArray.buildArgument();
        this.scheduler.addArg(this.enabledArray);
    }

    private Exp getEmptyFifosExp(boolean highEmpty, boolean lowEmpty) {
        BinExp result = new BinExp();
        result.setBinOp(BinOp.BAND);
        VarRef hFifo = new VarRef();
        hFifo.setDecl((Variable)this.highPriorityQueue);
        Exp left = this.helper.builder.empty((Exp)hFifo);
        if (!highEmpty) {
            return this.helper.builder.not(left);
        }
        result.setLeft(left);
        VarRef lFifo = new VarRef();
        lFifo.setDecl((Variable)this.lowPriorityQueue);
        Exp right = this.helper.builder.empty((Exp)lFifo);
        if (!lowEmpty) {
            right = this.helper.builder.not(right);
        }
        result.setRight(right);
        return result;
    }

    private Statement getGuard(boolean highEmpty, boolean lowEmpty) {
        Exp onExp = this.getEmptyFifosExp(highEmpty, lowEmpty);
        for (AEFDAutomate automate : this.model.getAllAutomates()) {
            VarRef arrayRef = new VarRef();
            arrayRef.setDecl((Variable)this.enabledArray);
            Exp isDisabled = this.helper.builder.not(this.processEnabledArray.buildEvaluation(arrayRef, automate));
            if (onExp == null) {
                onExp = isDisabled;
                continue;
            }
            BinExp newOnExp = new BinExp();
            newOnExp.setBinOp(BinOp.BAND);
            newOnExp.setLeft(onExp);
            newOnExp.setRight(isDisabled);
            onExp = newOnExp;
        }
        return this.helper.master.on(onExp);
    }

    private Exp getFirstExp(boolean hFifo) {
        VarRef var = new VarRef();
        var.setDecl((Variable)(hFifo ? this.highPriorityQueue : this.lowPriorityQueue));
        return this.helper.builder.first((Exp)var);
    }

    private Statement getDequeueStatement(boolean hFifo) {
        VarRef varExp = new VarRef();
        varExp.setDecl((Variable)(hFifo ? this.highPriorityQueue : this.lowPriorityQueue));
        Exp dequeue = this.helper.builder.dequeue((Exp)varExp);
        VarRef varLhs = new VarRef();
        varLhs.setDecl((Variable)(hFifo ? this.highPriorityQueue : this.lowPriorityQueue));
        return this.helper.builder.assign((Pattern)varLhs, dequeue);
    }

    private Statement getCurrentEventAssign(Exp value) {
        VarRef var = new VarRef();
        var.setDecl((Variable)this.currentEvent);
        return this.helper.builder.assign((Pattern)var, value);
    }

    private Statement getEnableProcessAssign(AEFDAutomate automate) {
        VarRef arrayRef = new VarRef();
        arrayRef.setDecl((Variable)this.enabledArray);
        return this.processEnabledArray.buildAffectation(arrayRef, automate, true);
    }

    private CaseStmt getEnableStatements() {
        CaseStmt result = new CaseStmt();
        VarRef var = new VarRef();
        var.setDecl((Variable)this.currentEvent);
        result.setExp((Exp)var);
        for (AEFDFunctionalEntity functionalEntity : this.helper.events.getAllEvents()) {
            Rule rule = new Rule();
            rule.setLhs((Pattern)this.helper.events.getConstrPattern(functionalEntity));
            Seq ruleBody = new Seq();
            for (AEFDAutomate automate : this.helper.events.getTargets(functionalEntity)) {
                ruleBody.addStatement(this.getEnableProcessAssign(automate));
            }
            if (ruleBody.getStatementCount() != 0) {
                rule.setAction((Statement)ruleBody);
            } else {
                rule.setAction((Statement)this.helper.builder.nullStmt());
            }
            result.addRule(rule);
        }
        return result;
    }

    private void buildNoEventTransition() {
        this.noEventTransition = new Transition();
        this.noEventTransition.setFrom(this.state);
        Seq body = new Seq();
        body.addStatement(this.getGuard(true, true));
        ConstrExp noEventConstr = this.helper.events.getConstrExp("NO_EVENT");
        body.addStatement(this.getCurrentEventAssign((Exp)noEventConstr));
        body.addStatement(this.getEnableProcessAssign(this.environment));
        body.addStatement((Statement)this.helper.builder.toStmt(this.state));
        this.noEventTransition.setAction((Statement)body);
        this.noEventTransition.setName("no_event");
    }

    private void buildHighPriorityTransition() {
        this.highPriorityTransition = new Transition();
        this.highPriorityTransition.setFrom(this.state);
        Seq body = new Seq();
        body.addStatement(this.getGuard(false, true));
        body.addStatement(this.getCurrentEventAssign(this.getFirstExp(true)));
        body.addStatement(this.getDequeueStatement(true));
        body.addStatement((Statement)this.getEnableStatements());
        body.addStatement((Statement)this.helper.builder.toStmt(this.state));
        this.highPriorityTransition.setAction((Statement)body);
        this.highPriorityTransition.setName("high_priority");
    }

    private void buildLowPriorityTransition() {
        this.lowPriorityTransition = new Transition();
        this.lowPriorityTransition.setFrom(this.state);
        Seq body = new Seq();
        body.addStatement(this.getGuard(true, false));
        body.addStatement(this.getCurrentEventAssign(this.getFirstExp(false)));
        body.addStatement(this.getDequeueStatement(false));
        body.addStatement((Statement)this.getEnableStatements());
        body.addStatement((Statement)this.helper.builder.toStmt(this.state));
        this.lowPriorityTransition.setAction((Statement)body);
        this.lowPriorityTransition.setName("low_priority");
    }

    public void generate(AEFDModel model) {
        this.model = model;
        this.processEnabledArray = this.helper.processEnabledArray;
        this.fetchEnvironment();
        this.scheduler = new ProcessDecl();
        this.scheduler.setName("Scheduler");
        this.setSignature();
        this.state = new State();
        this.state.setName("Idle");
        this.scheduler.addState(this.state);
        this.scheduler.setInitAction((Statement)this.helper.builder.toStmt(this.state));
        this.buildNoEventTransition();
        this.scheduler.addTransition(this.noEventTransition);
        this.buildHighPriorityTransition();
        this.scheduler.addTransition(this.highPriorityTransition);
        this.buildLowPriorityTransition();
        this.scheduler.addTransition(this.lowPriorityTransition);
    }

    public ProcessDecl getProcessDecl() {
        return this.scheduler;
    }
}

