/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.analysis.basic;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.AEFDModelVisitor;
import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.toolbox.tools.analysis.util.FetchTransitionReceivedEvents;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ReceivedEventsAnalysis
extends AEFDModelVisitor.Stub {
    public final Set<AEFDFunctionalEntity> receivedEvents = new HashSet<AEFDFunctionalEntity>();
    private final Map<AEFDFunctionalEntity, Set<AEFDAutomate>> targetMap = new HashMap<AEFDFunctionalEntity, Set<AEFDAutomate>>();
    private final Map<AEFDAutomate, Set<AEFDFunctionalEntity>> inputMap = new HashMap<AEFDAutomate, Set<AEFDFunctionalEntity>>();
    private final Map<AEFDAutomate, Map<String, Set<AEFDFunctionalEntity>>> stateInputMap = new HashMap<AEFDAutomate, Map<String, Set<AEFDFunctionalEntity>>>();
    private final Map<AEFDAutomate, Map<String, Set<AEFDAutomate>>> priorityMap = new HashMap<AEFDAutomate, Map<String, Set<AEFDAutomate>>>();
    private final Map<AEFDAutomate, Map<AEFDFunctionalEntity, Set<AEFDTransition>>> transitionMap = new HashMap<AEFDAutomate, Map<AEFDFunctionalEntity, Set<AEFDTransition>>>();
    private final FetchTransitionReceivedEvents eventFetcher = new FetchTransitionReceivedEvents();
    private AEFDAutomate currentAutomate;

    private void initialize(AEFDModel model) {
        this.receivedEvents.clear();
        this.targetMap.clear();
        this.inputMap.clear();
        this.stateInputMap.clear();
        this.transitionMap.clear();
        for (AEFDAutomate automate : model.getAllAutomates()) {
            this.inputMap.put(automate, new HashSet());
            this.stateInputMap.put(automate, new HashMap());
            this.transitionMap.put(automate, new HashMap());
            for (String place : automate.getPlaceSet()) {
                this.stateInputMap.get(automate).put(place.intern(), new HashSet());
            }
            for (AEFDFunctionalEntity functionalEntity : model.getAllFunctionalEntity()) {
                this.transitionMap.get(automate).put(functionalEntity, new HashSet());
            }
        }
        for (AEFDFunctionalEntity functionalEntity : model.getAllFunctionalEntity()) {
            this.targetMap.put(functionalEntity, new HashSet());
        }
    }

    public void analyze(AEFDModel model) {
        this.initialize(model);
        model.accept(this);
    }

    public Set<AEFDFunctionalEntity> getReceivedEvents() {
        return this.receivedEvents;
    }

    public Map<AEFDFunctionalEntity, Set<AEFDAutomate>> getTargetMap() {
        return this.targetMap;
    }

    public Map<AEFDAutomate, Set<AEFDFunctionalEntity>> getInputMap() {
        return this.inputMap;
    }

    public Set<AEFDAutomate> getTargets(AEFDFunctionalEntity event) {
        return this.targetMap.get(event);
    }

    public Set<AEFDFunctionalEntity> getInputs(AEFDAutomate automate) {
        return this.inputMap.get(automate);
    }

    public Set<AEFDFunctionalEntity> getInputs(AEFDAutomate automate, String place) {
        return this.stateInputMap.get(automate).get(place.intern());
    }

    public Set<AEFDTransition> getSensibleTransitions(AEFDAutomate automate, AEFDFunctionalEntity functionalEntity) {
        return this.transitionMap.get(automate).get(functionalEntity);
    }

    @Override
    public void visitModel(AEFDModel model) {
        for (AEFDAutomate automate : model.getAllAutomates()) {
            automate.accept(this);
        }
    }

    @Override
    public void visitAutomate(AEFDAutomate automate) {
        this.currentAutomate = automate;
        for (AEFDTransition transition : automate.getTransitionSet()) {
            transition.accept(this);
        }
    }

    @Override
    public void visitTransition(AEFDTransition transition) {
        for (AEFDFunctionalEntity event : this.eventFetcher.getReceivedEvents(transition)) {
            this.receivedEvents.add(event);
            this.targetMap.get(event).add(this.currentAutomate);
            this.inputMap.get(this.currentAutomate).add(event);
            this.stateInputMap.get(this.currentAutomate).get(transition.getPlaceSource().intern()).add(event);
            this.transitionMap.get(this.currentAutomate).get(event).add(transition);
        }
    }
}

