/*
 * Decompiled with CFR 0.152.
 */
package obp.if2.behaviour.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.if2.If2Visitor;
import obp.if2.behaviour.statements.ActionStatement;
import obp.if2.data.Resource;

public class ReleaseAction
extends ActionStatement {
    private final List<Resource> resourcesList = new ArrayList<Resource>();

    public List<Resource> getResourcesList() {
        return Collections.unmodifiableList(this.resourcesList);
    }

    public int getResourcesCount() {
        return this.resourcesList.size();
    }

    public Resource getResources(int index) {
        if (index < 0 || index >= this.getResourcesCount()) {
            return null;
        }
        return this.resourcesList.get(index);
    }

    public void addResources(Resource newValue) {
        this.addResources(this.getResourcesCount(), newValue);
    }

    public void addResources(int index, Resource newValue) {
        this.resourcesList.add(index, newValue);
    }

    public Resource setResources(int index, Resource newValue) {
        return this.resourcesList.set(index, newValue);
    }

    public void addAllResources(Collection<Resource> toAddList) {
        for (Resource newValue : toAddList) {
            this.addResources(this.getResourcesCount(), newValue);
        }
    }

    public void removeResources(Resource value) {
        int index = this.resourcesList.indexOf(value);
        if (index >= 0) {
            this.removeResources(index);
        }
    }

    public void removeResources(int index) {
        this.resourcesList.remove(index);
    }

    @Override
    public void accept(If2Visitor visitor) {
        visitor.visitReleaseAction(this);
    }
}

