/*
 * Decompiled with CFR 0.152.
 */
package plug.visualisation;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import plug.core.IFiredTransition;
import plug.statespace.IGraphAccess;

public class StateSpace2DOT<N, T> {
    public static final StateSpace2DOT instance = new StateSpace2DOT();

    public static void toDOT(IGraphAccess graphView, boolean vertexDetails, String filename) {
        try {
            instance.toDOT(graphView, vertexDetails, false, filename);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toDOT(IGraphAccess<N, T> graphView, boolean vertexDetails, boolean edgeDetails, String filename) throws IOException {
        BufferedWriter br = new BufferedWriter(new FileWriter(filename));
        this.toDOT(graphView, vertexDetails, edgeDetails, br);
        Runtime runtime = Runtime.getRuntime();
        String[] cmds = new String[]{"dot", "-Tps", filename, "-o", filename.substring(0, filename.indexOf(".")) + ".eps"};
        runtime.exec(cmds);
    }

    public void toDOT(IGraphAccess<N, T> graphView, boolean vertexDetails, boolean edgeDetails, Writer writer) throws IOException {
        HashMap idMap = new HashMap();
        writer.write("digraph G {\n");
        writer.write("0 [shape=box, label=\"i\", style=filled, color=dodgerblue];\n");
        for (Object vertex : graphView.getVertices()) {
            int id = this.getID(vertex, idMap);
            if (vertexDetails) {
                writer.write(id + " [shape=box, style=filled, color=dodgerblue, label=\"" + vertex.toString() + "\"];\n");
                continue;
            }
            writer.write(id + " [shape=box, style=filled, color=dodgerblue];\n");
        }
        for (Object vertex : graphView.getInitialVertices()) {
            writer.write("0 -> " + this.getID(vertex, idMap) + "\n");
        }
        for (Object source : graphView.getVertices()) {
            int sourceID = this.getID(source, idMap);
            for (IFiredTransition transition : graphView.getOutgoingEdges(source)) {
                for (Object target : transition.getTargets()) {
                    writer.write(sourceID + " -> " + this.getID(target, idMap) + "\n");
                }
            }
        }
        writer.write("}\n");
        writer.close();
    }

    int getID(N vertex, Map<N, Integer> idMap) {
        Integer id = idMap.get(vertex);
        if (id == null) {
            id = idMap.size() + 1;
            idMap.put(vertex, id);
        }
        return id;
    }
}

