/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.geometry;

public class Geometry {
    public static final float sqrt2over2 = (float)Math.sqrt(2.0) / 2.0f;
    public static final int EAST = 0;
    public static final int SOUTH_EAST = 1;
    public static final int SOUTH = 2;
    public static final int SOUTH_WEST = 3;
    public static final int WEST = 4;
    public static final int NORTH_WEST = 5;
    public static final int NORTH = 6;
    public static final int NORTH_EAST = 7;
    public static final int CENTER = -1;

    public static float[] unitVector(int direction) {
        return new float[]{Geometry.xDelta(direction), Geometry.yDelta(direction)};
    }

    public static float xDelta(int direction) {
        switch (direction) {
            case 0: {
                return 1.0f;
            }
            case 1: 
            case 7: {
                return sqrt2over2;
            }
            case 4: {
                return -1.0f;
            }
            case 3: 
            case 5: {
                return -sqrt2over2;
            }
        }
        return 0.0f;
    }

    public static float yDelta(int direction) {
        switch (direction) {
            case 2: {
                return 1.0f;
            }
            case 1: 
            case 3: {
                return sqrt2over2;
            }
            case 6: {
                return -1.0f;
            }
            case 5: 
            case 7: {
                return -sqrt2over2;
            }
        }
        return 0.0f;
    }

    public static int normalDirection(int direction) {
        return (direction + 2) % 8;
    }

    public static int oppositeDirection(int direction) {
        return (direction + 4) % 8;
    }

    public static boolean isParallelTo(int direction1, int direction2) {
        return Math.abs(direction1 - direction2) % 4 == 0;
    }

    public static boolean isPerpendicularTo(int direction1, int direction2) {
        return Math.abs(direction1 - direction2) % 4 == 2;
    }

    public static float distanceSquared(float[] point1, float[] point2) {
        float dx = point1[0] - point2[0];
        float dy = point1[1] - point2[1];
        return dx * dx + dy * dy;
    }

    public static float dotProduct(float[] vector1, float[] vector2) {
        return vector1[0] * vector2[0] + vector1[1] * vector2[1];
    }

    public static int positionOfPointRelativeToPoint(float pointX, float pointY, float refPointX, float refPointY) {
        float x = pointX - refPointX;
        float y = pointY - refPointY;
        if (x >= y) {
            if (x >= -y) {
                return 0;
            }
            return 6;
        }
        if (x >= -y) {
            return 2;
        }
        return 4;
    }

    public static float[] projectPointOnSegment(float xp, float yp, float x1, float y1, float x2, float y2) {
        float x12 = x2 - x1;
        float y12 = y2 - y1;
        float dist12Squared = x12 * x12 + y12 * y12;
        if (dist12Squared <= 0.0f) {
            return new float[]{x1, y1};
        }
        float x1p = xp - x1;
        float y1p = yp - y1;
        float r = (x1p * x12 + y1p * y12) / dist12Squared;
        if (r <= 0.0f) {
            return new float[]{x1, y1};
        }
        if (r >= 1.0f) {
            return new float[]{x2, y2};
        }
        return new float[]{x1 + x12 * r, y1 + y12 * r};
    }

    public static float[] rectangleFromPoints(float[] p1, float[] p2) {
        return new float[]{Math.min(p1[0], p2[0]), Math.min(p1[1], p2[1]), Math.max(p1[0], p2[0]), Math.max(p1[1], p2[1])};
    }

    public static float[] rectangleFromPoints(float x1, float y1, float x2, float y2) {
        return new float[]{Math.min(x1, x2), Math.min(y1, y2), Math.max(x1, x2), Math.max(y1, y2)};
    }

    public static boolean rectangleIntersectsRectangle(float[] r1, float[] r2) {
        return r1[0] <= r2[2] && r2[0] <= r1[2] && r1[1] <= r2[3] && r2[1] <= r1[3];
    }

    public static float[] getRectangleIntersection(float[] r1, float[] r2) {
        float[] result = new float[]{Math.max(r1[0], r2[0]), Math.max(r1[1], r2[1]), Math.min(r1[2], r2[2]), Math.min(r1[3], r2[3])};
        return result;
    }

    public static boolean rectangleContainsPoint(float[] rectangle, float x, float y) {
        return rectangle[0] <= x && x <= rectangle[2] && rectangle[1] <= y && y <= rectangle[3];
    }

    public static boolean rectangleContainsPoint(float[] rectangle, float[] point) {
        return Geometry.rectangleContainsPoint(rectangle, point[0], point[1]);
    }

    public static boolean rectangleContainsRectangle(float[] rectangle, float[] rectangle2) {
        return Geometry.rectangleContainsPoint(rectangle, rectangle2[0], rectangle2[1]) && Geometry.rectangleContainsPoint(rectangle, rectangle2[2], rectangle2[3]);
    }

    public static void rectangleMergeWithPoint(float[] rectangle, float[] point) {
        Geometry.rectangleMergeWithPoint(rectangle, point[0], point[1]);
    }

    public static void rectangleMergeWithPoint(float[] rectangle, float x, float y) {
        if (x < rectangle[0]) {
            rectangle[0] = x;
        }
        if (x > rectangle[2]) {
            rectangle[2] = x;
        }
        if (y < rectangle[1]) {
            rectangle[1] = y;
        }
        if (y > rectangle[3]) {
            rectangle[3] = y;
        }
    }

    public static void rectangleMergeWithRectangle(float[] rectangle, float[] rect) {
        if (rect[0] < rectangle[0]) {
            rectangle[0] = rect[0];
        }
        if (rect[2] > rectangle[2]) {
            rectangle[2] = rect[2];
        }
        if (rect[1] < rectangle[1]) {
            rectangle[1] = rect[1];
        }
        if (rect[3] > rectangle[3]) {
            rectangle[3] = rect[3];
        }
    }

    public static int positionOfPointRelativeToRectangle(float pointX, float pointY, float x1, float y1, float x2, float y2) {
        int q2;
        float w = x2 - x1;
        float h = y2 - y1;
        float d = Math.min(w, h) / 2.0f;
        int q1 = Geometry.positionOfPointRelativeToPoint(pointX, pointY, x1 + d, y1 + d);
        if (q1 == (q2 = Geometry.positionOfPointRelativeToPoint(pointX, pointY, x2 - d, y2 - d))) {
            return q1;
        }
        if (w > h) {
            if (pointY > y1 + d) {
                return 2;
            }
            return 6;
        }
        if (pointX > x1 + d) {
            return 0;
        }
        return 4;
    }

    public static int positionOfPointRelativeToRectangle(float[] point, float[] refRectangle) {
        return Geometry.positionOfPointRelativeToRectangle(point[0], point[1], refRectangle[0], refRectangle[1], refRectangle[2], refRectangle[3]);
    }

    public static float getRectanglePointX(float x1, float y1, float x2, float y2, int direction) {
        if (direction == 4 || direction == 5 || direction == 3) {
            return x1;
        }
        if (direction == 0 || direction == 7 || direction == 1) {
            return x2;
        }
        return (x1 + x2) / 2.0f;
    }

    public static float getRectanglePointY(float x1, float y1, float x2, float y2, int direction) {
        if (direction == 6 || direction == 7 || direction == 5) {
            return y1;
        }
        if (direction == 2 || direction == 1 || direction == 3) {
            return y2;
        }
        return (y1 + y2) / 2.0f;
    }

    public static float[] getRectanglePoint(float[] rectangle, int direction) {
        return new float[]{Geometry.getRectanglePointX(rectangle[0], rectangle[1], rectangle[2], rectangle[3], direction), Geometry.getRectanglePointY(rectangle[0], rectangle[1], rectangle[2], rectangle[3], direction)};
    }

    public static float[] rectangleAlignedOn(float width, float height, float x, float y, int direction) {
        float rx = x - Geometry.getRectanglePointX(0.0f, 0.0f, width, height, direction);
        float ry = y - Geometry.getRectanglePointY(0.0f, 0.0f, width, height, direction);
        return new float[]{rx, ry, rx + width, ry + height};
    }

    public static void moveRectanglePointTo(float[] rectangle, float x, float y, int location) {
        if (location == 4 || location == 5 || location == 3) {
            rectangle[0] = x;
        }
        if (location == 0 || location == 7 || location == 1) {
            rectangle[2] = x;
        }
        if (location == 6 || location == 7 || location == 5) {
            rectangle[1] = y;
        }
        if (location == 2 || location == 1 || location == 3) {
            rectangle[3] = y;
        }
    }

    public static void moveRectanglePointTo(float[] rectangle, float x, float y, int location, float minWidth, float minHeight) {
        if (location == 4 || location == 5 || location == 3) {
            rectangle[0] = Math.min(x, rectangle[2] - minWidth);
        }
        if (location == 0 || location == 7 || location == 1) {
            rectangle[2] = Math.max(x, rectangle[0] + minWidth);
        }
        if (location == 6 || location == 7 || location == 5) {
            rectangle[1] = Math.min(y, rectangle[3] - minHeight);
        }
        if (location == 2 || location == 1 || location == 3) {
            rectangle[3] = Math.max(y, rectangle[1] + minHeight);
        }
    }

    public static void moveRectanglePointBy(float[] rectangle, float dx, float dy, int location, float minWidth, float minHeight) {
        if (location == 4 || location == 5 || location == 3) {
            rectangle[0] = Math.min(rectangle[0] + dx, rectangle[2] - minWidth);
        }
        if (location == 0 || location == 7 || location == 1) {
            rectangle[2] = Math.max(rectangle[2] + dx, rectangle[0] + minWidth);
        }
        if (location == 6 || location == 7 || location == 5) {
            rectangle[1] = Math.min(rectangle[1] + dy, rectangle[3] - minHeight);
        }
        if (location == 2 || location == 1 || location == 3) {
            rectangle[3] = Math.max(rectangle[3] + dy, rectangle[1] + minHeight);
        }
    }

    public static void expandRectangle(float[] rectangle, float dx, float dy) {
        rectangle[0] = rectangle[0] - dx;
        rectangle[1] = rectangle[1] - dy;
        rectangle[2] = rectangle[2] + dx;
        rectangle[3] = rectangle[3] + dy;
    }

    public static void projectPointOnRectangle(float[] point, float[] rectangle) {
        int direction = Geometry.positionOfPointRelativeToRectangle(point, rectangle);
        switch (direction) {
            case 0: {
                point[0] = rectangle[2];
                point[1] = Math.max(rectangle[1], Math.min(point[1], rectangle[3]));
                break;
            }
            case 2: {
                point[0] = Math.max(rectangle[0], Math.min(point[0], rectangle[2]));
                point[1] = rectangle[3];
                break;
            }
            case 4: {
                point[0] = rectangle[0];
                point[1] = Math.max(rectangle[1], Math.min(point[1], rectangle[3]));
                break;
            }
            case 6: {
                point[0] = Math.max(rectangle[0], Math.min(point[0], rectangle[2]));
                point[1] = rectangle[1];
            }
        }
    }

    public static void projectPointOnRectangleAlt(float[] point, float[] rectangle) {
        float y;
        float x;
        float rady;
        float cx = (rectangle[0] + rectangle[2]) / 2.0f;
        float cy = (rectangle[1] + rectangle[3]) / 2.0f;
        float radx = (rectangle[2] - rectangle[0]) / 2.0f;
        if (radx == 0.0f) {
            radx = 1.0f;
        }
        if ((rady = (rectangle[3] - rectangle[1]) / 2.0f) == 0.0f) {
            rady = 1.0f;
        }
        if ((x = (point[0] - cx) / radx) + (y = (point[1] - cy) / rady) >= 0.0f) {
            if (x - y > 0.0f) {
                point[1] = (x != 0.0f ? y / x : 0.0f) * rady + cy;
                point[0] = rectangle[2];
            } else {
                point[0] = (y != 0.0f ? x / y : 0.0f) * radx + cx;
                point[1] = rectangle[3];
            }
        } else if (x - y > 0.0f) {
            point[0] = -(y != 0.0f ? x / y : 0.0f) * radx + cx;
            point[1] = rectangle[1];
        } else {
            point[1] = -(x != 0.0f ? y / x : 0.0f) * rady + cy;
            point[0] = rectangle[0];
        }
    }

    public static void projectPointOnEllipse(float[] point, float[] rectangle) {
        float cx = (rectangle[0] + rectangle[2]) / 2.0f;
        float cy = (rectangle[1] + rectangle[3]) / 2.0f;
        float radx = (rectangle[2] - rectangle[0]) / 2.0f;
        float rady = (rectangle[3] - rectangle[1]) / 2.0f;
        float x = (point[0] - cx) / radx;
        float y = (point[1] - cy) / rady;
        float d = (float)Math.sqrt(x * x + y * y);
        point[0] = (x /= d) * radx + cx;
        point[1] = (y /= d) * rady + cy;
    }

    public static float[] amountToTranslateWithin(float[] rectangle, float[] container) {
        float[] delta = new float[2];
        if (rectangle[2] > container[2]) {
            delta[0] = container[2] - rectangle[2];
        }
        if (rectangle[3] > container[3]) {
            delta[1] = container[3] - rectangle[3];
        }
        if (rectangle[0] + delta[0] < container[0]) {
            delta[0] = container[0] - rectangle[0];
        }
        if (rectangle[1] + delta[1] < container[1]) {
            delta[1] = container[1] - rectangle[1];
        }
        return delta;
    }

    public static void setNullRectangle(float[] r) {
        r[0] = Float.POSITIVE_INFINITY;
        r[1] = Float.POSITIVE_INFINITY;
        r[2] = Float.NEGATIVE_INFINITY;
        r[3] = Float.NEGATIVE_INFINITY;
    }

    public static void setLargestRectangle(float[] r) {
        r[0] = Float.NEGATIVE_INFINITY;
        r[1] = Float.NEGATIVE_INFINITY;
        r[2] = Float.POSITIVE_INFINITY;
        r[3] = Float.POSITIVE_INFINITY;
    }

    public static int numPoints(float[] points) {
        return points.length / 2;
    }

    public static float[] copyPoints(float[] points) {
        float[] newArray = new float[points.length];
        System.arraycopy(points, 0, newArray, 0, points.length);
        return newArray;
    }

    public static void copyPoints(float[] sourcePoints, float[] destinationPoints) {
        for (int i = 0; i < sourcePoints.length; ++i) {
            destinationPoints[i] = sourcePoints[i];
        }
    }

    public static void copyPoints(float[] sourcePoints, int startIndex, int length, float[] destinationPoints, int destinationIndex) {
        int i = startIndex * 2;
        int j = 0;
        while (i < (length + startIndex) * 2) {
            destinationPoints[j + destinationIndex * 2] = sourcePoints[i];
            ++i;
            ++j;
        }
    }

    public static float[] getPoint(float[] points, int index) {
        int i = index * 2;
        return new float[]{points[i], points[i + 1]};
    }

    public static void movePointTo(float[] points, float[] point, int index) {
        int i = index * 2;
        points[i] = point[0];
        points[i + 1] = point[1];
    }

    public static void computeBoundingRectangle(float[] points, float[] resultRectangle) {
        Geometry.setNullRectangle(resultRectangle);
        int i = 0;
        for (int j = 1; j < points.length; j += 2) {
            Geometry.rectangleMergeWithPoint(resultRectangle, points[i], points[j]);
            i += 2;
        }
    }

    public static void translatePointsBy(float[] points, float dx, float dy) {
        int i = 0;
        for (int j = 1; j < points.length; j += 2) {
            int n = i;
            points[n] = points[n] + dx;
            int n2 = j;
            points[n2] = points[n2] + dy;
            i += 2;
        }
    }

    public static void translatePointsBy(float[] points, float dx, float dy, float[] impactedRectangle) {
        int i = 0;
        for (int j = 1; j < points.length; j += 2) {
            Geometry.rectangleMergeWithPoint(impactedRectangle, points[i], points[j]);
            int n = i;
            points[n] = points[n] + dx;
            int n2 = j;
            points[n2] = points[n2] + dy;
            Geometry.rectangleMergeWithPoint(impactedRectangle, points[i], points[j]);
            i += 2;
        }
    }

    public static void translatePointsTo(float[] points, float x, float y) {
        Geometry.translatePointsBy(points, x - points[0], y - points[1]);
    }

    public static void gridPoints(float[] points, float gridX, float gridY) {
        int i = 0;
        for (int j = 1; j < points.length; j += 2) {
            points[i] = (float)Math.round(points[i] / gridX) * gridX;
            points[j] = (float)Math.round(points[j] / gridY) * gridY;
            i += 2;
        }
    }
}

