/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.error;

public interface Diagnostic {
    public static final int INFO = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;

    public String getMessage();

    public int getLevel();

    public static class Stub
    implements Diagnostic {
        private final int level;
        private final String message;

        public Stub(int level, String message) {
            this.level = level;
            this.message = message;
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            switch (this.getLevel()) {
                case 0: {
                    builder.append("INFO");
                    break;
                }
                case 1: {
                    builder.append("WARNING");
                    break;
                }
                case 2: {
                    builder.append("ERROR");
                }
            }
            builder.append(": ");
            builder.append(this.getMessage());
            return builder.toString();
        }
    }
}

