/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.analysis;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.toolbox.tools.analysis.GraphAsMapAnalysis;
import fr.ensta.aefd.toolbox.tools.analysis.basic.ReceivedEventsAnalysis;
import fr.ensta.aefd.toolbox.tools.analysis.basic.SentEventsAnalysis;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EventDependenciesAnalysis {
    private AEFDModel model;
    private final ReceivedEventsAnalysis receivedEvents = new ReceivedEventsAnalysis();
    private final SentEventsAnalysis sentEvents = new SentEventsAnalysis();
    private final Map<AEFDAutomate, Set<AEFDAutomate>> fanout = new HashMap<AEFDAutomate, Set<AEFDAutomate>>();
    private final GraphAsMapAnalysis<AEFDAutomate> graphAnalysis = new GraphAsMapAnalysis();

    public void analyze(AEFDModel model) {
        this.model = model;
        this.fanout.clear();
        this.receivedEvents.analyze(model);
        this.sentEvents.analyze(model);
        this.computeFanout();
        this.graphAnalysis.setFanout(this.fanout);
    }

    private void computeFanout() {
        for (AEFDAutomate automate : this.model.getAllAutomates()) {
            HashSet<AEFDAutomate> targets = new HashSet<AEFDAutomate>();
            if (!automate.getName().equals("Environment")) {
                Set<AEFDFunctionalEntity> outputs = this.sentEvents.getOutputs(automate);
                for (AEFDAutomate potentialTarget : this.model.getAllAutomates()) {
                    for (AEFDFunctionalEntity output : outputs) {
                        if (!this.receivedEvents.getInputs(potentialTarget).contains(output)) continue;
                        targets.add(potentialTarget);
                    }
                }
            }
            this.fanout.put(automate, targets);
        }
    }

    public String getTGF() {
        return this.graphAnalysis.exportAsTGFString(a -> a.getName());
    }
}

