/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.model.statements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.model.kernel.Expression;
import org.cte.ABCD.model.kernel.Statement;
import org.cte.ABCD.model.statements.CaseItem;
import org.cte.ABCD.model.statements.ElementWithCaseItems;

public class CaseStmt
implements Statement,
ElementWithCaseItems {
    private Expression expression;
    private final List<CaseItem> itemsList = new ArrayList<CaseItem>();

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression newValue) {
        if (this.expression == null ? newValue != null : !this.expression.equals(newValue)) {
            this.expression = newValue;
        }
    }

    @Override
    public List<CaseItem> getItemsList() {
        return Collections.unmodifiableList(this.itemsList);
    }

    @Override
    public int getItemsCount() {
        return this.itemsList.size();
    }

    @Override
    public CaseItem getItems(int index) {
        if (index < 0 || index >= this.getItemsCount()) {
            return null;
        }
        return this.itemsList.get(index);
    }

    @Override
    public void addItems(CaseItem newValue) {
        this.addItems(this.getItemsCount(), newValue);
    }

    @Override
    public void addItems(int index, CaseItem newValue) {
        this.itemsList.add(index, newValue);
    }

    @Override
    public CaseItem setItems(int index, CaseItem newValue) {
        return this.itemsList.set(index, newValue);
    }

    @Override
    public void addAllItems(Collection<CaseItem> toAddList) {
        for (CaseItem newValue : toAddList) {
            this.addItems(this.getItemsCount(), newValue);
        }
    }

    @Override
    public void removeItems(CaseItem value) {
        int index = this.itemsList.indexOf(value);
        if (index >= 0) {
            this.removeItems(index);
        }
    }

    @Override
    public void removeItems(int index) {
        this.itemsList.remove(index);
    }

    @Override
    public void accept(ABCDVisitor visitor) {
        visitor.visitCaseStmt(this);
    }

    public boolean equals(Object that) {
        return this.equalsCached(that, new IdentityHashMap<Object, Object>());
    }

    @Override
    public boolean equalsCached(Object that, IdentityHashMap<Object, Object> cache) {
        if (this == that) {
            cache.put(that, this);
            return true;
        }
        if (!(that instanceof CaseStmt)) {
            return false;
        }
        Object o1 = cache.get(this);
        if (o1 != null) {
            return o1 == that;
        }
        Object o2 = cache.get(that);
        if (o2 != null) {
            return o2 == this;
        }
        return this.equalsFeatures((CaseStmt)that, cache);
    }

    protected boolean equalsFeatures(CaseStmt that, IdentityHashMap<Object, Object> cache) {
        int l1size = 0;
        int l2size = 0;
        if (!this.expression.equalsCached(that.expression, cache)) {
            return false;
        }
        l1size = this.itemsList.size();
        if (l1size != (l2size = that.itemsList.size())) {
            return false;
        }
        for (int i = 0; i < l1size; ++i) {
            if (this.itemsList.get(i).equalsCached(that.itemsList.get(i), cache)) continue;
            return false;
        }
        return true;
    }
}

