/*
 * Decompiled with CFR 0.152.
 */
package obp.transfo.ltl;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import obp.LTL.model.Atom;
import obp.LTL.model.FormulaDeclaration;
import obp.buchi.BuchiAutomaton;
import obp.buchi.State;
import obp.buchi.Transition;
import obp.cdl.PredicateDeclaration;
import obp.predicate.LogicOperator;
import obp.predicate.LogicPredicate;
import obp.predicate.Predicate;
import obp.predicate.PredicateReference;
import obp.transfo.ltl.LTL2AbstractText;
import properties.LTL.ltl3ba.LTL3BA;

public class LTL2Buchi {
    private final PrintWriter out;

    public LTL2Buchi(PrintWriter out) {
        this.out = out == null ? new PrintWriter(System.out) : out;
    }

    public BuchiAutomaton toBuchi(FormulaDeclaration formula) {
        LTL2AbstractText ltl2text = new LTL2AbstractText();
        String ltlString = ltl2text.toString(formula);
        this.out.println("\n\nTransforming LTL formula : " + ltlString);
        this.out.flush();
        List transitions = LTL3BA.transform((String)ltlString);
        return this.readBuchiFromSpot(transitions, formula);
    }

    BuchiAutomaton readBuchiFromSpot(List<String[]> transitions, FormulaDeclaration formula) {
        HashMap name2state = new HashMap();
        BuchiAutomaton automaton = new BuchiAutomaton();
        for (String[] transition : transitions) {
            State target;
            State source = (State)name2state.get(transition[0]);
            if (source == null) {
                source = this.createState(transition[0]);
                automaton.addState(source);
                if (transition[0].endsWith("init")) {
                    automaton.setStartState(source);
                }
            }
            if ((target = (State)name2state.get(transition[1])) == null) {
                target = this.createState(transition[1]);
                automaton.addState(target);
            }
            Predicate guard = this.parsePredicateFromSpot(transition[2], formula.getAtomsList());
            Transition buchiTransition = new Transition();
            buchiTransition.setSourceAndOpposite(source);
            buchiTransition.setTargetAndOpposite(target);
            if (guard != null) {
                buchiTransition.setGuard(guard);
            }
            automaton.addTransition(buchiTransition);
        }
        return automaton;
    }

    State createState(String name) {
        State state = new State();
        state.setName(name);
        if (name.startsWith("accept")) {
            state.setAccepting(true);
        } else {
            state.setAccepting(false);
        }
        return state;
    }

    Predicate parsePredicateFromSpot(final String guardString, final List<Atom> atoms) {
        class Parser {
            int position = 0;

            Parser() {
            }

            void next() {
                ++this.position;
                while (this.position < guardString.length() && Character.isWhitespace(this.getChar())) {
                    ++this.position;
                }
            }

            Predicate parse() {
                if (guardString.equals("true")) {
                    return null;
                }
                return this.parseExpression();
            }

            Predicate parseExpression() {
                Predicate lhs = this.parseUnary();
                while (this.position < guardString.length()) {
                    LogicPredicate predicate;
                    Predicate rhs;
                    if (this.getChar() == '&') {
                        this.next();
                        if (this.getChar() != '&') {
                            throw new RuntimeException("expected '&&' but found '&" + this.getChar() + "'");
                        }
                        this.next();
                        rhs = this.parseUnary();
                        predicate = new LogicPredicate();
                        predicate.setOperator(LogicOperator.AND);
                        predicate.setLeft(lhs);
                        predicate.setRight(rhs);
                        lhs = predicate;
                        continue;
                    }
                    if (this.getChar() == '|') {
                        this.next();
                        if (this.getChar() != '|') {
                            throw new RuntimeException("expected '||' but found '|" + this.getChar() + "'");
                        }
                        this.next();
                        rhs = this.parseUnary();
                        predicate = new LogicPredicate();
                        predicate.setOperator(LogicOperator.OR);
                        predicate.setLeft(lhs);
                        predicate.setRight(rhs);
                        lhs = predicate;
                        continue;
                    }
                    return lhs;
                }
                return lhs;
            }

            Predicate parseUnary() {
                Predicate result;
                boolean negation = false;
                if (this.getChar() == '!') {
                    this.next();
                    negation = true;
                }
                if (this.getChar() == '(') {
                    this.next();
                    result = this.parseExpression();
                    if (this.getChar() == ')') {
                        this.next();
                    }
                } else {
                    StringBuilder identSB = new StringBuilder();
                    while (this.getChar() >= 'a' && this.getChar() <= 'z' || this.getChar() >= '0' && this.getChar() <= '9' || this.getChar() == '_') {
                        identSB.append(this.getChar());
                        this.next();
                    }
                    if (identSB.length() == 0) {
                        throw new RuntimeException("unexpected character " + this.getChar() + " in buchi guard expression");
                    }
                    PredicateReference predicate = new PredicateReference();
                    predicate.setName(identSB.toString());
                    predicate.setReference(this.lookup(identSB.toString()));
                    result = predicate;
                }
                if (negation) {
                    LogicPredicate predicate = new LogicPredicate();
                    predicate.setOperator(LogicOperator.NOT);
                    predicate.setLeft(result);
                    return predicate;
                }
                return result;
            }

            private char getChar() {
                return guardString.charAt(this.position);
            }

            PredicateDeclaration lookup(String name) {
                for (Atom p : atoms) {
                    if (!p.getName().equals(name)) continue;
                    return p;
                }
                new RuntimeException("Atom named '" + name + "' is not declared");
                return null;
            }
        }
        return new Parser().parse();
    }
}

