/*
 * Decompiled with CFR 0.152.
 */
package obp.cdl.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import obp.cc.ConcreteContext;
import obp.cdl.CDLDeclaration;
import obp.cdl.CDLUnit;
import obp.transfo.cdl.CDLToConcreteContext;
import obp.util.CDLUtil;
import obp.util.ConcreteContextUtil;

public class CDLCompiler {
    private File ctxDirectory;
    private String cdlName;
    private File cdlPath;

    public File compileCDL(File cdlFile, String cdlName, File contextDirectory) {
        try {
            CDLUnit cdlUnit = CDLUtil.readCDLAndResolveReferences(cdlFile);
            CDLDeclaration cdl = CDLUtil.findDeclaration(cdlUnit, cdlName, CDLDeclaration.class);
            ConcreteContext concreteContext = CDLToConcreteContext.toConcreteContext(cdlUnit, cdl);
            File file = new File(contextDirectory, concreteContext.getName() + ".cc");
            ConcreteContextUtil.saveCC(concreteContext, file);
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<File> compileCDL(File cdlFile, File contextDirectory) {
        try {
            CDLUnit cdlUnit = CDLUtil.readCDLAndResolveReferences(cdlFile);
            List<CDLDeclaration> declarations = CDLUtil.findAllDeclarations(cdlUnit, CDLDeclaration.class);
            ArrayList<File> files = new ArrayList<File>();
            for (CDLDeclaration cdl : declarations) {
                ConcreteContext cc = CDLToConcreteContext.toConcreteContext(cdlUnit, cdl);
                File file = new File(contextDirectory, cc.getName() + ".cc");
                ConcreteContextUtil.saveCC(cc, file);
                files.add(file);
                System.out.println(cc.getName() + " has " + cc.getStateCount() + " states " + ConcreteContextUtil.countPathsLinear(cc).toString() + " paths and " + ConcreteContextUtil.maxAccumulatedReachability(cc) + " reachability");
            }
            return files;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void usage() {
        System.out.println("Usage: CDLCompiler [options] cdl-file-path");
        System.out.println("Mandatory parameters: ");
        System.out.println("\t[--context-directory or -o] path\tdestination Path for the generated context.");
        System.out.println();
        System.out.println("Context parameters:");
        System.out.println("\t[--name or -n] string\t\t The name of the cdl to be compiled");
        System.out.println();
        System.out.println("Other parameters:");
        System.out.println("\t[--help or -h]\t\t\tPrints this help and exit.");
    }

    public boolean readArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if ("--context-directory".equals(args[i]) || "-o".equals(args[i])) {
                if (++i == args.length) {
                    System.err.println("Option '--context-directory' needs an argument.");
                    return false;
                }
                if (args[i].length() == 0 || args[i].startsWith("-")) {
                    System.err.println("Invalid file name '" + args[i] + "'.");
                    return false;
                }
                this.ctxDirectory = new File(args[i]);
                continue;
            }
            if ("--name".equals(args[i]) || "-n".equals(args[i])) {
                if (++i == args.length) {
                    System.err.println("Option '--name' needs an argument.");
                    return false;
                }
                if (args[i].length() == 0 || args[i].startsWith("-")) {
                    System.err.println("Invalid name parameter '" + args[i] + "'.");
                    return false;
                }
                this.cdlName = args[i];
                continue;
            }
            if ("--help".equals(args[i]) || "-h".equals(args[i])) {
                this.usage();
                return false;
            }
            if (this.cdlPath != null) continue;
            this.cdlPath = new File(args[i]);
        }
        if (this.cdlPath == null) {
            System.err.println("missing path to the cdl file");
            this.usage();
            return false;
        }
        if (this.ctxDirectory == null) {
            System.err.println("Missing context directory path (--context-directory)");
            this.usage();
            return false;
        }
        return true;
    }

    public void defaultCompile() {
        if (!this.ctxDirectory.exists()) {
            this.ctxDirectory.mkdirs();
        }
        if (this.cdlName == null) {
            List<File> ccList = this.compileCDL(this.cdlPath, this.ctxDirectory);
            System.out.println("Compiled CDL file " + this.cdlPath.getName() + " in " + ccList.size() + " concrete contexts: ");
            for (File file : ccList) {
                System.out.println("\t- " + file.getPath());
            }
        } else {
            File ccPath = this.compileCDL(this.cdlPath, this.cdlName, this.ctxDirectory);
            System.out.println("Compiled CDL " + this.cdlName + " from " + this.cdlPath.getName() + " in \n\t- " + ccPath.getPath());
        }
    }

    public static void main(String[] args) {
        CDLCompiler main = new CDLCompiler();
        try {
            if (main.readArguments(args)) {
                main.defaultCompile();
                System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }
}

