/*
 * Decompiled with CFR 0.152.
 */
package DVE.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BinaryOperator implements Enumerator
{
    IMPLY(0, "IMPLY", "IMPLY"),
    OR(0, "OR", "OR"),
    AND(0, "AND", "AND"),
    BOR(0, "BOR", "BOR"),
    BAND(0, "BAND", "BAND"),
    BXOR(0, "BXOR", "BXOR"),
    EQ(0, "EQ", "EQ"),
    NEQ(0, "NEQ", "NEQ"),
    LT(0, "LT", "LT"),
    LEQ(0, "LEQ", "LEQ"),
    GT(0, "GT", "GT"),
    GEQ(0, "GEQ", "GEQ"),
    SHL(0, "SHL", "SHL"),
    SHR(0, "SHR", "SHR"),
    PLUS(0, "PLUS", "PLUS"),
    MINUS(0, "MINUS", "MINUS"),
    MULT(0, "MULT", "MULT"),
    DIV(0, "DIV", "DIV"),
    MOD(0, "MOD", "MOD");

    public static final int IMPLY_VALUE = 0;
    public static final int OR_VALUE = 0;
    public static final int AND_VALUE = 0;
    public static final int BOR_VALUE = 0;
    public static final int BAND_VALUE = 0;
    public static final int BXOR_VALUE = 0;
    public static final int EQ_VALUE = 0;
    public static final int NEQ_VALUE = 0;
    public static final int LT_VALUE = 0;
    public static final int LEQ_VALUE = 0;
    public static final int GT_VALUE = 0;
    public static final int GEQ_VALUE = 0;
    public static final int SHL_VALUE = 0;
    public static final int SHR_VALUE = 0;
    public static final int PLUS_VALUE = 0;
    public static final int MINUS_VALUE = 0;
    public static final int MULT_VALUE = 0;
    public static final int DIV_VALUE = 0;
    public static final int MOD_VALUE = 0;
    private static final BinaryOperator[] VALUES_ARRAY;
    public static final List<BinaryOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static BinaryOperator get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            BinaryOperator result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static BinaryOperator getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            BinaryOperator result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static BinaryOperator get(int value) {
        switch (value) {
            case 0: {
                return IMPLY;
            }
        }
        return null;
    }

    private BinaryOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new BinaryOperator[]{IMPLY, OR, AND, BOR, BAND, BXOR, EQ, NEQ, LT, LEQ, GT, GEQ, SHL, SHR, PLUS, MINUS, MULT, DIV, MOD};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

