/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.model;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDBooleanVariable;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModelObject;
import fr.ensta.aefd.model.AEFDModelVisitor;
import java.util.Comparator;
import java.util.LinkedList;

public class AEFDModel
implements AEFDModelObject {
    private final LinkedList<AEFDAutomate> automateList;
    private final LinkedList<AEFDBooleanVariable> variableList;
    private final LinkedList<AEFDFunctionalEntity> functionalEntityList;
    private final LinkedList<Comparator<AEFDAutomate>> executionOrderList = new LinkedList();
    private final Comparator<AEFDAutomate> executionOrder = (o1, o2) -> {
        for (Comparator comparator : this.executionOrderList) {
            int result = comparator.compare(o1, o2);
            if (result == 0) continue;
            return result;
        }
        return 0;
    };

    public AEFDModel() {
        this.automateList = new LinkedList();
        this.variableList = new LinkedList();
        this.functionalEntityList = new LinkedList();
    }

    public LinkedList<AEFDAutomate> getAllAutomates() {
        return this.automateList;
    }

    public boolean addAutomate(AEFDAutomate automate) {
        if (this.automateList.contains(automate)) {
            return false;
        }
        this.automateList.add(automate);
        return true;
    }

    public LinkedList<AEFDBooleanVariable> getAllVariables() {
        return this.variableList;
    }

    public boolean addVariable(AEFDBooleanVariable variable) {
        if (this.variableList.contains(variable)) {
            return false;
        }
        this.variableList.add(variable);
        return true;
    }

    public LinkedList<AEFDFunctionalEntity> getAllFunctionalEntity() {
        return this.functionalEntityList;
    }

    public boolean addFunctionalEntity(AEFDFunctionalEntity functionalEntity) {
        if (this.functionalEntityList.contains(functionalEntity)) {
            return false;
        }
        this.functionalEntityList.add(functionalEntity);
        return true;
    }

    public void addDeclarationBasedExecutionOrder() {
        this.addExecutionOrder((o1, o2) -> this.automateList.indexOf(o1) - this.automateList.indexOf(o2));
    }

    public void addExecutionOrder(Comparator<AEFDAutomate> orderRelation) {
        this.executionOrderList.add(orderRelation);
    }

    public Comparator<AEFDAutomate> getExecutionOrder() {
        return this.executionOrder;
    }

    public boolean hasExecutionOrder() {
        return !this.executionOrderList.isEmpty();
    }

    @Override
    public void accept(AEFDModelVisitor visitor) {
        visitor.visitModel(this);
    }
}

