/*
 * Decompiled with CFR 0.152.
 */
package plug.ui2.simulation.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.kordamp.ikonli.javafx.FontIcon;
import plug.core.IRuntimeView;
import plug.core.view.ConfigurationItem;

public class ConfigurationTreeView<C, T>
extends TreeView<ConfigurationItem> {
    BooleanProperty showDifferencesOnly = new SimpleBooleanProperty(false);
    BooleanProperty expandedTree = new SimpleBooleanProperty(false);
    boolean userChangedExpandedStatus = false;
    ContextMenu contextMenu;
    Map<String, Image> imageMap = new HashMap<String, Image>();

    public void setShowDifferencesOnly(boolean showDifferencesOnly) {
        this.showDifferencesOnly.set(showDifferencesOnly);
    }

    public void setExpandedTree(boolean expandedTree) {
        this.expandedTree.set(expandedTree);
    }

    public ConfigurationTreeView(ObjectProperty<C> inCurrentConfiguration, ObjectProperty<IRuntimeView<C, T>> inRuntimeViewProperty, boolean inShowDifferencesOnly, boolean inExpandedTree) {
        this.setShowDifferencesOnly(inShowDifferencesOnly);
        this.setExpandedTree(inExpandedTree);
        this.setCellFactory(tV -> new ConfigurationItemTreeCell());
        inCurrentConfiguration.addListener((ov, o, n) -> this.updateTree(n, (IRuntimeView)inRuntimeViewProperty.get()));
        this.showDifferencesOnly.addListener((a, o, n) -> {
            this.setRoot(this.buildTreeItem(this.getRoot() == null ? null : (ConfigurationItem)this.getRoot().getValue()));
            this.setPrefSize(this.contentWidth(), this.contentHeight());
        });
        this.expandedTree.addListener((a, o, n) -> {
            this.expandCollapseTreeView(this.getRoot());
            this.setPrefSize(this.contentWidth(), this.contentHeight());
            this.userChangedExpandedStatus = false;
        });
        this.setOnMouseClicked(me -> this.setPrefSize(this.contentWidth(), this.contentHeight()));
        this.contextMenu = new ContextMenu();
        MenuItem showDifferencesMenuItem = new MenuItem();
        showDifferencesMenuItem.setOnAction(me -> this.setShowDifferencesOnly(!this.showDifferencesOnly.get()));
        showDifferencesMenuItem.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> this.showDifferencesOnly.get() ? "Show all items" : "Show only differences", (Observable[])new Observable[]{this.showDifferencesOnly}));
        MenuItem expandTreeMenuItem = new MenuItem();
        expandTreeMenuItem.setOnAction(me -> this.setExpandedTree(!this.expandedTree.get()));
        expandTreeMenuItem.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> this.expandedTree.get() ? "Collapse tree" : "Expand tree", (Observable[])new Observable[]{this.expandedTree}));
        this.contextMenu.getItems().addAll((Object[])new MenuItem[]{showDifferencesMenuItem, expandTreeMenuItem});
        this.setOnContextMenuRequested(e -> this.contextMenu.show(((Node)e.getTarget()).getScene().getWindow(), e.getScreenX(), e.getScreenY()));
        this.setShowRoot(false);
    }

    public void addContextMenuAction(String iconDescription, StringBinding text, Consumer<Event> value) {
        if (this.contextMenu == null) {
            return;
        }
        FontIcon icon = new FontIcon(iconDescription);
        MenuItem item = new MenuItem("", (Node)icon);
        item.textProperty().bind((ObservableValue)text);
        item.setOnAction(value::accept);
        this.contextMenu.getItems().add((Object)item);
    }

    private void expandCollapseTreeView(TreeItem<?> item) {
        if (item != null && !item.isLeaf()) {
            if (item != this.getRoot() || this.isShowRoot()) {
                item.setExpanded(this.expandedTree.get());
            }
            for (TreeItem child : item.getChildren()) {
                this.expandCollapseTreeView(child);
            }
        }
    }

    void updateTree(C inConfiguration, IRuntimeView<C, T> inRuntimeView) {
        ConfigurationItem currentConfigurationItem;
        ConfigurationItem configurationItem = currentConfigurationItem = this.getRoot() == null ? null : (ConfigurationItem)this.getRoot().getValue();
        if (inConfiguration == null) {
            this.setRoot(null);
            this.setPrefSize(this.contentWidth(), this.contentHeight());
            return;
        }
        List configurationItems = inRuntimeView.getConfigurationItems(inConfiguration);
        ConfigurationItem newConfigurationItem = new ConfigurationItem("configuration", inRuntimeView.getConfigurationDescription(inConfiguration), null, configurationItems);
        if (currentConfigurationItem == null) {
            newConfigurationItem.setExpanded(true);
        }
        newConfigurationItem.updateDifferentStatus(currentConfigurationItem);
        newConfigurationItem.updateExpanded(currentConfigurationItem);
        this.setRoot(this.buildTreeItem(newConfigurationItem));
        this.getRoot().setExpanded(newConfigurationItem.isExpanded());
        this.setPrefSize(this.contentWidth(), this.contentHeight());
    }

    TreeItem<ConfigurationItem> buildTreeItem(ConfigurationItem configurationItem) {
        if (configurationItem == null) {
            return null;
        }
        if (configurationItem.getChildren().isEmpty()) {
            return new TreeItem((Object)configurationItem);
        }
        TreeItem subtree = new TreeItem((Object)configurationItem);
        subtree.setExpanded(!this.userChangedExpandedStatus && this.expandedTree.get() || configurationItem.isExpanded());
        subtree.expandedProperty().addListener((ao, o, n) -> {
            this.userChangedExpandedStatus = true;
            configurationItem.setExpanded(n.booleanValue());
        });
        ObservableList children = subtree.getChildren();
        for (ConfigurationItem subitem : configurationItem.getChildren()) {
            if (this.showDifferencesOnly.get() && !subitem.isDifferent()) continue;
            children.add(this.buildTreeItem(subitem));
        }
        return subtree;
    }

    public double contentWidth() {
        TreeItem root = this.getRoot();
        if (root == null) {
            return 25.0;
        }
        return this.computeWidth((TreeItem<ConfigurationItem>)root, 0);
    }

    protected double computeWidth(TreeItem<ConfigurationItem> item, int depth) {
        double width = 20 + depth * 10 + ((ConfigurationItem)item.getValue()).getName().length() * 8;
        if (item.isExpanded()) {
            for (TreeItem child : item.getChildren()) {
                width = Math.max(width, this.computeWidth((TreeItem<ConfigurationItem>)child, depth + 1));
            }
        }
        return width;
    }

    double contentHeight() {
        TreeItem root = this.getRoot();
        if (root == null) {
            return 15.0;
        }
        return this.computeHeight((TreeItem<ConfigurationItem>)root, 0) + 15.0;
    }

    double computeHeight(TreeItem<ConfigurationItem> item, int depth) {
        double height = 20.0;
        if (depth == 0 && !this.isShowRoot()) {
            height = 0.0;
        }
        if (item.isExpanded()) {
            for (TreeItem child : item.getChildren()) {
                height += this.computeHeight((TreeItem<ConfigurationItem>)child, depth + 1);
            }
        }
        return height;
    }

    private class ConfigurationItemTreeCell
    extends TreeCell<ConfigurationItem> {
        private ConfigurationItemTreeCell() {
        }

        protected void updateItem(ConfigurationItem item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                if (item.getIcon() != null) {
                    String iconPath = item.getIcon();
                    Image image = ConfigurationTreeView.this.imageMap.get(iconPath);
                    if (image == null) {
                        image = new Image(iconPath, 16.0, 16.0, true, true);
                        ConfigurationTreeView.this.imageMap.put(iconPath, image);
                    }
                    this.setGraphic((Node)new ImageView(image));
                }
                this.setText(item.getName());
                if (item.isDifferent()) {
                    this.setTextFill((Paint)Color.BLUE);
                } else {
                    this.setTextFill((Paint)Color.BLACK);
                }
            }
        }
    }
}

