/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.parser;

import fr.ensta.aefd.model.AEFDAction;
import fr.ensta.aefd.model.AEFDActionSequence;
import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDBooleanExpression;
import fr.ensta.aefd.model.AEFDBooleanVariable;
import fr.ensta.aefd.model.AEFDCondition;
import fr.ensta.aefd.model.AEFDEvent;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.toolbox.tools.parser.Parser;
import fr.ensta.dco.antlr.DCOBaseListener;
import fr.ensta.dco.antlr.DCOParser;
import java.util.LinkedList;

public class DCOListener
extends DCOBaseListener {
    private final Parser parser;
    private final LinkedList<AEFDBooleanExpression> boolExpStack = new LinkedList();
    private AEFDAutomate currentAutomate;
    private AEFDEvent lastEvent;
    private AEFDCondition lastCondition;
    private AEFDActionSequence currentAction;
    private boolean appendAction = false;
    private AEFDFunctionalEntity lastFunctionalEntity;
    private boolean bExpEventMode = false;

    public DCOListener(Parser parser) {
        this.parser = parser;
    }

    public void exitAutomateHeader(DCOParser.AutomateHeaderContext ctx) {
        super.exitAutomateHeader(ctx);
        String automateName = ctx.IDENTIFIER(0).getText();
        this.currentAutomate = this.parser.references.getAutomate(automateName, true);
        int tokenAmount = Integer.valueOf(ctx.NUMBER(3).getText());
        this.currentAutomate.setNumberOfTokens(tokenAmount);
        String domain = ctx.NUMBER(4).getText();
        this.currentAutomate.setInitialPlace(domain);
    }

    public void enterEventDecl(DCOParser.EventDeclContext ctx) {
        super.enterEventDecl(ctx);
        this.bExpEventMode = true;
    }

    public void exitEventDecl(DCOParser.EventDeclContext ctx) {
        super.exitEventDecl(ctx);
        this.lastEvent = new AEFDEvent();
        if (this.boolExpStack.isEmpty()) {
            throw new IllegalArgumentException("Empty event field are not allowed for transitions");
        }
        this.lastEvent.setBoolExp(this.boolExpStack.removeLast());
    }

    public void enterConditionDecl(DCOParser.ConditionDeclContext ctx) {
        super.enterConditionDecl(ctx);
        this.bExpEventMode = false;
    }

    public void exitConditionDecl(DCOParser.ConditionDeclContext ctx) {
        super.exitConditionDecl(ctx);
        this.lastCondition = new AEFDCondition();
        if (this.boolExpStack.isEmpty()) {
            this.boolExpStack.add(AEFDBooleanExpression.TRUE);
        }
        this.lastCondition.setBoolExp(this.boolExpStack.removeLast());
    }

    public void enterActionList(DCOParser.ActionListContext ctx) {
        super.enterActionList(ctx);
        this.currentAction = new AEFDActionSequence();
        this.appendAction = true;
    }

    public void exitActionList(DCOParser.ActionListContext ctx) {
        this.appendAction = false;
    }

    public void exitTransitionDecl(DCOParser.TransitionDeclContext ctx) {
        super.exitTransitionDecl(ctx);
        String[] places = ctx.NUMBER(0).getText().split("_");
        String source = places[0];
        String target = places[1];
        AEFDTransition transition = new AEFDTransition(source, target);
        transition.setEvent(this.lastEvent);
        transition.setCondition(this.lastCondition);
        transition.setAction(this.currentAction);
        this.currentAutomate.addTransition(transition);
    }

    public void exitFunctionalEntityWithoutParameter(DCOParser.FunctionalEntityWithoutParameterContext ctx) {
        super.exitFunctionalEntityWithoutParameter(ctx);
        String dcoIdentifer = ctx.IDENTIFIER().getText();
        this.lastFunctionalEntity = this.parser.references.getFunctionalEntity(dcoIdentifer, null, true);
        if (this.appendAction) {
            for (AEFDAction action : this.parser.getActionList(this.lastFunctionalEntity)) {
                this.currentAction.addAction(action);
            }
        }
    }

    public void exitFunctionalEntityWithParameter(DCOParser.FunctionalEntityWithParameterContext ctx) {
        super.exitFunctionalEntityWithParameter(ctx);
        String dcoIdentifer = ctx.IDENTIFIER().getText();
        int parameter = Integer.valueOf(ctx.NUMBER().getText());
        this.lastFunctionalEntity = this.parser.references.getFunctionalEntity(dcoIdentifer, parameter, true);
        if (this.appendAction) {
            for (AEFDAction action : this.parser.getActionList(this.lastFunctionalEntity)) {
                this.currentAction.addAction(action);
            }
        }
    }

    public void exitBexpTrue(DCOParser.BexpTrueContext ctx) {
        super.exitBexpTrue(ctx);
        this.boolExpStack.add(AEFDBooleanExpression.TRUE);
    }

    public void exitBexpFalse(DCOParser.BexpFalseContext ctx) {
        super.exitBexpFalse(ctx);
        this.boolExpStack.add(AEFDBooleanExpression.FALSE);
    }

    public void exitBexpIdentifier(DCOParser.BexpIdentifierContext ctx) {
        super.exitBexpIdentifier(ctx);
        if (this.bExpEventMode) {
            this.boolExpStack.add(this.parser.getTrigger(this.lastFunctionalEntity));
        } else {
            AEFDBooleanVariable booleanVariable = this.parser.references.getBooleanVariable(this.lastFunctionalEntity);
            boolean expectedValue = booleanVariable.getBooleanValue(this.lastFunctionalEntity.getSuffix());
            this.boolExpStack.add(new AEFDBooleanExpression.VariableEvaluation(booleanVariable, expectedValue));
        }
    }

    public void exitBexpNot(DCOParser.BexpNotContext ctx) {
        super.exitBexpNot(ctx);
        this.boolExpStack.add(new AEFDBooleanExpression.Not(this.boolExpStack.removeLast()));
    }

    public void exitBexpAnd(DCOParser.BexpAndContext ctx) {
        super.exitBexpAnd(ctx);
        AEFDBooleanExpression rhs = this.boolExpStack.removeLast();
        AEFDBooleanExpression lhs = this.boolExpStack.removeLast();
        this.boolExpStack.add(new AEFDBooleanExpression.And(lhs, rhs));
    }

    public void exitBexpOr(DCOParser.BexpOrContext ctx) {
        super.exitBexpOr(ctx);
        AEFDBooleanExpression rhs = this.boolExpStack.removeLast();
        AEFDBooleanExpression lhs = this.boolExpStack.removeLast();
        this.boolExpStack.add(new AEFDBooleanExpression.Or(lhs, rhs));
    }

    public void exitBexpEmpty(DCOParser.BexpEmptyContext ctx) {
        super.exitBexpEmpty(ctx);
        this.boolExpStack.add(AEFDBooleanExpression.TRUE);
    }
}

