/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.compiler;

import java.util.LinkedHashMap;
import java.util.Map;
import org.cte.ABCD.compiler.Scope;
import org.cte.ABCD.compiler.Symbol;

public class BaseScope
implements Scope {
    private Scope enclosingScope;
    private Map<String, Symbol> symbols = new LinkedHashMap<String, Symbol>();

    public BaseScope(Scope enclosingScope) {
        this.enclosingScope = enclosingScope;
    }

    @Override
    public Scope getEnclosingScope() {
        return this.enclosingScope;
    }

    @Override
    public Boolean define(Symbol sym) {
        if (this.symbols.put(sym.getName(), sym) != null) {
            return false;
        }
        sym.setScope(this);
        return true;
    }

    @Override
    public Symbol resolve(String name, boolean tryEnclosingScope) {
        Symbol s = this.symbols.get(name);
        if (s != null) {
            return s;
        }
        if (tryEnclosingScope && this.enclosingScope != null) {
            return this.enclosingScope.resolve(name, tryEnclosingScope);
        }
        return null;
    }

    @Override
    public String getScopeName() {
        if (this.enclosingScope == null) {
            return "global ";
        }
        return this.enclosingScope.getScopeName() + "scope ";
    }
}

