/*
 * Decompiled with CFR 0.152.
 */
package obp.interpreter;

import java.io.IOException;
import java.util.Set;
import java.util.Stack;
import obp.interpreter.IBehavior;
import obp.interpreter.IProgram;
import obp.interpreter.ITransition;
import obp.interpreter.InterpreterVisitor;
import org.xid.basics.sexp.S;
import org.xid.basics.sexp.SExp;
import org.xid.basics.sexp.SList;
import org.xid.basics.sexp.model.ModelToSExp;
import org.xid.basics.sexp.model.Referencer;

public class InterpreterToSExp
implements InterpreterVisitor {
    private final ModelToSExp context;
    private final Stack<SExp> sexpStack = new Stack();

    public InterpreterToSExp(Referencer referencer) {
        this.context = new ModelToSExp(referencer);
    }

    public void pushSExp(SExp sexp) {
        this.sexpStack.push(sexp);
    }

    public SExp popSExp() {
        return this.sexpStack.pop();
    }

    @Override
    public void visitIProgram(IProgram toVisit) {
        this.context.push((Object)toVisit);
        SList result = new SList();
        result.addChild((SExp)S.satom((String)"iProgram"));
        S.addChildIfNotNull((SList)result, (SExp)S.stringToSExp((String)"name", (String)toVisit.getName()));
        S.addChildIfNotNull((SList)result, (SExp)S.stringToSExp((String)"init", (String)toVisit.getInit()));
        S.addChildIfNotNull((SList)result, (SExp)S.stringCollectionToSExp((String)"eventSet", toVisit.getEventList()));
        S.addChildIfNotNull((SList)result, (SExp)S.stringCollectionToSExp((String)"informalSet", toVisit.getInformalList()));
        if (toVisit.getBehaviorCount() > 0) {
            SList referenceSExp = S.slist((SExp[])new SExp[]{S.satom((String)"behaviorSet")});
            for (IBehavior child : toVisit.getBehaviorList()) {
                child.accept(this);
                referenceSExp.addChild(this.popSExp());
            }
            result.addChild((SExp)referenceSExp);
        }
        this.context.pop((Object)toVisit);
        this.pushSExp((SExp)result);
    }

    @Override
    public void visitIBehavior(IBehavior toVisit) {
        this.context.push((Object)toVisit);
        SList result = new SList();
        result.addChild((SExp)S.satom((String)"iBehavior"));
        S.addChildIfNotNull((SList)result, (SExp)S.stringToSExp((String)"name", (String)toVisit.getName()));
        S.addChildIfNotNull((SList)result, (SExp)S.stringCollectionToSExp((String)"valueSet", toVisit.getValueList()));
        S.addChildIfNotNull((SList)result, (SExp)S.stringCollectionToSExp((String)"initializerSet", toVisit.getInitializerList()));
        S.addChildIfNotNull((SList)result, (SExp)S.stringCollectionToSExp((String)"triggerSet", toVisit.getTriggerList()));
        if (toVisit.getTransitionCount() > 0) {
            SList referenceSExp = S.slist((SExp[])new SExp[]{S.satom((String)"transitionSet")});
            for (ITransition child : toVisit.getTransitionList()) {
                child.accept(this);
                referenceSExp.addChild(this.popSExp());
            }
            result.addChild((SExp)referenceSExp);
        }
        this.context.pop((Object)toVisit);
        this.pushSExp((SExp)result);
    }

    @Override
    public void visitITransition(ITransition toVisit) {
        this.context.push((Object)toVisit);
        SList result = new SList();
        result.addChild((SExp)S.satom((String)"iTransition"));
        S.addChildIfNotNull((SList)result, (SExp)S.stringToSExp((String)"on", (String)toVisit.getOn()));
        S.addChildIfNotNull((SList)result, (SExp)S.stringToSExp((String)"guard", (String)toVisit.getGuard()));
        S.addChildIfNotNull((SList)result, (SExp)S.stringToSExp((String)"action", (String)toVisit.getAction()));
        this.context.pop((Object)toVisit);
        this.pushSExp((SExp)result);
    }

    public SExp getResult() throws IOException {
        Set<Object> missingObjects = this.missingObjects();
        if (!missingObjects.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append("Missing object(s): ");
            int length = message.length();
            for (Object object : missingObjects) {
                if (message.length() > length) {
                    message.append(", ");
                }
                message.append(object);
            }
            message.append(".");
            throw new IOException(message.toString());
        }
        return this.popSExp();
    }

    public Set<Object> missingObjects() {
        return this.context.missingObjects();
    }
}

