/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.compiler;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import obp.explorer.runtime.util.NameUtil;
import obp.fiacre.checker.NodeAnalyzer;
import obp.fiacre.checker.ProgramAnalyzer;
import obp.fiacre.checker.TransitionAnalyzer;
import obp.fiacre.checker.TypeAnalyzer;
import obp.fiacre.checker.VariableAnalyzer;
import obp.fiacre.checker.type.CExisting;
import obp.fiacre.checker.type.CType;
import obp.fiacre.compiler.AssignmentGenerator;
import obp.fiacre.compiler.ClockBindingsGenerator;
import obp.fiacre.compiler.ComponentGenerator;
import obp.fiacre.compiler.ExpressionGenerator;
import obp.fiacre.compiler.PatternGenerator;
import obp.fiacre.compiler.ProcessGenerator;
import obp.fiacre.compiler.StatementGenerator;
import obp.fiacre.compiler.TransitionGenerator;
import obp.fiacre.compiler.TypeGenerator;
import obp.fiacre.ffi.FFIBindingGeneratorI;
import obp.fiacre.ffi.try2.FFIBindingGenerator;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.ChannelDecl;
import obp.fiacre.model.ComponentDecl;
import obp.fiacre.model.ConstantDecl;
import obp.fiacre.model.Declaration;
import obp.fiacre.model.ExternalArgument;
import obp.fiacre.model.ExternalFunctionDecl;
import obp.fiacre.model.FunctionDecl;
import obp.fiacre.model.LocalVariable;
import obp.fiacre.model.NodeDecl;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Program;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Type;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.TypeId;
import obp.fiacre.util.TypeUtil;
import org.xid.basics.error.ErrorHandler;
import org.xid.basics.generation.java.DependencyManager;
import org.xid.basics.generation.java.Java;
import org.xid.basics.generation.java.JavaContentFormatter;
import org.xid.basics.generation.java.JavaContentHandler;
import org.xid.basics.generation.java.JavaContentWriter;

public class ProgramGenerator {
    private final ErrorHandler errorHandler;
    private JavaContentHandler content;
    private DependencyManager dependencyManager;
    private ProgramAnalyzer programAnalyzer;
    private ClockBindingsGenerator clockBindingsGenerator;
    private ExpressionGenerator expressionGenerator;
    private AssignmentGenerator assignmentGenerator;
    private StatementGenerator statementGenerator;
    private PatternGenerator patternGenerator;
    private TypeGenerator typeGenerator;
    private TransitionGenerator transitionGenerator;
    private ProcessGenerator processGenerator;
    private ComponentGenerator componentGenerator;
    private FFIBindingGeneratorI ffiBindingGenerator;
    private final File destinationFile;
    public final String basePackage;
    private String programName;
    public String packageName;
    public boolean usesFFI = false;
    boolean hasNativeCode = false;

    public ProgramGenerator(ErrorHandler errorHandler, File destinationFile, String basePackage) {
        this.errorHandler = errorHandler;
        this.destinationFile = destinationFile;
        this.basePackage = basePackage;
    }

    public File getDestinationFile() {
        return this.destinationFile;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public JavaContentHandler getContent() {
        return this.content;
    }

    public String getProgramName() {
        return this.programName;
    }

    public Map<Type, String> getTypeNames() {
        return this.getTypeAnalyzer().getTypeNames();
    }

    public Map<CType, TypeDecl> getCTypeMap() {
        return this.getTypeAnalyzer().getCTypeMap();
    }

    public NodeAnalyzer getNodeAnalyzer() {
        return this.programAnalyzer.getProcessAnalyser();
    }

    public TransitionAnalyzer getTransitionAnalyser() {
        return this.programAnalyzer.getTransitionAnalyser();
    }

    public VariableAnalyzer getVariableAnalyser() {
        return this.programAnalyzer.getVariableAnalyser();
    }

    public TypeAnalyzer getTypeAnalyzer() {
        return this.programAnalyzer.getTypeAnalyzer();
    }

    public ClockBindingsGenerator getClockBindingsGenerator() {
        return this.clockBindingsGenerator;
    }

    public ExpressionGenerator getExpressionGenerator() {
        return this.expressionGenerator;
    }

    public AssignmentGenerator getAssignmentGenerator() {
        return this.assignmentGenerator;
    }

    public StatementGenerator getStatementGenerator() {
        return this.statementGenerator;
    }

    public PatternGenerator getPatternGenerator() {
        return this.patternGenerator;
    }

    public TransitionGenerator getTransitionGenerator() {
        return this.transitionGenerator;
    }

    public TypeGenerator getTypeGenerator() {
        return this.typeGenerator;
    }

    public ProcessGenerator getProcessGenerator() {
        return this.processGenerator;
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public void generateImports() {
        for (String oneImport : this.dependencyManager.getJavaImports()) {
            this.content.import_(0, oneImport);
        }
    }

    public String generate(File fiacreFile, Program program) {
        this.dependencyManager = new DependencyManager();
        JavaContentWriter javaWriter = new JavaContentWriter(this.getDestinationFile());
        this.content = new JavaContentFormatter((JavaContentHandler)javaWriter);
        this.programName = ProgramGenerator.programName(this.getBaseName(fiacreFile));
        this.programAnalyzer = new ProgramAnalyzer(this.errorHandler, program);
        this.programAnalyzer.analyze();
        this.clockBindingsGenerator = new ClockBindingsGenerator();
        this.clockBindingsGenerator.computeWaitBindings(program);
        this.expressionGenerator = new ExpressionGenerator(this);
        this.assignmentGenerator = new AssignmentGenerator(this);
        this.statementGenerator = new StatementGenerator(this);
        this.patternGenerator = new PatternGenerator(this);
        this.typeGenerator = new TypeGenerator(this);
        this.transitionGenerator = new TransitionGenerator(this);
        this.processGenerator = new ProcessGenerator(this);
        this.componentGenerator = new ComponentGenerator(this);
        this.packageName = ProgramGenerator.packageName(this.getBaseName(fiacreFile));
        if (this.getBasePackage() != null) {
            this.content.beginPackage(this.getBasePackage());
        }
        this.content.beginPackage(this.packageName);
        boolean hasExternalArrays = false;
        this.ffiBindingGenerator = new FFIBindingGenerator(this, fiacreFile);
        for (Declaration declaration : program.getDeclarationList()) {
            if (declaration instanceof TypeDecl) {
                TypeDecl typeDecl = (TypeDecl)declaration;
                if (!TypeUtil.isGeneratedClassType(typeDecl.getIs())) continue;
                this.typeGenerator.createTypeClass(typeDecl);
                continue;
            }
            if (declaration instanceof ProcessDecl) {
                this.processGenerator.generateProcess((ProcessDecl)declaration);
                continue;
            }
            if (declaration instanceof ComponentDecl) {
                this.componentGenerator.generateComponent((ComponentDecl)declaration);
                continue;
            }
            if (!(declaration instanceof ExternalFunctionDecl)) continue;
            this.usesFFI = true;
            try {
                this.ffiBindingGenerator.generateBindings((ExternalFunctionDecl)declaration);
            }
            catch (Exception e) {
                e.printStackTrace();
                return "cannot generate code";
            }
            hasExternalArrays |= this.ffiBindingGenerator.hasArray();
        }
        this.ffiBindingGenerator.emitBindings(this.getDestinationFile());
        this.createProgramClass(this.programName, program, hasExternalArrays);
        this.content.endPackage(this.packageName);
        if (this.getBasePackage() != null) {
            this.content.endPackage(this.getBasePackage());
        }
        return ProgramGenerator.getProgramQualifiedName(this.getBasePackage(), this.getBaseName(fiacreFile));
    }

    public String getBaseName(File fiacreFile) {
        String name = fiacreFile.getName();
        int index = name.lastIndexOf(46);
        if (index > 0) {
            name = name.substring(0, index);
        }
        return name;
    }

    private void createProgramClass(String programName, Program program, boolean hasExternalArrays) {
        this.dependencyManager.clear();
        this.content.beginFile(programName + ".java");
        this.content.markImports();
        this.dependencyManager.getShortName("obp.explorer.runtime.Component");
        this.dependencyManager.getShortName("obp.explorer.runtime.Program");
        this.dependencyManager.getShortName("obp.explorer.runtime.SymbolsTable");
        if (hasExternalArrays) {
            this.dependencyManager.getShortName("java.util.Arrays");
        }
        this.content.beginClass(4, programName, null, "Program");
        this.generateProgramMetaInformations(program);
        for (Declaration declaration : program.getDeclarationList()) {
            if (declaration instanceof ConstantDecl) {
                this.generateConstant((ConstantDecl)declaration);
                continue;
            }
            if (declaration instanceof FunctionDecl) {
                this.generateFunction((FunctionDecl)declaration);
                continue;
            }
            if (!(declaration instanceof ExternalFunctionDecl)) continue;
            this.generateExternalFunction((ExternalFunctionDecl)declaration);
        }
        if (this.hasNativeCode) {
            this.content.codeln(0, "static { ");
            this.content.codeln(1, "try {");
            this.content.codeln(2, "System.loadLibrary(\"primitivesImplementation\");");
            this.content.codeln(2, "} catch (UnsatisfiedLinkError ex) { }");
            this.content.codeln(0, "}");
            this.content.codeln(0, "private native static void primUnloadLibrary();");
            this.content.codeln(0, "@Override");
            this.content.codeln(0, "public void unloadExternalLibrary() {primUnloadLibrary(); }");
        } else {
            this.content.codeln(0, "@Override");
            this.content.codeln(0, "public void unloadExternalLibrary() { }");
        }
        this.content.beginAttribute(1, "Component", "root");
        this.content.endAttribute("root");
        this.content.annotation("Override", null);
        this.content.beginMethod(4, "Component", "getRoot", null, new Java.Parameter[]{new Java.Parameter(0, "SymbolsTable", "symbols")});
        this.content.codeln(0, "if (root == null) {");
        for (String informal : this.getNodeAnalyzer().getInformalMap().keySet()) {
            this.content.codeln(1, "symbols.newInformalId(\"" + informal + "\");");
        }
        for (Declaration declaration : program.getDeclarationList()) {
            if (!(declaration instanceof ChannelDecl)) continue;
            this.content.codeln(1, "symbols.newChannelId(\"" + declaration.getName() + "\");");
        }
        NodeDecl root = program.getRoot();
        StringBuilder creationCode = new StringBuilder();
        creationCode.append("root = new ");
        creationCode.append(ProgramGenerator.getComponentName(root));
        creationCode.append("(symbols);");
        this.content.codeln(1, creationCode.toString());
        this.content.codeln(0, "}");
        this.content.codeln(0, "return root;");
        this.content.endMethod("getRoot");
        this.content.endClass(programName);
        this.generateImports();
        this.content.endFile(programName + ".java");
    }

    private void generateProgramMetaInformations(Program program) {
        this.getDependencyManager().getShortName("java.util.Map");
        this.getDependencyManager().getShortName("java.util.HashMap");
        this.getDependencyManager().getShortName("java.util.Collections");
        this.content.beginMethod(4, "Map<String, String>", "getMetaInformations", null, new Java.Parameter[0]);
        this.content.codeln(0, "return Collections.emptyMap();");
        this.content.endMethod("getMetaInformations");
        if (program.getRoot() == null) {
            throw new RuntimeException("Fiacre programs without root cannot be explored\n");
        }
        LinkedHashMap<String, Integer> ioQueuesSizeMap = new LinkedHashMap<String, Integer>();
        for (LocalVariable localVariable : program.getRoot().getVarList()) {
            Type type = localVariable.getType();
            if (!ProgramGenerator.isQueue(type)) continue;
            ioQueuesSizeMap.put(localVariable.getName(), ProgramGenerator.queueSize(type));
        }
        this.content.beginAttribute(1, "Map<String, Integer>", "ioQueueSizeMap");
        this.content.endAttribute("ioQueueSizeMap");
        this.content.beginMethod(4, "int", "getIoQueueSize", null, new Java.Parameter[]{new Java.Parameter(0, "String", "name")});
        this.content.codeln(0, "if ( ioQueueSizeMap == null ) {");
        this.content.codeln(1, "ioQueueSizeMap = new HashMap<String, Integer>();");
        for (Map.Entry entry : ioQueuesSizeMap.entrySet()) {
            this.content.codeln(1, "ioQueueSizeMap.put(\"" + (String)entry.getKey() + "\", " + entry.getValue() + " );");
        }
        this.content.codeln(0, "}");
        this.content.codeln(0, "Integer size = ioQueueSizeMap.get(name);");
        this.content.codeln(0, "if ( size == null ) {");
        this.content.codeln(1, "throw new IllegalArgumentException(\"Queue named '\"+ name +\"' doesn't exists.\");");
        this.content.codeln(0, "}");
        this.content.codeln(0, "return size.intValue();");
        this.content.endMethod("getIoQueueSize");
    }

    private void generateConstant(ConstantDecl constantDecl) {
        String name = NameUtil.capName(constantDecl.getName());
        this.content.beginAttribute(28, TypeUtil.toJavaDeclaration(constantDecl.getType(), this.getTypeNames()), name);
        CExisting cExisting = new CExisting(constantDecl.getType());
        this.content.code(this.expressionGenerator.generateForBehavior(cExisting, constantDecl.getValue()));
        this.content.endAttribute(name);
    }

    private void generateFunction(FunctionDecl functionDecl) {
        String name = NameUtil.uncapName(functionDecl.getName());
        String returnType = TypeUtil.toJavaDeclaration(functionDecl.getReturnType(), this.getTypeNames());
        Java.Parameter[] parameters = new Java.Parameter[functionDecl.getArgCount()];
        for (int i = 0; i < functionDecl.getArgCount(); ++i) {
            ArgumentVariable argument = functionDecl.getArg(i);
            String paramType = TypeUtil.toJavaDeclaration(argument.getType(), this.getTypeNames());
            parameters[i] = new Java.Parameter(0, paramType, NameUtil.uncapName(argument.getName()));
        }
        this.content.beginMethod(12, returnType, name, null, parameters);
        for (LocalVariable variable : functionDecl.getVarList()) {
            String variableName = NameUtil.uncapName(variable.getName());
            String variableType = TypeUtil.toJavaDeclaration(variable.getType(), this.getTypeNames());
            StringBuilder line = new StringBuilder();
            line.append(variableType);
            line.append(" ");
            line.append(variableName);
            if (variable.getInitializer() != null) {
                CExisting cType = new CExisting(variable.getType());
                String init = this.getExpressionGenerator().generateForFunction(cType, variable.getInitializer());
                line.append(" = ");
                line.append(init);
            }
            line.append(";");
            this.content.codeln(0, line.toString());
        }
        CExisting returnCType = new CExisting(functionDecl.getReturnType());
        this.getStatementGenerator().generateForFunction(0, functionDecl.getBody(), returnCType);
        this.content.endMethod(name);
    }

    private void generateExternalFunction(ExternalFunctionDecl functionDecl) {
        int i;
        ExternalArgument argument;
        int i2;
        String name = NameUtil.uncapName(functionDecl.getName());
        String returnType = TypeUtil.toJavaDeclaration(functionDecl.getReturnType(), this.getTypeNames());
        this.hasNativeCode = true;
        String fPClassName = NameUtil.capName(functionDecl.getName()) + "Params";
        this.content.beginClass(0, fPClassName, "Object", null);
        this.content.beginAttribute(4, "java.lang.reflect.Type[]", "types");
        this.content.code(" {");
        for (i2 = 0; i2 < functionDecl.getArgCount(); ++i2) {
            argument = functionDecl.getArg(i2);
            String paramType = TypeUtil.toJavaDeclaration(argument.getType(), this.getTypeNames());
            this.content.code(paramType + ".class, ");
        }
        this.content.code(returnType + ".class ");
        this.content.code("}");
        this.content.endAttribute("types");
        this.content.beginAttribute(4, "int[]", "directions");
        this.content.code(" {");
        for (i2 = 0; i2 < functionDecl.getArgCount(); ++i2) {
            argument = functionDecl.getArg(i2);
            if (argument.isRead() && argument.isWrite()) {
                this.content.code("2,");
                continue;
            }
            if (argument.isWrite()) {
                this.content.code("1, ");
                continue;
            }
            this.content.code("0, ");
        }
        this.content.code("}");
        this.content.endAttribute("directions");
        Java.Parameter[] parameters = new Java.Parameter[functionDecl.getArgCount()];
        for (i = 0; i < functionDecl.getArgCount(); ++i) {
            ExternalArgument argument2 = functionDecl.getArg(i);
            String paramType = TypeUtil.toJavaDeclaration(argument2.getType(), this.getTypeNames());
            parameters[i] = new Java.Parameter(0, paramType, "arg" + i);
            this.content.beginAttribute(4, paramType, "arg" + i);
            this.content.endAttribute("arg" + i);
        }
        this.content.beginAttribute(4, returnType, "returnArg");
        this.content.endAttribute("returnArg");
        this.content.beginMethod(4, null, fPClassName, null, parameters);
        for (i = 0; i < functionDecl.getArgCount(); ++i) {
            this.content.codeln(0, "this.arg" + i + " = arg" + i + ";");
        }
        this.content.endMethod(fPClassName);
        this.content.beginMethod(4, "String", "toString", null, new Java.Parameter[0]);
        this.content.codeln(0, "String s = \"\";");
        for (i = 0; i < functionDecl.getArgCount(); ++i) {
            if (TypeUtil.isArrayType(functionDecl.getArg(i).getType())) {
                this.content.codeln(0, "s +=\" arg" + i + ":\"+ Arrays.toString(arg" + i + ");");
                continue;
            }
            this.content.codeln(0, "s +=\" arg" + i + ":\"+ arg" + i + ";");
        }
        this.content.codeln(0, "return s;");
        this.content.endMethod("toString");
        this.content.endClass(fPClassName);
        parameters = new Java.Parameter[]{new Java.Parameter(0, fPClassName, "arg")};
        this.content.codeln(0, "private native static " + returnType + " prim" + functionDecl.getName() + "(" + fPClassName + " arg);");
        this.content.beginMethod(12, returnType, name, null, parameters);
        this.content.codeln(0, returnType + " res = prim" + functionDecl.getName() + "(arg);");
        this.content.codeln(0, "return res;");
        this.content.endMethod(name);
    }

    public static String getComponentName(NodeDecl node) {
        if (node instanceof ComponentDecl) {
            return ProgramGenerator.getCompositionName((ComponentDecl)node);
        }
        return ProgramGenerator.getBehaviorName(node);
    }

    public static String getCompositionName(ComponentDecl node) {
        return NameUtil.capName(node.getName()) + "Composition";
    }

    public static String getBehaviorName(NodeDecl node) {
        return NameUtil.capName(node.getName()) + "Behavior";
    }

    public static String getConfigurationName(NodeDecl node) {
        return NameUtil.capName(node.getName()) + "Configuration";
    }

    public static char levelIterVariableName(int level) {
        return (char)(105 + level);
    }

    public static String getProgramQualifiedName(String basePackage, String name) {
        StringBuilder rootName = new StringBuilder();
        if (basePackage != null) {
            rootName.append(basePackage);
            rootName.append(".");
        }
        rootName.append(ProgramGenerator.packageName(name));
        rootName.append(".");
        rootName.append(ProgramGenerator.programName(name));
        return rootName.toString();
    }

    private static String programName(String name) {
        return NameUtil.capName(name) + "Root";
    }

    private static String packageName(String name) {
        return NameUtil.lowercaseName(name);
    }

    private static boolean isQueue(Type type) {
        if (type instanceof TypeId) {
            return ProgramGenerator.isQueue(((TypeId)type).getDecl().getIs());
        }
        return type instanceof Queue;
    }

    private static int queueSize(Type type) {
        if (type instanceof TypeId) {
            return ProgramGenerator.queueSize(((TypeId)type).getDecl().getIs());
        }
        if (type instanceof Queue) {
            return TypeUtil.computeArraySizeExpression(((Queue)type).getSize());
        }
        throw new IllegalArgumentException("Internal error, shouldn't be happening, contact OBP team.");
    }
}

