/*
 * Decompiled with CFR 0.152.
 */
package c.printer;

import c.model.ArgumentDeclaration;
import c.model.ArrayType;
import c.model.AssignmentStmt;
import c.model.BinaryExpression;
import c.model.Block;
import c.model.BooleanLiteral;
import c.model.BooleanType;
import c.model.CastExpression;
import c.model.CharType;
import c.model.CompilationUnit;
import c.model.Declaration;
import c.model.EnumerationType;
import c.model.Expression;
import c.model.ExternalType;
import c.model.Field;
import c.model.ForStmt;
import c.model.FunctionCall;
import c.model.FunctionDeclaration;
import c.model.IfStmt;
import c.model.IncludeDeclaration;
import c.model.IndexedExpression;
import c.model.IntegerLiteral;
import c.model.IntegerType;
import c.model.MacroCallStmt;
import c.model.MacroDeclaration;
import c.model.Node;
import c.model.NullLiteral;
import c.model.PointerType;
import c.model.ReturnStmt;
import c.model.SizeOf;
import c.model.Statement;
import c.model.StatementGroup;
import c.model.StringLiteral;
import c.model.StructureDereference;
import c.model.StructureReference;
import c.model.StructureType;
import c.model.Type;
import c.model.TypefDeclaration;
import c.model.UnaryExpression;
import c.model.UnionType;
import c.model.VariableDeclaration;
import c.model.VariableReference;
import c.model.VoidPointerType;
import c.model.VoidType;
import c.model.WhileStmt;
import c.model.util.ModelSwitch;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public class CPrinter {
    private StringBuilder sB;
    private Map<Object, String> visited;
    private int indentation = 0;
    ModelSwitch<String> modelSwitch = new ModelSwitch<String>(){

        @Override
        public String caseCharType(CharType object) {
            String v = (String)CPrinter.this.visited.get(object);
            if (v != null) {
                return v;
            }
            String name = "char";
            CPrinter.this.visited.put(object, name);
            return name;
        }

        @Override
        public String caseExternalType(ExternalType object) {
            String v = (String)CPrinter.this.visited.get(object);
            if (v != null) {
                return v;
            }
            String name = object.getName();
            CPrinter.this.visited.put(object, name);
            return name;
        }

        @Override
        public String caseBooleanType(BooleanType object) {
            String v = (String)CPrinter.this.visited.get(object);
            if (v != null) {
                return v;
            }
            String name = "_Bool";
            CPrinter.this.visited.put(object, name);
            return name;
        }

        @Override
        public String caseIntegerType(IntegerType object) {
            String v = (String)CPrinter.this.visited.get(object);
            if (v != null) {
                return v;
            }
            String name = "int";
            CPrinter.this.visited.put(object, name);
            return name;
        }

        @Override
        public String caseEnumerationType(EnumerationType object) {
            String v = (String)CPrinter.this.visited.get(object);
            if (v != null) {
                return v;
            }
            String name = object.getName() == null ? null : "enum " + object.getName();
            String content = "enum " + object.getName() == null ? "" : object.getName() + "{\n";
            int i = 1;
            Map<String, BigInteger> items = object.getItems();
            for (Map.Entry<String, BigInteger> s2i : items.entrySet()) {
                content = content + CPrinter.this.tabs() + s2i.getKey() + " = " + s2i.getValue();
                if (i < items.size()) {
                    content = content + ",\n";
                }
                ++i;
            }
            content = content + "\n}";
            if (name != null) {
                CPrinter.this.append(content);
            } else {
                name = content;
            }
            CPrinter.this.visited.put(object, name);
            return name;
        }

        @Override
        public String casePointerType(PointerType object) {
            String v = (String)CPrinter.this.visited.get(object);
            if (v != null) {
                return v;
            }
            String name = (String)this.doSwitch(object.getPointee()) + "*";
            CPrinter.this.visited.put(object, name);
            return name;
        }

        @Override
        public String caseVoidType(VoidType object) {
            String v = (String)CPrinter.this.visited.get(object);
            if (v != null) {
                return v;
            }
            String name = "void";
            CPrinter.this.visited.put(object, name);
            return name;
        }

        @Override
        public String caseVoidPointerType(VoidPointerType object) {
            String v = (String)CPrinter.this.visited.get(object);
            if (v != null) {
                return v;
            }
            String name = "void *";
            CPrinter.this.visited.put(object, name);
            return name;
        }

        @Override
        public String caseArrayType(ArrayType object) {
            String v = (String)CPrinter.this.visited.get(object);
            if (v != null) {
                return v;
            }
            String name = (String)this.doSwitch(object.getElementType()) + "*";
            CPrinter.this.visited.put(object, name);
            return name;
        }

        @Override
        public String caseField(Field object) {
            return (String)this.doSwitch(object.getType()) + " " + object.getName();
        }

        @Override
        public String caseStructureType(StructureType object) {
            String name;
            String v = (String)CPrinter.this.visited.get(object);
            if (v != null) {
                return v;
            }
            String content = "struct " + (object.getName() == null ? "" : object.getName()) + " {\n";
            CPrinter.this.tab();
            Map<String, Field> fields = object.getFields();
            ArrayList<Field> sorted = new ArrayList<Field>(fields.values());
            Collections.sort(sorted, new Comparator<Field>(){

                @Override
                public int compare(Field o1, Field o2) {
                    return o1.getPosition().compareTo(o2.getPosition());
                }
            });
            for (Field s2f : sorted) {
                content = content + CPrinter.this.tabs() + (String)this.doSwitch(s2f) + ";\n";
            }
            CPrinter.this.untab();
            content = content + CPrinter.this.tabs() + "}";
            if (object.getName() != null) {
                CPrinter.this.append(content);
                name = "struct " + object.getName();
            } else {
                name = content;
            }
            CPrinter.this.visited.put(object, name);
            return name;
        }

        @Override
        public String caseUnionType(UnionType object) {
            String name;
            String v = (String)CPrinter.this.visited.get(object);
            if (v != null) {
                return v;
            }
            String content = "union " + (object.getName() == null ? "" : object.getName()) + " {\n";
            Map<String, Field> fields = object.getFields();
            for (Map.Entry<String, Field> s2f : fields.entrySet()) {
                content = content + CPrinter.this.tabs() + (String)this.doSwitch(s2f.getValue()) + ";\n";
            }
            content = content + "}";
            if (object.getName() != null) {
                CPrinter.this.append(content);
                name = "union " + object.getName();
            } else {
                name = content;
            }
            CPrinter.this.visited.put(object, name);
            return name;
        }

        @Override
        public String caseTypefDeclaration(TypefDeclaration object) {
            String v = (String)CPrinter.this.visited.get(object);
            if (v != null) {
                return v;
            }
            String type = (String)this.doSwitch(object.getType());
            CPrinter.this.append(CPrinter.this.tabs() + "typedef " + type + " " + object.getName() + ";\n");
            CPrinter.this.visited.put(object, object.getName());
            return object.getName();
        }

        @Override
        public String caseVariableDeclaration(VariableDeclaration object) {
            String v = (String)CPrinter.this.visited.get(object);
            if (v != null) {
                return v;
            }
            String vDeclS = "";
            if (object.getType() != null) {
                vDeclS = vDeclS + (String)this.doSwitch(object.getType()) + " " + object.getName();
                if (object.getArraySize() != null) {
                    vDeclS = vDeclS + "[" + (String)this.doSwitch(object.getArraySize()) + "]";
                }
                if (object.getInitialValue() != null) {
                    vDeclS = vDeclS + "=";
                    vDeclS = vDeclS + (String)this.doSwitch(object.getInitialValue());
                }
            }
            CPrinter.this.visited.put(object, object.getName());
            return vDeclS;
        }

        @Override
        public String caseArgumentDeclaration(ArgumentDeclaration object) {
            String v = (String)CPrinter.this.visited.get(object);
            if (v != null) {
                return v;
            }
            CPrinter.this.append((String)this.doSwitch(object.getType()) + " " + object.getName());
            CPrinter.this.visited.put(object, object.getName());
            return object.getName();
        }

        @Override
        public String caseFunctionDeclaration(FunctionDeclaration object) {
            String v = (String)CPrinter.this.visited.get(object);
            if (v != null) {
                return v;
            }
            CPrinter.this.append(object.getBeforeReturn() + " ");
            Type returnType = object.getType();
            String rType = "void";
            if (returnType != null) {
                rType = (String)this.doSwitch(object.getType());
            }
            CPrinter.this.append(rType + " " + object.getAfterReturn() + " " + object.getName() + "(");
            List<ArgumentDeclaration> args = object.getArguments();
            int i = 1;
            for (ArgumentDeclaration arg : args) {
                this.doSwitch(arg);
                if (i < args.size()) {
                    CPrinter.this.append(", ");
                }
                ++i;
            }
            CPrinter.this.append(") {\n");
            CPrinter.this.tab();
            List<Statement> body = object.getBody();
            for (Statement stm : body) {
                CPrinter.this.append((String)this.doSwitch(stm));
                if (stm.eClass().getClassifierID() == 40) continue;
                CPrinter.this.append(";\n");
            }
            CPrinter.this.untab();
            CPrinter.this.append("}\n");
            CPrinter.this.visited.put(object, object.getName());
            return object.getName();
        }

        @Override
        public String caseMacroDeclaration(MacroDeclaration object) {
            String v = (String)CPrinter.this.visited.get(object);
            if (v != null) {
                return v;
            }
            CPrinter.this.append("#define " + object.getName());
            List<String> args = object.getArguments();
            int i = 0;
            for (String s : object.getArguments()) {
                CPrinter.this.append(s);
                if (i < args.size()) {
                    CPrinter.this.append(",");
                }
                ++i;
            }
            CPrinter.this.append(" " + object.getBody());
            CPrinter.this.visited.put(object, object.getName());
            return object.getName();
        }

        @Override
        public String caseCompilationUnit(CompilationUnit object) {
            for (Declaration decl : object.getDeclarations()) {
                if (decl instanceof VariableDeclaration) {
                    CPrinter.this.append((String)this.doSwitch(decl) + ";\n");
                    continue;
                }
                this.doSwitch(decl);
            }
            return "";
        }

        @Override
        public String caseIntegerLiteral(IntegerLiteral object) {
            return object.getValue().toString();
        }

        @Override
        public String caseBooleanLiteral(BooleanLiteral object) {
            return object.isValue() ? "true" : "false";
        }

        @Override
        public String caseFunctionCall(FunctionCall object) {
            String v = (String)CPrinter.this.visited.get(object);
            if (v != null) {
                return v;
            }
            String call = "";
            call = object.getName() != null ? call + object.getName() : (object.getFunctionExp() != null ? call + (String)this.doSwitch(object.getFunctionExp()) : (object.getCalledFunction() != null ? call + object.getCalledFunction().getName() : call + "missing_func"));
            call = call + "(";
            List<Expression> args = object.getArguments();
            int i = 1;
            for (Expression exp : args) {
                call = call + (String)this.doSwitch(exp);
                if (i < args.size()) {
                    call = call + ", ";
                }
                ++i;
            }
            call = call + ")";
            if (object.getComment().size() > 0) {
                call = call + "/* " + object.getComment() + "*/";
            }
            CPrinter.this.visited.put(object, call);
            return call;
        }

        @Override
        public String caseUnaryExpression(UnaryExpression object) {
            String exp = "(";
            switch (object.getOperator()) {
                case PLUS: {
                    exp = exp + "+";
                    break;
                }
                case ADDRESS: {
                    exp = exp + "&";
                    break;
                }
                case DEREFERENCE: {
                    exp = exp + "*";
                    break;
                }
                case MINUS: {
                    exp = exp + "-";
                    break;
                }
                case NEGATE: {
                    exp = exp + "!";
                }
            }
            return exp + (String)this.doSwitch(object.getOperand()) + ")";
        }

        @Override
        public String caseBinaryExpression(BinaryExpression object) {
            List<Expression> operands = object.getOperands();
            String exp = (String)this.doSwitch(operands.get(0)) + " ";
            switch (object.getOperator()) {
                case PLUS: {
                    exp = exp + "+";
                    break;
                }
                case BAND: {
                    exp = exp + "&";
                    break;
                }
                case BOR: {
                    exp = exp + "|";
                    break;
                }
                case BXOR: {
                    exp = exp + "^";
                    break;
                }
                case DIV: {
                    exp = exp + "/";
                    break;
                }
                case EQ: {
                    exp = exp + "==";
                    break;
                }
                case GEQ: {
                    exp = exp + ">=";
                    break;
                }
                case GT: {
                    exp = exp + ">";
                    break;
                }
                case LAND: {
                    exp = exp + "&&";
                    break;
                }
                case LEQ: {
                    exp = exp + "<=";
                    break;
                }
                case LOR: {
                    exp = exp + "||";
                    break;
                }
                case LSHIFT: {
                    exp = exp + "<<";
                    break;
                }
                case LT: {
                    exp = exp + "<";
                    break;
                }
                case MINUS: {
                    exp = exp + "-";
                    break;
                }
                case MOD: {
                    exp = exp + "%";
                    break;
                }
                case MULT: {
                    exp = exp + "*";
                    break;
                }
                case NEQ: {
                    exp = exp + "!=";
                    break;
                }
                case RSHIFT: {
                    exp = exp + ">>";
                }
            }
            return exp + " " + (String)this.doSwitch(operands.get(1));
        }

        @Override
        public String caseIndexedExpression(IndexedExpression object) {
            return (String)this.doSwitch(object.getBase()) + "[" + (String)this.doSwitch(object.getIndex()) + "]";
        }

        @Override
        public String caseStructureDereference(StructureDereference object) {
            return (String)this.doSwitch(object.getBase()) + "->" + object.getMember();
        }

        @Override
        public String caseStructureReference(StructureReference object) {
            return (String)this.doSwitch(object.getBase()) + "." + object.getMember();
        }

        @Override
        public String caseCastExpression(CastExpression object) {
            return "((" + (String)this.doSwitch(object.getType()) + ")" + (String)this.doSwitch(object.getExpression()) + ")";
        }

        @Override
        public String caseBlock(Block object) {
            String v = (String)CPrinter.this.visited.get(object);
            if (v != null) {
                return v;
            }
            String blockS = "{\n";
            CPrinter.this.tab();
            List<Statement> stmts = object.getStatements();
            for (Statement stm : stmts) {
                blockS = blockS + CPrinter.this.tabs() + (String)this.doSwitch(stm) + ";\n";
            }
            CPrinter.this.untab();
            blockS = blockS + CPrinter.this.tabs() + "}\n";
            CPrinter.this.visited.put(object, blockS);
            return blockS;
        }

        @Override
        public String caseStatementGroup(StatementGroup object) {
            String v = (String)CPrinter.this.visited.get(object);
            if (v != null) {
                return v;
            }
            String blockS = CPrinter.this.tabs() + "//group " + object.getComment().toString() + "\n";
            List<Statement> stmts = object.getStatements();
            for (Statement stm : stmts) {
                blockS = blockS + CPrinter.this.tabs() + (String)this.doSwitch(stm) + ";\n";
            }
            blockS = blockS + CPrinter.this.tabs() + "//end group\n";
            CPrinter.this.visited.put(object, blockS);
            return blockS;
        }

        @Override
        public String caseAssignmentStmt(AssignmentStmt object) {
            return (String)this.doSwitch(object.getL_value()) + " = " + (String)this.doSwitch(object.getR_value());
        }

        @Override
        public String caseIfStmt(IfStmt object) {
            String ifS = "if (" + (String)this.doSwitch(object.getCondition()) + ") {\n";
            CPrinter.this.tab();
            for (Statement stm : object.getTrueBranch()) {
                ifS = ifS + (String)this.doSwitch(stm) + ";\n";
            }
            CPrinter.this.untab();
            ifS = ifS + CPrinter.this.tabs() + "} else {\n";
            CPrinter.this.tab();
            for (Statement stm : object.getFalseBranch()) {
                ifS = ifS + (String)this.doSwitch(stm) + ";\n";
            }
            CPrinter.this.untab();
            ifS = ifS + CPrinter.this.tabs() + "}\n";
            return ifS;
        }

        @Override
        public String caseWhileStmt(WhileStmt object) {
            String whileS = CPrinter.this.tabs() + "while (" + (String)this.doSwitch(object.getCondition()) + ") {\n";
            CPrinter.this.tab();
            for (Statement stm : object.getBody()) {
                whileS = whileS + (String)this.doSwitch(stm) + ";\n";
            }
            CPrinter.this.untab();
            return whileS + CPrinter.this.tabs() + "}\n";
        }

        @Override
        public String caseForStmt(ForStmt object) {
            String forS = "for (" + (String)this.doSwitch(object.getInitial()) + "; ";
            forS = forS + (String)this.doSwitch(object.getCondition()) + "; ";
            forS = forS + (String)this.doSwitch(object.getStep()) + ") {\n";
            CPrinter.this.tab();
            for (Statement stm : object.getBody()) {
                forS = forS + (String)this.doSwitch(stm) + ";\n";
            }
            CPrinter.this.untab();
            forS = forS + CPrinter.this.tabs() + "}\n";
            return forS;
        }

        @Override
        public String caseMacroCallStmt(MacroCallStmt object) {
            String mS = CPrinter.this.tabs() + object.getName();
            List<Expression> args = object.getArguments();
            if (args.size() < 1) {
                return "";
            }
            mS = mS + "(";
            int i = 1;
            for (Expression exp : args) {
                mS = mS + (String)this.doSwitch(exp);
                if (i < args.size()) {
                    mS = mS + ",";
                }
                ++i;
            }
            return mS + ")";
        }

        @Override
        public String caseReturnStmt(ReturnStmt object) {
            return CPrinter.this.tabs() + "return " + (String)this.doSwitch(object.getExpression());
        }

        @Override
        public String caseIncludeDeclaration(IncludeDeclaration object) {
            CPrinter.this.append(CPrinter.this.tabs() + "#include " + object.getData() + "\n");
            return "";
        }

        @Override
        public String caseVariableReference(VariableReference object) {
            String v = (String)CPrinter.this.visited.get(object);
            if (v != null) {
                return v;
            }
            String name = object.getRefersTo() == null ? object.getName() : (String)this.doSwitch(object.getRefersTo());
            if (name == null) {
                System.err.println("Missing variable declaration");
                return "";
            }
            CPrinter.this.visited.put(object, name);
            return name;
        }

        @Override
        public String caseNullLiteral(NullLiteral object) {
            return "NULL";
        }

        @Override
        public String caseStringLiteral(StringLiteral object) {
            return "\"" + object.getValue() + "\"";
        }

        @Override
        public String caseSizeOf(SizeOf object) {
            return "sizeof(" + (String)this.doSwitch(object.getType()) + ")";
        }

        @Override
        public String defaultCase(EObject object) {
            System.err.println("Missing case for " + object.getClass().getName());
            return null;
        }
    };

    public String emit(Node node) {
        this.sB = new StringBuilder();
        this.visited = new HashMap<Object, String>();
        this.modelSwitch.doSwitch(node);
        return this.sB.toString();
    }

    private CPrinter append(String toAppend) {
        this.sB.append(toAppend);
        return this;
    }

    private String tabs() {
        String s = "";
        for (int i = 0; i < this.indentation; ++i) {
            s = s + "\t";
        }
        return s;
    }

    private CPrinter tab() {
        ++this.indentation;
        return this;
    }

    private CPrinter untab() {
        --this.indentation;
        return this;
    }
}

