/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.sexp.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xid.basics.sexp.S;
import org.xid.basics.sexp.SAtom;
import org.xid.basics.sexp.model.Referencer;

public class ModelToSExp {
    private final Referencer referencer;
    private final ContextNode contextRoot;
    private ContextNode contextCurrent;

    public ModelToSExp(Referencer referencer) {
        this.contextCurrent = this.contextRoot = new ContextNode(null);
        this.referencer = referencer;
        this.registerBuiltins();
    }

    private void registerBuiltins() {
        for (Map.Entry<String, Object> entry : this.referencer.builtins().entrySet()) {
            this.register(entry.getKey(), entry.getValue());
        }
    }

    private void register(String reference, Object object) {
        this.contextCurrent.objectIndex.put(object, reference);
        this.contextCurrent.existingReference.add(reference);
    }

    private String resolve(Object referenced) {
        ContextNode iterator = this.contextCurrent;
        while (iterator != null) {
            LinkedHashMap<Object, String> current = iterator.objectIndex;
            String reference = current.get(referenced);
            if (reference != null) {
                return reference;
            }
            iterator = iterator.parent;
        }
        return null;
    }

    private void pushReferenceContext() {
        ContextNode contextNew;
        this.contextCurrent = contextNew = new ContextNode(this.contextCurrent);
    }

    private void popReferenceContext() {
        this.contextCurrent = this.contextCurrent.parent;
    }

    private String uniqueReference(String reference) {
        HashSet<String> current = this.contextCurrent.existingReference;
        while (current.contains(reference)) {
            reference = reference + "_";
        }
        return reference;
    }

    public void push(Object object) {
        String reference = this.referencer.referenceFor(object);
        reference = this.uniqueReference(reference);
        this.register(reference, object);
        ArrayList<SAtom> toResolveList = new ArrayList<SAtom>();
        this.contextCurrent.collectPendingReferencesFor(object, toResolveList);
        for (SAtom atom : toResolveList) {
            atom.setValue(reference);
        }
        if (this.referencer.pushContext(object)) {
            this.pushReferenceContext();
        }
    }

    public void pop(Object object) {
        if (this.referencer.popContext(object)) {
            this.popReferenceContext();
        }
    }

    public SAtom createReference(Object referenced) {
        if (referenced == null) {
            return S.snullatom();
        }
        SAtom atom = new SAtom();
        String reference = this.resolve(referenced);
        if (reference != null) {
            atom.setValue(reference);
        } else {
            this.contextCurrent.registerPendingReference(referenced, atom);
        }
        return atom;
    }

    public Set<Object> missingObjects() {
        return this.contextRoot.missingObjects();
    }

    private class ContextNode {
        final LinkedHashMap<Object, String> objectIndex = new LinkedHashMap();
        final HashSet<String> existingReference = new HashSet();
        final LinkedHashMap<Object, List<SAtom>> pendingReferenceMap = new LinkedHashMap();
        final ContextNode parent;
        ArrayList<ContextNode> children;

        ContextNode(ContextNode parent) {
            this.parent = parent;
            if (parent != null) {
                parent.addChild(this);
            }
        }

        void addChild(ContextNode child) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(child);
        }

        void registerPendingReference(Object referenced, SAtom atom) {
            List<SAtom> toResolveList = this.pendingReferenceMap.get(referenced);
            if (toResolveList == null) {
                toResolveList = new ArrayList<SAtom>();
                this.pendingReferenceMap.put(referenced, toResolveList);
            }
            toResolveList.add(atom);
        }

        void collectPendingReferencesFor(Object object, List<SAtom> result) {
            List<SAtom> pendings = this.pendingReferenceMap.get(object);
            if (pendings != null) {
                result.addAll(pendings);
                this.pendingReferenceMap.remove(object);
            }
            if (this.children != null) {
                for (ContextNode child : this.children) {
                    child.collectPendingReferencesFor(object, result);
                }
            }
        }

        Set<Object> missingObjects() {
            HashSet<Object> missing = new HashSet<Object>(this.pendingReferenceMap.keySet());
            if (this.children != null) {
                for (ContextNode child : this.children) {
                    missing.addAll(child.missingObjects());
                }
            }
            return missing;
        }
    }
}

