/*
 * Decompiled with CFR 0.152.
 */
package properties.LTL.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import properties.LTL.LTLModel.Eventually;
import properties.LTL.LTLModel.Globally;
import properties.LTL.LTLModel.LTLModelFactory;
import properties.LTL.LTLModel.Next;
import properties.LTL.LTLModel.StrongRelease;
import properties.LTL.LTLModel.StrongUntil;
import properties.LTL.LTLModel.WeakRelease;
import properties.LTL.LTLModel.WeakUntil;
import properties.LTL.grammar.LTLBaseListener;
import properties.LTL.grammar.LTLParser;
import properties.PropositionalLogic.PropositionalLogicModel.Atom;
import properties.PropositionalLogic.PropositionalLogicModel.DeclarationBlock;
import properties.PropositionalLogic.PropositionalLogicModel.Expression;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionDeclaration;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionReference;
import properties.PropositionalLogic.PropositionalLogicModel.LetExpression;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalConjunction;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalDisjunction;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalEquivalence;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalImplication;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalNegation;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalXOR;
import properties.PropositionalLogic.PropositionalLogicModel.PropositionalLogicModelFactory;
import properties.PropositionalLogic.parser.TreeAnnotator;

public class ASTBuilder
extends LTLBaseListener
implements TreeAnnotator {
    public ParseTreeProperty<Object> values = new ParseTreeProperty();
    PropositionalLogicModelFactory factory = PropositionalLogicModelFactory.eINSTANCE;
    LTLModelFactory ltlFactory = LTLModelFactory.eINSTANCE;

    public ParseTreeProperty<Object> getValues() {
        return this.values;
    }

    @Override
    public void exitLiteral(LTLParser.LiteralContext ctx) {
        this.setValue((ParseTree)ctx, ctx.TRUE() == null ? this.factory.createFalse() : this.factory.createTrue());
    }

    @Override
    public void exitAtom(LTLParser.AtomContext ctx) {
        Atom atom = this.factory.createAtom();
        String language = ctx.IDENTIFIER() != null ? ctx.IDENTIFIER().getText() : null;
        atom.setLanguage(language);
        String code = ctx.ATOMINLINE().getText();
        atom.setCode(code.substring(1, code.length() - 1));
        atom.setDelimiterString(code.substring(0, 1));
        this.setValue((ParseTree)ctx, atom);
    }

    @Override
    public void exitParenExp(LTLParser.ParenExpContext ctx) {
        this.setValue((ParseTree)ctx, this.getValue((ParseTree)ctx.formula()));
    }

    @Override
    public void exitUnaryExp(LTLParser.UnaryExpContext ctx) {
        switch (ctx.operator.getType()) {
            case 10: {
                LogicalNegation value = this.factory.createLogicalNegation();
                value.setOperatorToken(ctx.operator.getText());
                value.setOperand((Expression)this.getValue((ParseTree)ctx.formula(), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 11: {
                Next value = this.ltlFactory.createNext();
                value.setOperatorToken(ctx.operator.getText());
                value.setOperand((Expression)this.getValue((ParseTree)ctx.formula(), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 4: {
                Eventually value = this.ltlFactory.createEventually();
                value.setOperatorToken(ctx.operator.getText());
                value.setOperand((Expression)this.getValue((ParseTree)ctx.formula(), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 6: {
                Globally value = this.ltlFactory.createGlobally();
                value.setOperatorToken(ctx.operator.getText());
                value.setOperand((Expression)this.getValue((ParseTree)ctx.formula(), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
        }
    }

    @Override
    public void exitBinaryExp(LTLParser.BinaryExpContext ctx) {
        switch (ctx.operator.getType()) {
            case 1: {
                LogicalConjunction value = this.factory.createLogicalConjunction();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 2: {
                LogicalDisjunction value = this.factory.createLogicalDisjunction();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 17: {
                LogicalXOR value = this.factory.createLogicalXOR();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 7: {
                LogicalImplication value = this.factory.createLogicalImplication();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 3: {
                LogicalEquivalence value = this.factory.createLogicalEquivalence();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 12: {
                StrongUntil value = this.ltlFactory.createStrongUntil();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 13: {
                WeakUntil value = this.ltlFactory.createWeakUntil();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 14: {
                StrongRelease value = this.ltlFactory.createStrongRelease();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 15: {
                WeakRelease value = this.ltlFactory.createWeakRelease();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
        }
        throw new RuntimeException("unexpected binary operator: " + ctx.operator.getText() + " (line: " + ctx.getStart().getLine() + ")\n");
    }

    @Override
    public void exitFormulaDeclaration(LTLParser.FormulaDeclarationContext ctx) {
        ExpressionDeclaration value = this.factory.createExpressionDeclaration();
        value.setName(ctx.IDENTIFIER().getText());
        value.setExpression((Expression)this.getValue((ParseTree)ctx.formula(), Expression.class));
        this.setValue((ParseTree)ctx, value);
    }

    @Override
    public void exitFormulaDeclarationList(LTLParser.FormulaDeclarationListContext ctx) {
        ArrayList<Object> value = new ArrayList<Object>();
        for (LTLParser.FormulaDeclarationContext fctx : ctx.formulaDeclaration()) {
            value.add(this.getValue((ParseTree)fctx, ExpressionDeclaration.class));
        }
        this.setValue((ParseTree)ctx, value);
    }

    @Override
    public void exitLetExp(LTLParser.LetExpContext ctx) {
        LetExpression value = this.factory.createLetExpression();
        List declarations = (List)this.getValue((ParseTree)ctx.formulaDeclarationList(), List.class);
        value.getDeclarations().addAll((Collection)declarations);
        value.setExpression((Expression)this.getValue((ParseTree)ctx.formula(), Expression.class));
        this.setValue((ParseTree)ctx, value);
    }

    @Override
    public void exitBlock(LTLParser.BlockContext ctx) {
        DeclarationBlock value = this.factory.createDeclarationBlock();
        for (LTLParser.FormulaDeclarationContext fctx : ctx.formulaDeclaration()) {
            value.getDeclarations().add(this.getValue((ParseTree)fctx, ExpressionDeclaration.class));
        }
        this.setValue((ParseTree)ctx, value);
    }

    @Override
    public void exitAtomExp(LTLParser.AtomExpContext ctx) {
        this.setValue((ParseTree)ctx, this.getValue((ParseTree)ctx.atom()));
    }

    @Override
    public void exitLiteralExp(LTLParser.LiteralExpContext ctx) {
        this.setValue((ParseTree)ctx, this.getValue((ParseTree)ctx.literal()));
    }

    @Override
    public void exitReferenceExp(LTLParser.ReferenceExpContext ctx) {
        ExpressionReference value = this.factory.createExpressionReference();
        value.setName(ctx.IDENTIFIER().getText());
        this.setValue((ParseTree)ctx, value);
    }
}

