/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.sequence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import obp.ui.sequence.LifeLine;
import obp.ui.sequence.SequenceItem;
import org.xid.basics.model.ChangeRecorder;
import org.xid.basics.model.ModelChangeRecorder;
import org.xid.basics.model.ModelObject;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class Sequence
implements BoostObject,
ModelObject {
    private final ModelChangeRecorder changeHandler = new ModelChangeRecorder();
    private final ArrayList<LifeLine> lineList = new ArrayList();
    private final ArrayList<SequenceItem> itemList = new ArrayList();

    private Sequence(Boost boost) {
        this.lineList.addAll(BoostUtil.readObjectList((Boost)boost, LifeLine.class));
        this.lineList.trimToSize();
        this.itemList.addAll(BoostUtil.readObjectList((Boost)boost, SequenceItem.class));
        this.itemList.trimToSize();
    }

    public Sequence() {
    }

    public void addLine(LifeLine line) {
        this.addLine(this.lineList.size(), line);
    }

    public void addLine(int index, LifeLine line) {
        this.getChangeRecorder().recordAddObject((ModelObject)this, "line", index);
        this.lineList.add(index, line);
    }

    public void removeLine(LifeLine line) {
        this.removeLine(this.lineList.indexOf(line));
    }

    public void removeLine(int index) {
        if (index < 0) {
            return;
        }
        LifeLine line = this.lineList.remove(index);
        this.getChangeRecorder().recordRemoveObject((ModelObject)this, "line", index, (Object)line);
    }

    public int getLineCount() {
        return this.lineList.size();
    }

    public List<LifeLine> getLifeLineList() {
        return Collections.unmodifiableList(this.lineList);
    }

    public LifeLine getLifeLine(String name) {
        for (LifeLine line : this.lineList) {
            if (!name.equals(line.getLabel())) continue;
            return line;
        }
        return null;
    }

    public void addItem(SequenceItem item) {
        this.addItem(this.itemList.size(), item);
    }

    public void addItem(int index, SequenceItem item) {
        this.getChangeRecorder().recordAddObject((ModelObject)this, "item", index);
        this.itemList.add(index, item);
    }

    public void removeItem(SequenceItem item) {
        this.removeItem(this.itemList.indexOf(item));
    }

    public void removeItem(int index) {
        if (index < 0) {
            return;
        }
        SequenceItem item = this.itemList.remove(index);
        this.getChangeRecorder().recordRemoveObject((ModelObject)this, "item", index, (Object)item);
    }

    public int getItemCount() {
        return this.itemList.size();
    }

    public List<SequenceItem> getItemList() {
        return Collections.unmodifiableList(this.itemList);
    }

    public ChangeRecorder getChangeRecorder() {
        return this.changeHandler;
    }

    public void writeToBoost(Boost boost) {
        BoostUtil.writeObjectCollection((Boost)boost, this.lineList);
        BoostUtil.writeObjectCollection((Boost)boost, this.itemList);
    }
}

