/*
 * Decompiled with CFR 0.152.
 */
package obp.interpreter.runtime;

import obp.explorer.runtime.obs.InformalAction;
import obp.interpreter.runtime.EventImpl;
import obp.interpreter.runtime.EventUtil;
import obp.interpreter.runtime.ProgramImpl;
import obp.lua.LuaUtil;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaUserdata;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;
import org.luaj.vm2.lib.jse.LuajavaLib;

public class EventsLib
extends LuajavaLib {
    private final ProgramImpl program;
    private final LuaTable eventMetatable;

    protected EventsLib(ProgramImpl program) {
        this.program = program;
        this.eventMetatable = this.createEventMetatable();
    }

    private LuaTable createEventMetatable() {
        LuaTable table = new LuaTable();
        table.set("__index", (LuaValue)new TwoArgFunction(){

            public LuaValue call(LuaValue self, LuaValue field) {
                EventImpl event = (EventImpl)self.checkuserdata(EventImpl.class);
                String fieldName = field.checkjstring();
                if (fieldName.equals("none")) {
                    return LuaValue.valueOf((event == EventImpl.NIL ? 1 : 0) != 0);
                }
                if (fieldName.equals("exists")) {
                    return LuaValue.valueOf((event != EventImpl.NIL ? 1 : 0) != 0);
                }
                if (event == EventImpl.NIL) {
                    return LuaValue.NIL;
                }
                if ("id".equals(fieldName)) {
                    return LuaValue.valueOf((int)event.id);
                }
                if ("destination".equals(fieldName)) {
                    return LuaValue.valueOf((int)event.destinationId);
                }
                if ("value".equals(fieldName)) {
                    return event.value;
                }
                return LuaValue.NIL;
            }
        });
        table.set("__tostring", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue self) {
                EventImpl event = (EventImpl)self.checkuserdata(EventImpl.class);
                return LuaValue.valueOf((String)event.toFancyString(EventsLib.this.program.getSymbols()));
            }
        });
        return table;
    }

    private LuaValue coerce(EventImpl event) {
        if (event == null) {
            return LuaValue.NIL;
        }
        return LuaUserdata.userdataOf((Object)event, (LuaValue)this.eventMetatable);
    }

    public LuaValue call(LuaValue env) {
        LuaTable events = new LuaTable();
        this.count(events);
        this.first(events);
        this.last(events);
        this.add(events);
        this.addFirst(events);
        this.addLast(events);
        this.removeFirst(events);
        this.removeLast(events);
        this.remove(events);
        this.informal(events);
        env.set("events", (LuaValue)events);
        return events;
    }

    private void count(LuaTable events) {
        events.set("count", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                EventImpl[] events = ((EventsLib)EventsLib.this).program.eventStorage.get(((EventsLib)EventsLib.this).program.currentConfiguration);
                return LuaValue.valueOf((int)events.length);
            }
        });
    }

    private void first(LuaTable events) {
        events.set("first", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                EventImpl[] events = ((EventsLib)EventsLib.this).program.eventStorage.get(((EventsLib)EventsLib.this).program.currentConfiguration);
                if (arg.isnil()) {
                    return EventsLib.this.coerce(EventUtil.first(events));
                }
                if (arg.isint()) {
                    return EventsLib.this.coerce(EventUtil.first(events, arg.toshort()));
                }
                throw new IllegalArgumentException("Invalid argument '" + LuaUtil.toString(arg) + "' for 'events.first'.");
            }
        });
    }

    private void last(LuaTable events) {
        events.set("last", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                EventImpl[] events = ((EventsLib)EventsLib.this).program.eventStorage.get(((EventsLib)EventsLib.this).program.currentConfiguration);
                if (arg.isnil()) {
                    return EventsLib.this.coerce(EventUtil.last(events));
                }
                if (arg.isint()) {
                    return EventsLib.this.coerce(EventUtil.last(events, arg.toshort()));
                }
                throw new IllegalArgumentException("Invalid argument '" + LuaUtil.toString(arg) + "' for 'events.first'.");
            }
        });
    }

    private void add(LuaTable events) {
        events.set("add", (LuaValue)new VarArgFunction(){

            public Varargs invoke(Varargs args) {
                LuaValue arg1 = args.arg(1);
                if (!arg1.isint()) {
                    throw new IllegalArgumentException("Invalid index '" + arg1 + "'.");
                }
                LuaValue arg2 = args.arg(2);
                if (!arg2.isint()) {
                    throw new IllegalArgumentException("Invalid event id '" + arg2 + "'.");
                }
                LuaValue arg3 = args.arg(3);
                if (!arg3.isint()) {
                    throw new IllegalArgumentException("Invalid destination id '" + arg3 + "'.");
                }
                LuaValue arg4 = args.arg(4);
                EventImpl value = new EventImpl(arg2.toshort(), arg3.toshort(), arg4);
                EventImpl[] events = ((EventsLib)EventsLib.this).program.eventStorage.get(((EventsLib)EventsLib.this).program.currentConfiguration);
                int index = arg1.toint();
                if (index < 0 || index >= events.length) {
                    throw new IllegalArgumentException("Invalid index '" + index + "' (events length is '" + events.length + "').");
                }
                events = EventUtil.addFirst(events, value);
                ((EventsLib)EventsLib.this).program.eventStorage.set(((EventsLib)EventsLib.this).program.currentConfiguration, events);
                short id = EventsLib.this.program.addInformal("!" + value.toFancyString(EventsLib.this.program.getSymbols()));
                ((EventsLib)EventsLib.this).program.currentActions.add(index, new InformalAction(((EventsLib)EventsLib.this).program.currentBehavior, id));
                return LuaValue.NIL;
            }
        });
    }

    private void addFirst(LuaTable events) {
        events.set("addFirst", (LuaValue)new ThreeArgFunction(){

            public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
                if (!arg1.isint()) {
                    throw new IllegalArgumentException("Invalid event id '" + arg1 + "'.");
                }
                if (!arg2.isint()) {
                    throw new IllegalArgumentException("Invalid destination id '" + arg2 + "'.");
                }
                EventImpl value = new EventImpl(arg1.toshort(), arg2.toshort(), arg3);
                EventImpl[] events = ((EventsLib)EventsLib.this).program.eventStorage.get(((EventsLib)EventsLib.this).program.currentConfiguration);
                events = EventUtil.addFirst(events, value);
                ((EventsLib)EventsLib.this).program.eventStorage.set(((EventsLib)EventsLib.this).program.currentConfiguration, events);
                short id = EventsLib.this.program.addInformal("!" + value.toFancyString(EventsLib.this.program.getSymbols()));
                ((EventsLib)EventsLib.this).program.currentActions.add(new InformalAction(((EventsLib)EventsLib.this).program.currentBehavior, id));
                return LuaValue.NIL;
            }
        });
    }

    private void addLast(LuaTable events) {
        events.set("addLast", (LuaValue)new ThreeArgFunction(){

            public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
                if (!arg1.isint()) {
                    throw new IllegalArgumentException("Invalid event id '" + arg1 + "'.");
                }
                if (!arg2.isint()) {
                    throw new IllegalArgumentException("Invalid destination id '" + arg2 + "'.");
                }
                EventImpl value = new EventImpl(arg1.toshort(), arg2.toshort(), arg3);
                EventImpl[] events = ((EventsLib)EventsLib.this).program.eventStorage.get(((EventsLib)EventsLib.this).program.currentConfiguration);
                events = EventUtil.addLast(events, value);
                ((EventsLib)EventsLib.this).program.eventStorage.set(((EventsLib)EventsLib.this).program.currentConfiguration, events);
                short id = EventsLib.this.program.addInformal("!" + value.toFancyString(EventsLib.this.program.getSymbols()));
                ((EventsLib)EventsLib.this).program.currentActions.add(new InformalAction(((EventsLib)EventsLib.this).program.currentBehavior, id));
                return LuaValue.NIL;
            }
        });
    }

    private void removeFirst(LuaTable events) {
        events.set("removeFirst", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                short id;
                EventImpl value;
                EventImpl[] events = ((EventsLib)EventsLib.this).program.eventStorage.get(((EventsLib)EventsLib.this).program.currentConfiguration);
                if (arg.isnil()) {
                    value = EventUtil.first(events);
                    events = EventUtil.removeFirst(events);
                } else if (arg.isint()) {
                    id = arg.toshort();
                    value = EventUtil.first(events, id);
                    events = EventUtil.removeFirst(events, id);
                } else {
                    throw new IllegalArgumentException("Invalid argument '" + LuaUtil.toString(arg) + "' for 'events.first'.");
                }
                ((EventsLib)EventsLib.this).program.eventStorage.set(((EventsLib)EventsLib.this).program.currentConfiguration, events);
                if (!value.isNil()) {
                    id = EventsLib.this.program.addInformal("?" + value.toFancyString(EventsLib.this.program.getSymbols()));
                    ((EventsLib)EventsLib.this).program.currentActions.add(new InformalAction(((EventsLib)EventsLib.this).program.currentBehavior, id));
                }
                return EventsLib.this.coerce(value);
            }
        });
    }

    private void removeLast(LuaTable events) {
        events.set("removeLast", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                short id;
                EventImpl value;
                EventImpl[] events = ((EventsLib)EventsLib.this).program.eventStorage.get(((EventsLib)EventsLib.this).program.currentConfiguration);
                if (arg.isnil()) {
                    value = EventUtil.first(events);
                    events = EventUtil.removeFirst(events);
                } else if (arg.isint()) {
                    id = arg.toshort();
                    value = EventUtil.first(events, id);
                    events = EventUtil.removeFirst(events, id);
                } else {
                    throw new IllegalArgumentException("Invalid argument '" + LuaUtil.toString(arg) + "' for 'events.first'.");
                }
                ((EventsLib)EventsLib.this).program.eventStorage.set(((EventsLib)EventsLib.this).program.currentConfiguration, events);
                if (!value.isNil()) {
                    id = EventsLib.this.program.addInformal("?" + value.toFancyString(EventsLib.this.program.getSymbols()));
                    ((EventsLib)EventsLib.this).program.currentActions.add(new InformalAction(((EventsLib)EventsLib.this).program.currentBehavior, id));
                }
                return LuaValue.NIL;
            }
        });
    }

    private void remove(LuaTable events) {
        events.set("remove", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                if (!arg.isint()) {
                    throw new IllegalArgumentException("Invalid argument '" + LuaUtil.toString(arg) + "' for 'events.first'.");
                }
                int index = arg.toint();
                EventImpl[] events = ((EventsLib)EventsLib.this).program.eventStorage.get(((EventsLib)EventsLib.this).program.currentConfiguration);
                EventImpl value = EventUtil.get(events, index);
                events = EventUtil.remove(events, index);
                ((EventsLib)EventsLib.this).program.eventStorage.set(((EventsLib)EventsLib.this).program.currentConfiguration, events);
                if (!value.isNil()) {
                    short id = EventsLib.this.program.addInformal("?" + value.toFancyString(EventsLib.this.program.getSymbols()));
                    ((EventsLib)EventsLib.this).program.currentActions.add(new InformalAction(((EventsLib)EventsLib.this).program.currentBehavior, id));
                }
                return EventsLib.this.coerce(value);
            }
        });
    }

    private void informal(LuaTable events) {
        events.set("informal", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                if (((EventsLib)EventsLib.this).program.currentActions == null) {
                    throw new IllegalArgumentException("The 'informal' function can only be used inside transition actions.");
                }
                String informal = arg.checkjstring();
                short id = EventsLib.this.program.addInformal(informal);
                ((EventsLib)EventsLib.this).program.currentActions.add(new InformalAction(((EventsLib)EventsLib.this).program.currentBehavior, id));
                return LuaValue.NIL;
            }
        });
    }
}

