/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.ifx;

import java.io.File;
import obp.ifx.IFxConfiguration;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.xid.basics.error.Validator;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.ui.action.Action;
import org.xid.basics.ui.controller.Controller;
import org.xid.basics.ui.field.CompositeField;
import org.xid.basics.ui.field.Field;
import org.xid.basics.ui.field.TextField;

public class IFxConfigurationController
extends Controller<IFxConfiguration> {
    private final Shell parentShell;
    private CompositeField compositeField;
    private TextField ifxField;
    private TextField xercesField;
    private TextField m4Field;
    private TextField gplusplusField;
    private TextField if2m4OptionsField;
    private TextField compileOptionsField;
    private TextField linkOptionsField;
    private TextField extraLibOptionsField;

    public IFxConfigurationController(Shell parentShell) {
        this.parentShell = parentShell;
    }

    public CompositeField createFields() {
        this.ifxField = new TextField("IFx Directory");
        this.ifxField.setTooltip("IFx tool directory.");
        this.ifxField.addAction((Action)new Action.Stub("\u2026"){

            public int run(ActionMonitor monitor) {
                DirectoryDialog dialog = new DirectoryDialog(IFxConfigurationController.this.parentShell);
                dialog.setFilterPath(IFxConfigurationController.this.ifxField.getValue());
                dialog.setMessage("Choose IFx directory");
                String newIFxDirectory = dialog.open();
                if (newIFxDirectory == null) {
                    return 2;
                }
                IFxConfigurationController.this.ifxField.setValue(newIFxDirectory);
                ((IFxConfiguration)IFxConfigurationController.this.getSubject()).setIfxDirectory(newIFxDirectory);
                return 1;
            }
        });
        this.ifxField.setValidator((Validator)new Validator.Stub<String>(2, "Invalid IFx directory."){

            public boolean isValid(String value) {
                if (IFxConfigurationController.this.ifxField.getValue() == null) {
                    return false;
                }
                File fileFile = new File(IFxConfigurationController.this.ifxField.getValue(), "bin/ifsimgui.jar");
                return fileFile.exists() && fileFile.isFile();
            }
        });
        this.xercesField = new TextField("XercesLib Directory");
        this.xercesField.setTooltip("XercesC Library directory.");
        this.xercesField.addAction((Action)new Action.Stub("\u2026"){

            public int run(ActionMonitor monitor) {
                DirectoryDialog dialog = new DirectoryDialog(IFxConfigurationController.this.parentShell);
                dialog.setFilterPath(IFxConfigurationController.this.xercesField.getValue());
                dialog.setMessage("Choose XercesLib directory");
                String newXercesLibDirectory = dialog.open();
                if (newXercesLibDirectory == null) {
                    return 2;
                }
                IFxConfigurationController.this.xercesField.setValue(newXercesLibDirectory);
                ((IFxConfiguration)IFxConfigurationController.this.getSubject()).setXercesDirectory(newXercesLibDirectory);
                return 1;
            }
        });
        this.xercesField.setValidator((Validator)new Validator.Stub<String>(2, "Invalid XercesLib directory."){

            public boolean isValid(String value) {
                if (IFxConfigurationController.this.xercesField.getValue() == null) {
                    return false;
                }
                File xercesLibFile = new File(IFxConfigurationController.this.xercesField.getValue());
                return xercesLibFile.exists() && xercesLibFile.isDirectory();
            }
        });
        this.m4Field = new TextField("M4 Executable");
        this.m4Field.setTooltip("M4 executable path.");
        this.m4Field.addAction((Action)new Action.Stub("\u2026"){

            public int run(ActionMonitor monitor) {
                String newGcc;
                FileDialog dialog = new FileDialog(IFxConfigurationController.this.parentShell);
                if (IFxConfigurationController.this.m4Field.getValue() != null) {
                    File gccFile = new File(IFxConfigurationController.this.m4Field.getValue());
                    dialog.setFilterPath(gccFile.getParent());
                    dialog.setFileName(gccFile.getName());
                }
                if ((newGcc = dialog.open()) == null) {
                    return 2;
                }
                IFxConfigurationController.this.m4Field.setValue(newGcc);
                ((IFxConfiguration)IFxConfigurationController.this.getSubject()).setM4(newGcc);
                return 1;
            }
        });
        this.m4Field.setValidator((Validator)new Validator.Stub<String>(2, "Invalid m4 file."){

            public boolean isValid(String value) {
                if (IFxConfigurationController.this.m4Field.getValue() == null) {
                    return false;
                }
                File file = new File(IFxConfigurationController.this.m4Field.getValue());
                return file.exists() && file.isFile() && file.canExecute();
            }
        });
        this.gplusplusField = new TextField("G++ Executable");
        this.gplusplusField.setTooltip("G++ executable path.");
        this.gplusplusField.addAction((Action)new Action.Stub("\u2026"){

            public int run(ActionMonitor monitor) {
                String newGcc;
                FileDialog dialog = new FileDialog(IFxConfigurationController.this.parentShell);
                if (IFxConfigurationController.this.gplusplusField.getValue() != null) {
                    File gccFile = new File(IFxConfigurationController.this.gplusplusField.getValue());
                    dialog.setFilterPath(gccFile.getParent());
                    dialog.setFileName(gccFile.getName());
                }
                if ((newGcc = dialog.open()) == null) {
                    return 2;
                }
                IFxConfigurationController.this.gplusplusField.setValue(newGcc);
                ((IFxConfiguration)IFxConfigurationController.this.getSubject()).setGplusplus(newGcc);
                return 1;
            }
        });
        this.gplusplusField.setValidator((Validator)new Validator.Stub<String>(2, "Invalid g++ file."){

            public boolean isValid(String value) {
                if (IFxConfigurationController.this.gplusplusField.getValue() == null) {
                    return false;
                }
                File file = new File(IFxConfigurationController.this.gplusplusField.getValue());
                return file.exists() && file.isFile() && file.canExecute();
            }
        });
        this.if2m4OptionsField = new TextField("Options for if2m4");
        this.if2m4OptionsField.setTooltip("If2m4 options to use.");
        this.compileOptionsField = new TextField("Compile flags");
        this.compileOptionsField.setTooltip("Extra G++ compilation flags.");
        this.linkOptionsField = new TextField("Link flags");
        this.linkOptionsField.setTooltip("Extra G++ link flags.");
        this.extraLibOptionsField = new TextField("Extra libs");
        this.extraLibOptionsField.setTooltip("Extra G++ libraries flags.");
        this.compositeField = new CompositeField("IFx Configuration", new Field[]{this.ifxField, this.xercesField, this.m4Field, this.gplusplusField, this.if2m4OptionsField, this.compileOptionsField, this.linkOptionsField, this.extraLibOptionsField});
        return this.compositeField;
    }

    public void refreshFields() {
        if (this.getSubject() == null) {
            this.compositeField.setEnable(false);
        } else {
            this.compositeField.setEnable(true);
            this.ifxField.setValue(((IFxConfiguration)this.getSubject()).getIfxDirectory());
            this.xercesField.setValue(((IFxConfiguration)this.getSubject()).getXercesDirectory());
            this.m4Field.setValue(((IFxConfiguration)this.getSubject()).getM4());
            this.gplusplusField.setValue(((IFxConfiguration)this.getSubject()).getGplusplus());
            this.if2m4OptionsField.setValue(((IFxConfiguration)this.getSubject()).getIf2m4Options());
            this.compileOptionsField.setValue(((IFxConfiguration)this.getSubject()).getCompileOptions());
            this.linkOptionsField.setValue(((IFxConfiguration)this.getSubject()).getLinkOptions());
            this.extraLibOptionsField.setValue(((IFxConfiguration)this.getSubject()).getExtraLibOptions());
        }
    }

    public boolean updateSubject(Field field) {
        if (field == this.ifxField) {
            ((IFxConfiguration)this.getSubject()).setIfxDirectory(this.ifxField.getValue());
            return true;
        }
        if (field == this.xercesField) {
            ((IFxConfiguration)this.getSubject()).setXercesDirectory(this.xercesField.getValue());
            return true;
        }
        if (field == this.m4Field) {
            ((IFxConfiguration)this.getSubject()).setM4(this.m4Field.getValue());
            return true;
        }
        if (field == this.gplusplusField) {
            ((IFxConfiguration)this.getSubject()).setGplusplus(this.gplusplusField.getValue());
            return true;
        }
        if (field == this.if2m4OptionsField) {
            ((IFxConfiguration)this.getSubject()).setIf2m4Options(this.if2m4OptionsField.getValue());
            return true;
        }
        if (field == this.compileOptionsField) {
            ((IFxConfiguration)this.getSubject()).setCompileOptions(this.compileOptionsField.getValue());
            return true;
        }
        if (field == this.linkOptionsField) {
            ((IFxConfiguration)this.getSubject()).setLinkOptions(this.linkOptionsField.getValue());
            return true;
        }
        if (field == this.extraLibOptionsField) {
            ((IFxConfiguration)this.getSubject()).setExtraLibOptions(this.extraLibOptionsField.getValue());
            return true;
        }
        return super.updateSubject(field);
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }
}

